/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.cooking;

import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import org.spongepowered.common.item.recipe.cooking.SpongeCookingRecipeSerializer;
import org.spongepowered.common.item.recipe.crafting.custom.SpongeSpecialCraftingRecipeRegistration;
import org.spongepowered.common.item.recipe.crafting.shaped.SpongeShapedCraftingRecipeSerializer;
import org.spongepowered.common.item.recipe.crafting.shapeless.SpongeShapelessCraftingRecipeSerializer;
import org.spongepowered.common.item.recipe.smithing.SpongeSmithingRecipeSerializer;
import org.spongepowered.common.item.recipe.stonecutting.SpongeStonecuttingRecipeSerializer;

public interface SpongeRecipeSerializers {
    public static final SpongeCookingRecipeSerializer<BlastingRecipe> SPONGE_BLASTING = SpongeRecipeSerializers.register("blasting", new SpongeCookingRecipeSerializer.Blasting());
    public static final SpongeCookingRecipeSerializer<CampfireCookingRecipe> SPONGE_CAMPFIRE_COOKING = SpongeRecipeSerializers.register("campfire_cooking", new SpongeCookingRecipeSerializer.Campfire());
    public static final SpongeCookingRecipeSerializer<SmeltingRecipe> SPONGE_SMELTING = SpongeRecipeSerializers.register("smelting", new SpongeCookingRecipeSerializer.Smelting());
    public static final RecipeSerializer<?> SPONGE_CRAFTING_SHAPED = SpongeRecipeSerializers.register("crafting_shaped", new SpongeShapedCraftingRecipeSerializer());
    public static final RecipeSerializer<?> SPONGE_CRAFTING_SHAPELESS = SpongeRecipeSerializers.register("crafting_shapeless", new SpongeShapelessCraftingRecipeSerializer());
    public static final RecipeSerializer<?> SPONGE_SMITHING = SpongeRecipeSerializers.register("smithing", new SpongeSmithingRecipeSerializer());
    public static final RecipeSerializer<?> SPONGE_STONECUTTING = SpongeRecipeSerializers.register("stonecutting", new SpongeStonecuttingRecipeSerializer());
    public static final SpongeCookingRecipeSerializer<SmokingRecipe> SPONGE_SMOKING = SpongeRecipeSerializers.register("smoking", new SpongeCookingRecipeSerializer.Smoking());
    public static final SimpleRecipeSerializer<?> SPONGE_SPECIAL = SpongeRecipeSerializers.register("special", new SimpleRecipeSerializer(SpongeSpecialCraftingRecipeRegistration.RECIPES::get));

    public static <S extends RecipeSerializer<T>, T extends Recipe<?>> S register(String spongeName, S recipeSerializer) {
        return (S)((RecipeSerializer)Registry.register((Registry)Registry.RECIPE_SERIALIZER, (String)new ResourceLocation("sponge", spongeName).toString(), recipeSerializer));
    }

    public static <S extends RecipeSerializer<T>, T extends Recipe<?>> S register(ResourceLocation resourceLocation, S recipeSerializer) {
        return (S)((RecipeSerializer)Registry.register((Registry)Registry.RECIPE_SERIALIZER, (String)resourceLocation.toString(), recipeSerializer));
    }
}

