/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.crafting.shaped;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.spongepowered.common.item.recipe.SpongeRecipeRegistration;
import org.spongepowered.common.item.recipe.ingredient.IngredientResultUtil;

public class SpongeShapedCraftingRecipeRegistration
extends SpongeRecipeRegistration {
    private final Item result;
    private final int count;
    private final List<String> pattern;
    private final Map<Character, Ingredient> ingredientMap;
    private final ItemStack spongeResult;
    private final Function<CraftingContainer, ItemStack> resultFunction;
    private final Function<CraftingContainer, NonNullList<ItemStack>> remainingItemsFunction;

    public SpongeShapedCraftingRecipeRegistration(ResourceLocation key, RecipeSerializer<?> serializer, String group, List<String> pattern, Map<Character, Ingredient> ingredients, ItemStack spongeResult, Function<CraftingContainer, ItemStack> resultFunction, Function<CraftingContainer, NonNullList<ItemStack>> remainingItemsFunction) {
        super(key, serializer, spongeResult.getItem(), group);
        this.result = spongeResult.getItem();
        this.count = spongeResult.getCount();
        this.pattern = pattern;
        this.ingredientMap = ingredients;
        this.spongeResult = spongeResult;
        this.resultFunction = resultFunction;
        this.remainingItemsFunction = remainingItemsFunction;
    }

    @Override
    public void serializeShape(JsonObject json) {
        JsonArray jsonarray = new JsonArray();
        this.pattern.forEach(jsonarray::add);
        json.add("pattern", jsonarray);
        JsonObject jsonobject = new JsonObject();
        this.ingredientMap.forEach((key, value) -> jsonobject.add(String.valueOf(key), value.toJson()));
        json.add("key", jsonobject);
    }

    @Override
    public void serializeResult(JsonObject json) {
        JsonObject result = new JsonObject();
        result.addProperty("item", Registry.ITEM.getKey((Object)this.result).toString());
        if (this.count > 1) {
            result.addProperty("count", this.count);
        }
        json.add("result", result);
        if (this.spongeResult != null) {
            json.add("sponge:result", IngredientResultUtil.serializeItemStack(this.spongeResult));
        }
        if (this.resultFunction != null) {
            json.addProperty("sponge:result_function", IngredientResultUtil.cacheResultFunction(this.getId(), this.resultFunction));
        }
        if (this.remainingItemsFunction != null) {
            json.addProperty("sponge:remaining_items", IngredientResultUtil.cacheRemainingItemsFunction(this.getId(), this.remainingItemsFunction));
        }
    }
}

