/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.stonecutting;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.recipe.RecipeRegistration;
import org.spongepowered.api.item.recipe.single.StoneCutterRecipe;
import org.spongepowered.common.inventory.util.InventoryUtil;
import org.spongepowered.common.item.recipe.SpongeRecipeRegistration;
import org.spongepowered.common.item.recipe.cooking.SpongeRecipeSerializers;
import org.spongepowered.common.item.recipe.ingredient.IngredientUtil;
import org.spongepowered.common.item.recipe.stonecutting.SpongeStonecuttingRecipeRegistration;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.AbstractResourceKeyedBuilder;

public final class SpongeStoneCutterRecipeBuilder
extends AbstractResourceKeyedBuilder<RecipeRegistration, StoneCutterRecipe.Builder>
implements StoneCutterRecipe.Builder,
StoneCutterRecipe.Builder.ResultStep,
StoneCutterRecipe.Builder.EndStep {
    private org.spongepowered.api.item.inventory.ItemStack result;
    private Ingredient ingredient;
    private Function<Container, ItemStack> resultFunction;
    private @Nullable String group;

    @Override
    public StoneCutterRecipe.Builder.ResultStep ingredient(ItemType ingredient) {
        this.ingredient = Ingredient.of((ItemLike[])new ItemLike[]{() -> (Item)ingredient});
        return this;
    }

    @Override
    public StoneCutterRecipe.Builder.ResultStep ingredient(org.spongepowered.api.item.recipe.crafting.Ingredient ingredient) {
        this.ingredient = IngredientUtil.toNative(ingredient);
        return this;
    }

    @Override
    public StoneCutterRecipe.Builder.EndStep result(ItemStackSnapshot result) {
        this.result = result.createStack();
        this.resultFunction = null;
        return this;
    }

    @Override
    public StoneCutterRecipe.Builder.EndStep result(org.spongepowered.api.item.inventory.ItemStack result) {
        Preconditions.checkNotNull((Object)result, (Object)"result");
        this.result = result;
        this.resultFunction = null;
        return this;
    }

    @Override
    public StoneCutterRecipe.Builder.EndStep result(Function<Inventory, org.spongepowered.api.item.inventory.ItemStack> resultFunction, org.spongepowered.api.item.inventory.ItemStack exemplaryResult) {
        Preconditions.checkNotNull((Object)exemplaryResult, (Object)"exemplaryResult");
        Preconditions.checkState((!exemplaryResult.isEmpty() ? 1 : 0) != 0, (Object)"exemplaryResult must not be empty");
        this.result = exemplaryResult;
        this.resultFunction = inv -> ItemStackUtil.toNative((org.spongepowered.api.item.inventory.ItemStack)resultFunction.apply(InventoryUtil.toInventory(inv)));
        return this;
    }

    @Override
    public StoneCutterRecipe.Builder.EndStep group(@Nullable String name) {
        this.group = name;
        return this;
    }

    @Override
    public RecipeRegistration build0() {
        ItemStack result = ItemStackUtil.toNative(this.result);
        RecipeSerializer<?> serializer = SpongeRecipeRegistration.determineSerializer(result, this.resultFunction, null, Collections.singleton(this.ingredient), RecipeSerializer.STONECUTTER, SpongeRecipeSerializers.SPONGE_STONECUTTING);
        return new SpongeStonecuttingRecipeRegistration((ResourceLocation)this.key, serializer, this.group, this.ingredient, result, this.resultFunction);
    }

    @Override
    public StoneCutterRecipe.Builder reset() {
        this.result = null;
        this.resultFunction = null;
        this.ingredient = null;
        this.group = null;
        return (StoneCutterRecipe.Builder)super.reset();
    }
}

