/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.stonecutting;

import com.google.gson.JsonObject;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SingleItemRecipe;
import net.minecraft.world.level.ItemLike;
import org.spongepowered.common.item.recipe.ingredient.IngredientResultUtil;
import org.spongepowered.common.item.recipe.ingredient.IngredientUtil;
import org.spongepowered.common.item.recipe.stonecutting.SpongeStonecuttingRecipe;

public class SpongeStonecuttingRecipeSerializer<R extends SingleItemRecipe>
implements RecipeSerializer<R> {
    public R fromJson(ResourceLocation recipeId, JsonObject json) {
        String group = GsonHelper.getAsString((JsonObject)json, (String)"group", (String)"");
        Ingredient ingredient = IngredientUtil.spongeDeserialize(json.get("ingredient"));
        Function<Container, ItemStack> resultFunction = IngredientResultUtil.deserializeResultFunction(json);
        ItemStack spongeStack = IngredientResultUtil.deserializeItemStack(json.getAsJsonObject("sponge:result"));
        if (spongeStack != null) {
            return (R)((Object)new SpongeStonecuttingRecipe(recipeId, group, ingredient, spongeStack, resultFunction));
        }
        String type = GsonHelper.getAsString((JsonObject)json, (String)"result");
        int count = GsonHelper.getAsInt((JsonObject)json, (String)"count");
        ItemStack itemstack = new ItemStack((ItemLike)Registry.ITEM.get(new ResourceLocation(type)), count);
        return (R)((Object)new SpongeStonecuttingRecipe(recipeId, group, ingredient, itemstack, resultFunction));
    }

    public R fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        throw new UnsupportedOperationException("custom serializer needs client side support");
    }

    public void toNetwork(FriendlyByteBuf buffer, R recipe) {
        throw new UnsupportedOperationException("custom serializer needs client side support");
    }
}

