/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.block;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.minecraft.core.Holder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.StateDefinition;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.registry.DefaultedRegistryType;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.state.StateProperty;
import org.spongepowered.api.tag.Tag;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.data.holder.SpongeImmutableDataHolder;
import org.spongepowered.common.mixin.api.minecraft.block.AbstractBlockMixin_API;

@Mixin(value={Block.class}, priority=999)
public abstract class BlockMixin_API
extends AbstractBlockMixin_API
implements SpongeImmutableDataHolder<BlockType> {
    @Shadow
    @Final
    protected StateDefinition<Block, net.minecraft.world.level.block.state.BlockState> stateDefinition;
    @Shadow
    @Final
    private Holder.Reference<Block> builtInRegistryHolder;

    @Shadow
    public abstract String shadow$getDescriptionId();

    @Shadow
    public abstract net.minecraft.world.level.block.state.BlockState shadow$defaultBlockState();

    @Override
    public ImmutableList<BlockState> validStates() {
        return this.stateDefinition.getPossibleStates();
    }

    @Override
    public BlockState defaultState() {
        return (BlockState)this.shadow$defaultBlockState();
    }

    @Override
    public Optional<ItemType> item() {
        Item item = this.shadow$asItem();
        if (item == Items.AIR) {
            return Optional.empty();
        }
        return Optional.ofNullable((ItemType)item);
    }

    public Component asComponent() {
        return Component.translatable((String)this.shadow$getDescriptionId());
    }

    @Override
    public Collection<StateProperty<?>> stateProperties() {
        return this.stateDefinition.getProperties();
    }

    @Override
    public Optional<StateProperty<?>> findStateProperty(String name) {
        return Optional.ofNullable((StateProperty)this.stateDefinition.getProperty(name));
    }

    @Override
    public boolean isAnyOf(Supplier<? extends BlockType> ... types) {
        return Arrays.stream(types).map(Supplier::get).anyMatch(type -> type == this);
    }

    @Override
    public boolean isAnyOf(BlockType ... types) {
        return Arrays.stream(types).anyMatch(type -> type == this);
    }

    @Override
    public DefaultedRegistryType<BlockType> registryType() {
        return RegistryTypes.BLOCK_TYPE;
    }

    @Override
    public Collection<Tag<BlockType>> tags() {
        return this.registryType().get().tags().filter(this::is).collect(Collectors.toSet());
    }

    @Override
    public boolean is(Tag<BlockType> tag) {
        return this.builtInRegistryHolder.is((TagKey)tag);
    }
}

