/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.item;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import org.spongepowered.api.entity.living.player.CooldownTracker;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.world.item.ItemCooldowns_CooldownInstanceAccessor;
import org.spongepowered.common.bridge.world.item.ItemCooldownsBridge;

@Mixin(value={ItemCooldowns.class})
public abstract class ItemCooldownsMixin_API
implements CooldownTracker {
    @Shadow
    @Final
    private Map<Item, ?> cooldowns;
    @Shadow
    private int tickCount;

    @Shadow
    public abstract boolean shadow$isOnCooldown(Item var1);

    @Shadow
    public abstract float shadow$getCooldownPercent(Item var1, float var2);

    @Shadow
    public abstract void shadow$addCooldown(Item var1, int var2);

    @Override
    public boolean hasCooldown(ItemType type) {
        Preconditions.checkNotNull((Object)type, (Object)"Item type cannot be null!");
        return this.shadow$isOnCooldown((Item)type);
    }

    @Override
    public Optional<Ticks> cooldown(ItemType type) {
        int remainingCooldown;
        Preconditions.checkNotNull((Object)type, (Object)"Item type cannot be null!");
        ItemCooldowns_CooldownInstanceAccessor cooldown = (ItemCooldowns_CooldownInstanceAccessor)this.cooldowns.get((Item)type);
        if (cooldown != null && (remainingCooldown = cooldown.accessor$endTime() - this.tickCount) > 0) {
            return Optional.of(Ticks.of(remainingCooldown));
        }
        return Optional.empty();
    }

    @Override
    public boolean setCooldown(ItemType type, Ticks ticks) {
        Preconditions.checkNotNull((Object)type, (Object)"Item type cannot be null!");
        this.shadow$addCooldown((Item)type, (int)ticks.ticks());
        return ((ItemCooldownsBridge)((Object)this)).bridge$getSetCooldownResult();
    }

    @Override
    public boolean resetCooldown(ItemType type) {
        return this.setCooldown(type, Ticks.zero());
    }

    @Override
    public OptionalDouble fractionRemaining(ItemType type) {
        Objects.requireNonNull(type, "Item type cannot be null!");
        float cooldown = this.shadow$getCooldownPercent((Item)type, 0.0f);
        if (cooldown > 0.0f) {
            return OptionalDouble.of(cooldown);
        }
        return OptionalDouble.empty();
    }
}

