/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level.block.entity;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.entity.BlockEntityArchetype;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.block.entity.SpongeBlockEntityArchetypeBuilder;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.server.SpongeLocatableBlockBuilder;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={BlockEntity.class})
public abstract class BlockEntityMixin_API
implements org.spongepowered.api.block.entity.BlockEntity {
    @Shadow
    @Final
    private BlockEntityType<?> type;
    @Shadow
    protected Level level;
    @Shadow
    protected boolean remove;
    @Shadow
    @Final
    protected BlockPos worldPosition;
    @Nullable
    private LocatableBlock api$LocatableBlock;

    @Shadow
    public abstract BlockPos shadow$getBlockPos();

    @Shadow
    public abstract CompoundTag shadow$saveWithFullMetadata();

    public ServerLocation location() {
        return ServerLocation.of((ServerWorld)this.level, VecHelper.toVector3i(this.shadow$getBlockPos()));
    }

    @Override
    public ServerLocation serverLocation() {
        if (this.level == null) {
            throw new RuntimeException("The TileEntity has not been spawned in a world yet!");
        }
        if (this.level.isClientSide) {
            throw new RuntimeException("You should not attempt to make a server-side location on the client!");
        }
        BlockPos pos = this.shadow$getBlockPos();
        return ServerLocation.of((ServerWorld)this.level, pos.getX(), pos.getY(), pos.getZ());
    }

    @Override
    public World<?, ?> world() {
        return (World)this.level;
    }

    @Override
    public Vector3i blockPosition() {
        return VecHelper.toVector3i(this.shadow$getBlockPos());
    }

    @Override
    public int contentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        ResourceKey key = (ResourceKey)Registry.BLOCK_ENTITY_TYPE.getKey(this.type);
        DataContainer container = DataContainer.createNew().set(Queries.CONTENT_VERSION, this.contentVersion()).set(Queries.WORLD_KEY, ((ServerWorld)this.level).key()).set(Queries.POSITION_X, this.shadow$getBlockPos().getX()).set(Queries.POSITION_Y, this.shadow$getBlockPos().getY()).set(Queries.POSITION_Z, this.shadow$getBlockPos().getZ()).set(Constants.TileEntity.TILE_TYPE, key);
        CompoundTag compound = this.shadow$saveWithFullMetadata();
        Constants.NBT.filterSpongeCustomData(compound);
        container.set(Constants.Sponge.UNSAFE_NBT, NBTTranslator.INSTANCE.translateFrom(compound));
        return container;
    }

    @Override
    public boolean validateRawData(DataView container) {
        return container.contains(Queries.WORLD_KEY) && container.contains(Queries.POSITION_X) && container.contains(Queries.POSITION_Y) && container.contains(Queries.POSITION_Z) && container.contains(Constants.TileEntity.TILE_TYPE) && container.contains(Constants.Sponge.UNSAFE_NBT);
    }

    @Override
    public boolean isValid() {
        return !this.remove;
    }

    @Override
    public void setValid(boolean valid) {
        this.remove = valid;
    }

    @Override
    public final org.spongepowered.api.block.entity.BlockEntityType type() {
        return (org.spongepowered.api.block.entity.BlockEntityType)this.type;
    }

    @Override
    public BlockState block() {
        return (BlockState)this.level.getBlockState(this.shadow$getBlockPos());
    }

    @Override
    public BlockEntityArchetype createArchetype() {
        return SpongeBlockEntityArchetypeBuilder.pooled().blockEntity(this).build();
    }

    @Override
    public LocatableBlock locatableBlock() {
        if (this.api$LocatableBlock == null) {
            BlockState blockState = this.block();
            this.api$LocatableBlock = new SpongeLocatableBlockBuilder().world((ServerWorld)this.level).position(this.shadow$getBlockPos().getX(), this.shadow$getBlockPos().getY(), this.shadow$getBlockPos().getZ()).state(blockState).build();
        }
        return this.api$LocatableBlock;
    }

    @Override
    public Set<Value.Immutable<?>> getValues() {
        return this.api$getVanillaValues();
    }

    protected Set<Value.Immutable<?>> api$getVanillaValues() {
        return new HashSet();
    }
}

