/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.advancements;

import com.google.gson.JsonObject;
import java.util.UUID;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.advancement.criterion.SpongeScoreCriterion;
import org.spongepowered.common.advancement.criterion.SpongeScoreTrigger;
import org.spongepowered.common.bridge.advancements.CriterionBridge;

@Mixin(value={Criterion.class})
public abstract class CriterionMixin
implements CriterionBridge {
    @Shadow
    @Final
    private CriterionTriggerInstance trigger;
    private @Nullable String impl$name;
    private @Nullable SpongeScoreCriterion impl$scoreCriterion;
    private @Nullable Integer impl$scoreGoal;
    private @Nullable String impl$scoreCriterionName;

    @Inject(method={"criterionFromJson"}, at={@At(value="RETURN")})
    private static void impl$fixTriggerTimeDeserializer(JsonObject json, DeserializationContext p_232633_1_, CallbackInfoReturnable<Criterion> ci) {
        Criterion criterion = (Criterion)ci.getReturnValue();
        if (json.has("trigger_times")) {
            ((CriterionBridge)criterion).bridge$setScoreGoal(json.get("trigger_times").getAsInt());
        }
        if (json.has("criterion")) {
            ((CriterionBridge)criterion).bridge$setScoreCriterionName(json.get("criterion").getAsString());
        }
    }

    @Inject(method={"serializeToJson"}, at={@At(value="RETURN")})
    private void impl$serializeTriggerTimes(CallbackInfoReturnable<JsonObject> cir) {
        if (this.trigger instanceof SpongeScoreTrigger.Instance) {
            ((JsonObject)cir.getReturnValue()).addProperty("trigger_times", ((SpongeScoreTrigger.Instance)this.trigger).getTriggerTimes());
        }
        if (this.impl$scoreCriterion != null) {
            ((JsonObject)cir.getReturnValue()).addProperty("criterion", this.impl$scoreCriterion.name());
        }
    }

    @Override
    public String bridge$getName() {
        if (this.impl$name == null) {
            this.impl$name = UUID.randomUUID().toString().replace("-", "");
        }
        return this.impl$name;
    }

    @Override
    public void bridge$setName(String name) {
        this.impl$name = name;
    }

    @Override
    public @Nullable SpongeScoreCriterion bridge$getScoreCriterion() {
        return this.impl$scoreCriterion;
    }

    @Override
    public void bridge$setScoreCriterion(@Nullable SpongeScoreCriterion criterion) {
        this.impl$scoreCriterion = criterion;
    }

    @Override
    public @Nullable Integer bridge$getScoreGoal() {
        return this.impl$scoreGoal;
    }

    @Override
    public void bridge$setScoreGoal(@Nullable Integer goal) {
        this.impl$scoreGoal = goal;
    }

    @Override
    public void bridge$setScoreCriterionName(String name) {
        this.impl$scoreCriterionName = name;
    }

    @Override
    public @Nullable String bridge$getScoreCriterionName() {
        return this.impl$scoreCriterionName;
    }
}

