/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.client;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.main.GameConfig;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.WorldStem;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.thread.ReentrantBlockableEventLoop;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.WorldData;
import org.spongepowered.api.datapack.DataPackTypes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.applaunch.config.core.ConfigHandle;
import org.spongepowered.common.bridge.client.MinecraftBridge;
import org.spongepowered.common.client.SpongeClient;
import org.spongepowered.common.datapack.SpongeDataPackManager;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.common.launch.Lifecycle;
import org.spongepowered.common.server.BootstrapProperties;

@Mixin(value={Minecraft.class})
public abstract class MinecraftMixin
extends ReentrantBlockableEventLoop<Runnable>
implements MinecraftBridge,
SpongeClient {
    @Shadow
    private Thread gameThread;
    @Shadow
    @Nullable
    private IntegratedServer singleplayerServer;
    private IntegratedServer impl$temporaryIntegratedServer;

    @Shadow
    public abstract boolean renderOnThread();

    @Shadow
    public abstract void pauseGame(boolean var1);

    public MinecraftMixin(String param0) {
        super(param0);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void impl$setClientOnGame(GameConfig gameConfig, CallbackInfo ci) {
        SpongeCommon.game().setClient(this);
    }

    @Inject(method={"run"}, at={@At(value="HEAD")})
    private void impl$setThreadOnClientPhaseTracker(CallbackInfo ci) {
        try {
            PhaseTracker.CLIENT.setThread(this.gameThread);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not initialize the client PhaseTracker!");
        }
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void impl$callStartedEngineAndLoadedGame(CallbackInfo ci) {
        ConfigHandle.setSaveSuppressed(false);
        Lifecycle lifecycle = ((Launch)Launch.instance()).lifecycle();
        lifecycle.callStartedEngineEvent(this);
        lifecycle.callLoadedGameEvent();
    }

    @Redirect(method={"runTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;runAllTasks()V"))
    private void impl$tickClientScheduler(Minecraft minecraft) {
        this.scheduler().tick();
        this.runAllTasks();
    }

    @Redirect(method={"makeWorldStem(Lnet/minecraft/server/packs/repository/PackRepository;ZLnet/minecraft/server/WorldStem$DataPackConfigSupplier;Lnet/minecraft/server/WorldStem$WorldDataSupplier;)Lnet/minecraft/server/WorldStem;"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/WorldStem;load(Lnet/minecraft/server/WorldStem$InitConfig;Lnet/minecraft/server/WorldStem$DataPackConfigSupplier;Lnet/minecraft/server/WorldStem$WorldDataSupplier;Ljava/util/concurrent/Executor;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;"))
    private CompletableFuture<WorldStem> impl$serializeDelayedDataPackOnLoadAndSetBootstrapProperties(WorldStem.InitConfig initConfig, WorldStem.DataPackConfigSupplier dataPackConfigSupplier, WorldStem.WorldDataSupplier worldDataSupplier, Executor executor1, Executor executor2) {
        return WorldStem.load((WorldStem.InitConfig)initConfig, (WorldStem.DataPackConfigSupplier)dataPackConfigSupplier, (rm, dpc) -> {
            SpongeDataPackManager.INSTANCE.serializeDelayedDataPack(DataPackTypes.WORLD);
            Pair pair = worldDataSupplier.get(rm, dpc);
            WorldData saveData = (WorldData)pair.getFirst();
            BootstrapProperties.init(saveData.worldGenSettings(), saveData.getGameType(), saveData.getDifficulty(), true, saveData.isHardcore(), saveData.getAllowCommands(), 10, (RegistryAccess)pair.getSecond());
            return pair;
        }, (Executor)executor1, (Executor)executor2);
    }

    @Override
    public IntegratedServer bridge$getTemporaryIntegratedServer() {
        return this.impl$temporaryIntegratedServer;
    }

    @Override
    public void bridge$setTemporaryIntegratedServer(IntegratedServer server) {
        this.impl$temporaryIntegratedServer = server;
    }

    @Inject(method={"destroy"}, at={@At(value="HEAD")})
    private void impl$callStoppingEngineEvent(CallbackInfo ci) {
        ((Launch)Launch.instance()).lifecycle().callStoppingEngineEvent(this);
    }

    @Redirect(method={"clearLevel(Lnet/minecraft/client/gui/screens/Screen;)V"}, at=@At(value="FIELD", target="Lnet/minecraft/client/Minecraft;singleplayerServer:Lnet/minecraft/client/server/IntegratedServer;", opcode=181))
    private void impl$storeTemporaryServerRef(Minecraft minecraft, IntegratedServer server) {
        ((MinecraftBridge)minecraft).bridge$setTemporaryIntegratedServer(this.singleplayerServer);
        this.singleplayerServer = null;
    }

    @Inject(method={"clearLevel(Lnet/minecraft/client/gui/screens/Screen;)V"}, at={@At(value="TAIL")})
    private void impl$nullServerRefAndPhaseTracker(Screen screenIn, CallbackInfo ci) {
        this.bridge$setTemporaryIntegratedServer(null);
        try {
            PhaseTracker.SERVER.setThread(null);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    @Inject(method={"close"}, at={@At(value="INVOKE", target="Lnet/minecraft/Util;shutdownExecutors()V")})
    private void impl$callStoppedGame(CallbackInfo ci) {
        ((Launch)Launch.instance()).lifecycle().callStoppedGameEvent();
    }

    @Redirect(method={"lambda$createLevel$33"}, at=@At(value="INVOKE", target="Lnet/minecraft/resources/RegistryOps;createAndLoad(Lcom/mojang/serialization/DynamicOps;Lnet/minecraft/core/RegistryAccess$Writable;Lnet/minecraft/server/packs/resources/ResourceManager;)Lnet/minecraft/resources/RegistryOps;"))
    private static <T> RegistryOps<T> impl$setWorldSettingsAdapter(DynamicOps<T> ops, RegistryAccess.Writable registryAccess, ResourceManager resourceManager) {
        RegistryOps worldSettingsAdapter = RegistryOps.createAndLoad(ops, (RegistryAccess.Writable)registryAccess, (ResourceManager)resourceManager);
        BootstrapProperties.worldSettingsAdapter(worldSettingsAdapter);
        return worldSettingsAdapter;
    }

    @Inject(method={"createLevel"}, at={@At(value="HEAD")})
    private void impl$setIsNewLevel(CallbackInfo ci) {
        BootstrapProperties.setIsNewLevel(true);
    }

    @Redirect(method={"createPackRepository "}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/storage/LevelStorageSource$LevelStorageAccess;getLevelPath(Lnet/minecraft/world/level/storage/LevelResource;)Ljava/nio/file/Path;"))
    private static Path impl$configurePackRepository(LevelStorageSource.LevelStorageAccess levelSave, LevelResource folderName) {
        Path datapackDir = levelSave.getLevelPath(folderName);
        ((Launch)Launch.instance()).lifecycle().callRegisterDataPackValueEvent(datapackDir);
        return datapackDir;
    }
}

