/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.network;

import java.util.Locale;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.util.locale.Locales;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.adventure.NativeComponentRenderer;
import org.spongepowered.common.bridge.network.FriendlyByteBufBridge;

@Mixin(value={FriendlyByteBuf.class})
public abstract class FriendlyByteBufMixin
implements FriendlyByteBufBridge {
    private @Nullable Locale impl$locale;

    @ModifyVariable(method={"writeComponent"}, at=@At(value="HEAD"), argsOnly=true)
    private Component localizeComponent(Component input) {
        return NativeComponentRenderer.apply(input, this.impl$locale == null ? Locales.DEFAULT : this.impl$locale);
    }

    @Override
    public CompoundTag bridge$renderItemComponents(CompoundTag tag) {
        String nameStr;
        MutableComponent name;
        Component renderedName;
        if (tag == null || !tag.contains("display", 10)) {
            return tag;
        }
        Locale locale = this.impl$locale == null ? Locales.DEFAULT : this.impl$locale;
        CompoundTag display = tag.getCompound("display");
        boolean copy = true;
        if (display.contains("Name", 8) && !(renderedName = NativeComponentRenderer.apply((Component)(name = Component.Serializer.fromJson((String)(nameStr = display.getString("Name")))), locale)).equals(name)) {
            if (copy) {
                tag = tag.copy();
                display = tag.getCompound("display");
                copy = false;
            }
            display.putString("SpongeOriginalName", nameStr);
            display.putString("Name", Component.Serializer.toJson((Component)renderedName));
        }
        if (display.contains("Lore", 9)) {
            ListTag lore = display.getList("Lore", 8);
            Component[] renderedLines = new Component[lore.size()];
            boolean equal = true;
            for (int i = 0; i < renderedLines.length; ++i) {
                Component renderedLine;
                String lineStr = lore.getString(i);
                MutableComponent line = Component.Serializer.fromJson((String)lineStr);
                renderedLines[i] = renderedLine = NativeComponentRenderer.apply((Component)line, locale);
                equal = equal && renderedLine.equals(line);
            }
            if (!equal) {
                if (copy) {
                    tag = tag.copy();
                    display = tag.getCompound("display");
                    copy = false;
                }
                ListTag newLore = new ListTag();
                for (Component renderedLine : renderedLines) {
                    newLore.add((Object)StringTag.valueOf((String)Component.Serializer.toJson((Component)renderedLine)));
                }
                display.put("SpongeOriginalLore", (Tag)lore);
                display.put("Lore", (Tag)newLore);
            }
        }
        return tag;
    }

    @Redirect(method={"readItem"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/FriendlyByteBuf;readNbt()Lnet/minecraft/nbt/CompoundTag;"))
    public CompoundTag restoreItemComponents(FriendlyByteBuf buf) {
        CompoundTag tag = buf.readNbt();
        if (tag == null || !tag.contains("display", 10)) {
            return tag;
        }
        CompoundTag display = tag.getCompound("display");
        if (display.contains("SpongeOriginalName", 8)) {
            String name = display.getString("SpongeOriginalName");
            display.remove("SpongeOriginalName");
            display.putString("Name", name);
        }
        if (display.contains("SpongeOriginalLore", 9)) {
            ListTag lore = display.getList("SpongeOriginalLore", 8);
            display.remove("SpongeOriginalLore");
            display.put("Lore", (Tag)lore);
        }
        return tag;
    }

    @Override
    public void bridge$setLocale(Locale locale) {
        this.impl$locale = locale;
    }
}

