/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.level;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetHealthPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateAttributesPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.food.FoodData;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Keys;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.data.SpongeDataHolderBridge;
import org.spongepowered.common.bridge.server.level.ServerPlayerEntityHealthScaleBridge;
import org.spongepowered.common.mixin.core.world.entity.player.PlayerMixin;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin_HealthScale
extends PlayerMixin
implements ServerPlayerEntityHealthScaleBridge {
    @Shadow
    private float lastSentHealth;
    @Shadow
    public ServerGamePacketListenerImpl connection;
    private AttributeInstance impl$cachedMaxHealthAttribute = null;
    private Double impl$healthScale = null;

    @Inject(method={"doTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;getArmorValue()I", ordinal=1)})
    private void updateHealthPriorToArmor(CallbackInfo ci) {
        this.bridge$refreshScaledHealth();
    }

    @Redirect(method={"doTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;getHealth()F"))
    public float impl$onGetHealth(ServerPlayer serverPlayerEntity) {
        return this.bridge$getInternalScaledHealth();
    }

    @Override
    public boolean bridge$setHealthScale(double scale) {
        if (scale < 1.0 || scale > 3.4028234663852886E38) {
            return false;
        }
        this.impl$healthScale = scale;
        this.lastSentHealth = -1.0f;
        ((SpongeDataHolderBridge)((Object)this)).bridge$offer(Keys.HEALTH_SCALE, scale);
        this.bridge$refreshScaledHealth();
        return true;
    }

    @Override
    public void bridge$resetHealthScale() {
        this.impl$healthScale = null;
        this.lastSentHealth = -1.0f;
        ((SpongeDataHolderBridge)((Object)this)).bridge$remove(Keys.HEALTH_SCALE);
        this.bridge$refreshScaledHealth();
    }

    @Override
    public void bridge$refreshScaledHealth() {
        Set dirtyInstances = this.shadow$getAttributes().getDirtyAttributes();
        this.bridge$injectScaledHealth(dirtyInstances);
        FoodData foodData = this.shadow$getFoodData();
        this.connection.send((Packet)new ClientboundSetHealthPacket(this.bridge$getInternalScaledHealth(), foodData.getFoodLevel(), foodData.getSaturationLevel()));
        this.connection.send((Packet)new ClientboundUpdateAttributesPacket(this.shadow$getId(), (Collection)dirtyInstances));
        dirtyInstances.clear();
        this.impl$cachedMaxHealthAttribute = null;
    }

    @Override
    public void bridge$injectScaledHealth(Collection<AttributeInstance> set) {
        @Nullable AttributeInstance attribute = null;
        boolean foundMax = false;
        Iterator<AttributeInstance> iter = set.iterator();
        while (iter.hasNext()) {
            AttributeInstance dirtyInstance = iter.next();
            if (!"attribute.name.generic.maxHealth".equals(dirtyInstance.getAttribute().getDescriptionId())) continue;
            foundMax = true;
            attribute = dirtyInstance;
            iter.remove();
            break;
        }
        if (!foundMax) {
            attribute = this.shadow$getAttribute(Attributes.MAX_HEALTH);
        }
        if (this.bridge$isHealthScaled()) {
            Set modifiers = attribute.getModifiers();
            this.impl$cachedMaxHealthAttribute = new AttributeInstance(Attributes.MAX_HEALTH, i -> {});
            this.impl$cachedMaxHealthAttribute.setBaseValue(this.impl$healthScale.doubleValue());
            if (!modifiers.isEmpty()) {
                modifiers.forEach(arg_0 -> ((AttributeInstance)this.impl$cachedMaxHealthAttribute).addTransientModifier(arg_0));
            }
        } else {
            this.impl$cachedMaxHealthAttribute = attribute;
        }
        set.add(this.impl$cachedMaxHealthAttribute);
    }

    @Override
    public Double bridge$getHealthScale() {
        return this.impl$healthScale;
    }

    @Override
    public float bridge$getInternalScaledHealth() {
        float maximumHealth;
        float healthScale = maximumHealth = this.shadow$getMaxHealth();
        if (this.bridge$isHealthScaled()) {
            AttributeInstance attribute;
            if (this.impl$cachedMaxHealthAttribute == null) {
                Set modifiers = this.shadow$getAttribute(Attributes.MAX_HEALTH).getModifiers();
                attribute = new AttributeInstance(Attributes.MAX_HEALTH, i -> {});
                attribute.setBaseValue(this.impl$healthScale.doubleValue());
                if (!modifiers.isEmpty()) {
                    modifiers.forEach(arg_0 -> ((AttributeInstance)attribute).addTransientModifier(arg_0));
                }
            } else {
                attribute = this.impl$cachedMaxHealthAttribute;
            }
            healthScale = (float)attribute.getValue();
        }
        return this.shadow$getHealth() / maximumHealth * healthScale;
    }

    @Override
    public boolean bridge$isHealthScaled() {
        return this.impl$healthScale != null;
    }
}

