/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.rcon.thread;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.ExecutionException;
import net.minecraft.server.rcon.PktUtils;
import net.minecraft.server.rcon.RconConsoleSource;
import net.minecraft.server.rcon.thread.GenericThread;
import net.minecraft.server.rcon.thread.RconClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.network.rcon.RconConnectionEvent;
import org.spongepowered.api.network.RconConnection;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.server.rcon.RconConsoleSourceBridge;
import org.spongepowered.common.bridge.server.rcon.thread.RconClientBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;

@Mixin(value={RconClient.class})
public abstract class RconClientMixin
extends GenericThread
implements RconClientBridge {
    private static final Logger LOGGER = LogManager.getLogger();
    @Shadow
    private boolean authed;
    @Shadow
    @Final
    private Socket client;
    @Shadow
    @Final
    @Mutable
    private String rconPassword;
    @Shadow
    @Final
    @Mutable
    private byte[] buf;
    private RconConsoleSource impl$source;

    @Shadow
    private void shadow$sendCmdResponse(int p_72655_1_, String p_72655_2_) throws IOException {
    }

    @Shadow
    private void shadow$send(int p_72654_1_, int p_72654_2_, String message) throws IOException {
    }

    @Shadow
    private void closeSocket() {
    }

    @Shadow
    private void shadow$sendAuthFailure() throws IOException {
    }

    protected RconClientMixin(String p_i45300_2_) {
        super(p_i45300_2_);
    }

    @Inject(method={"closeSocket"}, at={@At(value="HEAD")})
    private void impl$rconLogoutCallback(CallbackInfo ci) {
        if (this.authed) {
            SpongeCommon.serverScheduler().execute(() -> {
                CauseStackManager causeStackManager = PhaseTracker.getCauseStackManager();
                causeStackManager.pushCause(this);
                causeStackManager.pushCause(this.impl$source);
                RconConnectionEvent.Disconnect event = SpongeEventFactory.createRconConnectionEventDisconnect(causeStackManager.currentCause(), (RconConnection)this.impl$source);
                SpongeCommon.post(event);
                causeStackManager.popCauses(2);
                return event;
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Overwrite
    public void run() {
        RconConnectionEvent.Connect connectEvent;
        this.impl$source = new RconConsoleSource(SpongeCommon.server());
        ((RconConsoleSourceBridge)this.impl$source).bridge$setClient((RconClient)this);
        try {
            connectEvent = SpongeCommon.serverScheduler().execute(() -> {
                CauseStackManager causeStackManager = PhaseTracker.getCauseStackManager();
                causeStackManager.pushCause(this);
                causeStackManager.pushCause(this.impl$source);
                RconConnectionEvent.Connect event = SpongeEventFactory.createRconConnectionEventConnect(causeStackManager.currentCause(), (RconConnection)this.impl$source);
                SpongeCommon.post(event);
                causeStackManager.popCauses(2);
                return event;
            }).get();
        }
        catch (InterruptedException | ExecutionException ignored) {
            this.closeSocket();
            return;
        }
        if (connectEvent.isCancelled()) {
            this.closeSocket();
            return;
        }
        try {
            BufferedInputStream bufferedinputstream;
            int i;
            block11: while (this.running && (i = (bufferedinputstream = new BufferedInputStream(this.client.getInputStream())).read(this.buf, 0, this.buf.length)) != -1) {
                if (10 > i) continue;
                int j = 0;
                int k = PktUtils.intFromByteArray((byte[])this.buf, (int)0, (int)i);
                if (k == i - 4) {
                    int l = PktUtils.intFromByteArray((byte[])this.buf, (int)(j += 4), (int)i);
                    int i1 = PktUtils.intFromByteArray((byte[])this.buf, (int)(j += 4));
                    j += 4;
                    switch (i1) {
                        case 2: {
                            if (this.authed) {
                                String command = PktUtils.stringFromByteArray((byte[])this.buf, (int)j, (int)i);
                                try {
                                    SpongeCommon.serverScheduler().execute(() -> {
                                        CauseStackManager causeStackManager = PhaseTracker.getCauseStackManager();
                                        causeStackManager.pushCause(this);
                                        SpongeCommon.server().getCommands().performCommand(this.impl$source.createCommandSourceStack(), command);
                                        causeStackManager.popCause();
                                    }).get();
                                    String logContents = this.impl$source.getCommandResponse();
                                    this.impl$source.prepareForCommand();
                                    this.shadow$sendCmdResponse(l, logContents);
                                    continue block11;
                                }
                                catch (Exception exception) {
                                    this.shadow$sendCmdResponse(l, "Error executing: " + command + " (" + exception.getMessage() + ")");
                                    continue block11;
                                }
                            }
                            this.shadow$sendAuthFailure();
                            continue block11;
                        }
                        case 3: {
                            RconConnectionEvent.Auth event;
                            String password = PktUtils.stringFromByteArray((byte[])this.buf, (int)j, (int)i);
                            if (!password.isEmpty() && password.equals(this.rconPassword) && !(event = SpongeCommon.serverScheduler().execute(() -> {
                                CauseStackManager causeStackManager = PhaseTracker.getCauseStackManager();
                                causeStackManager.pushCause(this);
                                causeStackManager.pushCause(this.impl$source);
                                RconConnectionEvent.Auth event1 = SpongeEventFactory.createRconConnectionEventAuth(causeStackManager.currentCause(), (RconConnection)this.impl$source);
                                SpongeCommon.post(event1);
                                causeStackManager.popCauses(2);
                                return event1;
                            }).get()).isCancelled()) {
                                this.authed = true;
                                this.shadow$send(l, 2, "");
                                continue block11;
                            }
                            this.authed = false;
                            this.shadow$sendAuthFailure();
                            continue block11;
                        }
                    }
                    this.shadow$sendCmdResponse(l, String.format("Unknown request %s", Integer.toHexString(i1)));
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
        }
        catch (Exception e) {
            LOGGER.error("Exception whilst parsing RCON input", (Throwable)e);
        }
        this.closeSocket();
    }

    @Override
    public boolean bridge$getLoggedIn() {
        return this.authed;
    }

    @Override
    public void bridge$setLoggedIn(boolean loggedIn) {
        this.authed = loggedIn;
    }
}

