/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Dolphin;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Keys;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.bridge.data.SpongeDataHolderBridge;
import org.spongepowered.common.bridge.world.entity.EntityMaxAirBridge;

@Mixin(value={Entity.class, Dolphin.class})
public abstract class EntityMaxAirMixin
implements EntityMaxAirBridge {
    private @Nullable Integer impl$maxAir;

    @Override
    public int bridge$getDefaultMaxAir() {
        if (this.impl$maxAir == null) {
            return this.bridge$getMaxAir();
        }
        int customMaxAir = this.impl$maxAir;
        this.impl$maxAir = null;
        int defaultMaxAir = this.bridge$getMaxAir();
        this.impl$maxAir = customMaxAir;
        return defaultMaxAir;
    }

    @Override
    public int bridge$getMaxAir() {
        return ((Entity)this).getMaxAirSupply();
    }

    @Override
    public void bridge$setMaxAir(int maxAir) {
        Entity entity = (Entity)this;
        if (entity.getAirSupply() > maxAir) {
            entity.setAirSupply(maxAir);
        }
        if (this.bridge$getDefaultMaxAir() == maxAir) {
            this.impl$maxAir = null;
            ((SpongeDataHolderBridge)((Object)this)).bridge$remove(Keys.MAX_AIR);
            return;
        }
        this.impl$maxAir = maxAir;
        ((SpongeDataHolderBridge)((Object)this)).bridge$offer(Keys.MAX_AIR, maxAir);
    }

    @Inject(method={"getMaxAirSupply"}, at={@At(value="RETURN")}, cancellable=true)
    private void impl$supplyMaxAir(CallbackInfoReturnable<Integer> ci) {
        if (this.impl$maxAir != null) {
            ci.setReturnValue((Object)this.impl$maxAir);
        }
    }
}

