/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity;

import com.google.common.collect.ImmutableList;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoPacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LavaCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.effect.VanishState;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.entity.DismountType;
import org.spongepowered.api.event.cause.entity.DismountTypes;
import org.spongepowered.api.event.cause.entity.MovementTypes;
import org.spongepowered.api.event.data.ChangeDataHolderEvent;
import org.spongepowered.api.event.entity.ChangeEntityWorldEvent;
import org.spongepowered.api.event.entity.IgniteEntityEvent;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.api.world.portal.PortalTypes;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.server.level.ChunkMapAccessor;
import org.spongepowered.common.accessor.server.level.ChunkMap_TrackedEntityAccessor;
import org.spongepowered.common.accessor.world.entity.EntityAccessor;
import org.spongepowered.common.bridge.commands.CommandSourceProviderBridge;
import org.spongepowered.common.bridge.data.DataCompoundHolder;
import org.spongepowered.common.bridge.data.SpongeDataHolderBridge;
import org.spongepowered.common.bridge.data.VanishableBridge;
import org.spongepowered.common.bridge.world.damagesource.DamageSourceBridge;
import org.spongepowered.common.bridge.world.entity.EntityBridge;
import org.spongepowered.common.bridge.world.entity.PlatformEntityBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.bridge.world.level.PlatformServerLevelBridge;
import org.spongepowered.common.data.DataUtil;
import org.spongepowered.common.data.provider.nbt.NBTDataType;
import org.spongepowered.common.data.provider.nbt.NBTDataTypes;
import org.spongepowered.common.data.value.ImmutableSpongeValue;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.hooks.PlatformHooks;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.DamageEventUtil;
import org.spongepowered.common.util.MinecraftBlockDamageSource;
import org.spongepowered.common.util.ReflectionUtil;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.portal.PortalLogic;
import org.spongepowered.common.world.portal.SpongePortalInfo;
import org.spongepowered.common.world.portal.VanillaPortal;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={net.minecraft.world.entity.Entity.class})
public abstract class EntityMixin
implements EntityBridge,
PlatformEntityBridge,
VanishableBridge,
CommandSourceProviderBridge,
DataCompoundHolder {
    @Shadow
    public Level level;
    @Shadow
    private float yRot;
    @Shadow
    private float xRot;
    @Shadow
    public int invulnerableTime;
    @Shadow
    public float walkDistO;
    @Shadow
    public float walkDist;
    @Shadow
    @Final
    protected Random random;
    @Shadow
    @Final
    protected SynchedEntityData entityData;
    @Shadow
    public float yRotO;
    @Shadow
    protected int portalTime;
    @Shadow
    @Nullable
    private net.minecraft.world.entity.Entity vehicle;
    @Shadow
    private ImmutableList<net.minecraft.world.entity.Entity> passengers;
    @Shadow
    protected boolean onGround;
    @Shadow
    public float fallDistance;
    @Shadow
    protected BlockPos portalEntrancePos;
    @Shadow
    private Vec3 position;
    @Shadow
    private BlockPos blockPosition;
    @Shadow
    public double xo;
    @Shadow
    public double yo;
    @Shadow
    public double zo;
    @Shadow
    private int remainingFireTicks;
    @Shadow
    protected String stringUUID;
    private boolean impl$isConstructing = true;
    private VanishState impl$vanishState = VanishState.unvanished();
    private boolean impl$pendingVisibilityUpdate = false;
    private int impl$visibilityTicks = 0;
    private boolean impl$transient = false;
    private boolean impl$shouldFireRepositionEvent = true;
    private WeakReference<ServerWorld> impl$originalDestinationWorld = null;
    private boolean impl$customPortal = false;
    protected boolean impl$hasCustomFireImmuneTicks = false;
    protected boolean impl$dontCreateExitPortal = false;
    protected short impl$fireImmuneTicks = 0;
    private BlockPos impl$lastCollidedBlockPos;
    private Boolean impl$playerTouchDeclared;
    private CompoundTag impl$customDataCompound;

    @Shadow
    protected abstract void shadow$unsetRemoved();

    @Shadow
    public abstract void shadow$setRemoved(Entity.RemovalReason var1);

    @Shadow
    public abstract void shadow$setPos(double var1, double var3, double var5);

    @Shadow
    public abstract double shadow$getX();

    @Shadow
    public abstract double shadow$getY();

    @Shadow
    public abstract double shadow$getZ();

    @Shadow
    public abstract void shadow$remove(Entity.RemovalReason var1);

    @Shadow
    public abstract void shadow$discard();

    @Shadow
    public abstract boolean shadow$isRemoved();

    @Shadow
    public abstract void shadow$setCustomName(@Nullable Component var1);

    @Shadow
    public abstract boolean shadow$hurt(DamageSource var1, float var2);

    @Shadow
    public abstract int shadow$getId();

    @Shadow
    public abstract boolean shadow$isVehicle();

    @Shadow
    public abstract void shadow$playSound(SoundEvent var1, float var2, float var3);

    @Shadow
    protected abstract void shadow$removePassenger(net.minecraft.world.entity.Entity var1);

    @Shadow
    public abstract boolean shadow$isInvisible();

    @Shadow
    public abstract void shadow$setInvisible(boolean var1);

    @Shadow
    protected abstract int shadow$getFireImmuneTicks();

    @Shadow
    public abstract EntityType<?> shadow$getType();

    @Shadow
    public abstract boolean shadow$isInWater();

    @Shadow
    public abstract boolean shadow$isPassenger();

    @Shadow
    public abstract void shadow$teleportToWithTicket(double var1, double var3, double var5);

    @Shadow
    public abstract void shadow$teleportTo(double var1, double var3, double var5);

    @Shadow
    public abstract void shadow$doEnchantDamageEffects(LivingEntity var1, net.minecraft.world.entity.Entity var2);

    @Shadow
    public abstract CommandSourceStack shadow$createCommandSourceStack();

    @Shadow
    public abstract Level shadow$getCommandSenderWorld();

    @Shadow
    public abstract Vec3 shadow$position();

    @Shadow
    public abstract MinecraftServer shadow$getServer();

    @Shadow
    @Nullable
    public abstract ItemEntity shadow$spawnAtLocation(ItemStack var1, float var2);

    @Shadow
    protected abstract void shadow$setRot(float var1, float var2);

    @Shadow
    @Nullable
    public abstract net.minecraft.world.entity.Entity shadow$getVehicle();

    @Shadow
    public abstract boolean shadow$isInvulnerableTo(DamageSource var1);

    @Shadow
    public abstract AABB shadow$getBoundingBox();

    @Shadow
    public abstract boolean shadow$isSprinting();

    @Shadow
    public abstract boolean shadow$isAlliedTo(net.minecraft.world.entity.Entity var1);

    @Shadow
    public abstract double shadow$distanceToSqr(net.minecraft.world.entity.Entity var1);

    @Shadow
    public abstract SoundSource shadow$getSoundSource();

    @Shadow
    @Nullable
    public abstract Team shadow$getTeam();

    @Shadow
    public abstract void shadow$clearFire();

    @Shadow
    protected abstract void shadow$setSharedFlag(int var1, boolean var2);

    @Shadow
    public abstract SynchedEntityData shadow$getEntityData();

    @Shadow
    public abstract void shadow$moveTo(double var1, double var3, double var5);

    @Shadow
    public abstract void shadow$absMoveTo(double var1, double var3, double var5, float var7, float var8);

    @Shadow
    public abstract Vec3 shadow$getDeltaMovement();

    @Shadow
    public abstract void shadow$setDeltaMovement(Vec3 var1);

    @Shadow
    public abstract void shadow$unRide();

    @Shadow
    protected abstract Optional<BlockUtil.FoundRectangle> shadow$getExitPortal(ServerLevel var1, BlockPos var2, boolean var3, WorldBorder var4);

    @Shadow
    protected abstract Vec3 shadow$getRelativePortalPosition(Direction.Axis var1, BlockUtil.FoundRectangle var2);

    @Shadow
    protected abstract void shadow$removeAfterChangingDimensions();

    @Shadow
    public abstract void shadow$absMoveTo(double var1, double var3, double var5);

    @Shadow
    protected abstract int shadow$getPermissionLevel();

    @Shadow
    public abstract float shadow$getYRot();

    @Shadow
    public abstract float shadow$getXRot();

    @Shadow
    public abstract void shadow$setYRot(float var1);

    @Shadow
    public abstract void shadow$setXRot(float var1);

    @Shadow
    protected abstract Vec3 shadow$collide(Vec3 var1);

    @Shadow
    protected abstract boolean shadow$fireImmune();

    @Shadow
    public abstract boolean shadow$isPickable();

    @Shadow
    protected abstract void shadow$markHurt();

    @Shadow
    @Nullable
    protected abstract PortalInfo shadow$findDimensionEntryPoint(ServerLevel var1);

    @Override
    public boolean bridge$isConstructing() {
        return this.impl$isConstructing;
    }

    @Override
    public void bridge$fireConstructors() {
        this.impl$isConstructing = false;
    }

    @Override
    public boolean bridge$isPlayerTouchDeclared() {
        if (this.impl$playerTouchDeclared == null) {
            this.impl$playerTouchDeclared = ReflectionUtil.isPlayerTouchDeclared(this.getClass());
        }
        return this.impl$playerTouchDeclared;
    }

    @Override
    public boolean bridge$setPosition(Vector3d position) {
        if (this.shadow$isRemoved()) {
            return false;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.MOVEMENT_TYPE, MovementTypes.PLUGIN);
            Vector3d destinationPosition = this.impl$fireMoveEvent(PhaseTracker.SERVER, position);
            if (destinationPosition == null) {
                boolean bl = false;
                return bl;
            }
            ServerLevel level = (ServerLevel)this.level;
            boolean bl = this.impl$setLocation(false, level, level, destinationPosition);
            return bl;
        }
    }

    @Override
    public boolean bridge$setLocation(ServerLocation location) {
        if (this.shadow$isRemoved() || ((LevelBridge)location.world()).bridge$isFake()) {
            return false;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            Vector3d destinationPosition;
            ServerLevel destinationWorld;
            boolean isChangeOfWorld;
            frame.addContext(EventContextKeys.MOVEMENT_TYPE, MovementTypes.PLUGIN);
            ServerLevel originalWorld = (ServerLevel)this.shadow$getCommandSenderWorld();
            ServerLevel originalDestinationWorld = (ServerLevel)location.world();
            boolean bl = isChangeOfWorld = this.shadow$getCommandSenderWorld() != originalDestinationWorld;
            if (isChangeOfWorld) {
                ChangeEntityWorldEvent.Pre event = PlatformHooks.INSTANCE.getEventHooks().callChangeEntityWorldEventPre((net.minecraft.world.entity.Entity)this, originalDestinationWorld);
                if (event.isCancelled() || ((LevelBridge)((Object)event.destinationWorld())).bridge$isFake()) {
                    boolean bl2 = false;
                    return bl2;
                }
                destinationWorld = (ServerLevel)event.destinationWorld();
                ChangeEntityWorldEvent.Reposition repositionEvent = this.bridge$fireRepositionEvent(event.originalDestinationWorld(), event.destinationWorld(), location.position());
                if (repositionEvent.isCancelled()) {
                    boolean bl3 = false;
                    return bl3;
                }
                destinationPosition = repositionEvent.destinationPosition();
            } else {
                destinationWorld = (ServerLevel)this.level;
                destinationPosition = this.impl$fireMoveEvent(PhaseTracker.SERVER, location.position());
                if (destinationPosition == null) {
                    boolean event = false;
                    return event;
                }
            }
            boolean completed = this.impl$setLocation(isChangeOfWorld, originalDestinationWorld, destinationWorld, destinationPosition);
            if (isChangeOfWorld) {
                Sponge.eventManager().post(SpongeEventFactory.createChangeEntityWorldEventPost(PhaseTracker.getCauseStackManager().currentCause(), (Entity)((Object)this), (ServerWorld)originalWorld, (ServerWorld)originalDestinationWorld, (ServerWorld)destinationWorld));
            }
            boolean bl4 = completed;
            return bl4;
        }
    }

    protected boolean impl$setLocation(boolean isChangeOfWorld, ServerLevel originalDestinationWorld, ServerLevel destinationWorld, Vector3d destinationPosition) {
        ((net.minecraft.world.entity.Entity)this).unRide();
        if (isChangeOfWorld) {
            ServerLevel originalWorld = (ServerLevel)this.shadow$getCommandSenderWorld();
            ((PlatformServerLevelBridge)this.shadow$getCommandSenderWorld()).bridge$removeEntity((net.minecraft.world.entity.Entity)this, Entity.RemovalReason.CHANGED_DIMENSION, true);
            this.bridge$revive();
            destinationWorld.addDuringTeleport((net.minecraft.world.entity.Entity)this);
            originalWorld.resetEmptyTime();
            destinationWorld.resetEmptyTime();
        }
        return this.impl$teleportToWithTicket(destinationPosition.x(), destinationPosition.y(), destinationPosition.z(), false);
    }

    @Override
    public boolean bridge$dismountRidingEntity(DismountType type) {
        net.minecraft.world.entity.Entity tempEntity;
        if (!this.level.isClientSide && ShouldFire.RIDE_ENTITY_EVENT_DISMOUNT) {
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                frame.pushCause(this);
                frame.addContext(EventContextKeys.DISMOUNT_TYPE, type);
                if (SpongeCommon.post(SpongeEventFactory.createRideEntityEventDismount(frame.currentCause(), (Entity)this.shadow$getVehicle()))) {
                    boolean bl = false;
                    return bl;
                }
            }
        }
        if ((tempEntity = this.shadow$getVehicle()) != null) {
            this.vehicle = null;
            ((EntityAccessor)tempEntity).invoker$removePassenger((net.minecraft.world.entity.Entity)this);
        }
        return true;
    }

    @Override
    public boolean bridge$removePassengers(DismountType type) {
        boolean dismount = false;
        for (int i = this.passengers.size() - 1; i >= 0; --i) {
            dismount = ((EntityBridge)this.passengers.get(i)).bridge$dismountRidingEntity(type) || dismount;
        }
        return dismount;
    }

    @Override
    public boolean bridge$isInvisible() {
        return this.shadow$isInvisible();
    }

    @Override
    public void bridge$setInvisible(boolean invisible) {
        this.shadow$setInvisible(invisible);
        if (invisible) {
            ((SpongeDataHolderBridge)((Object)this)).bridge$offer(Keys.IS_INVISIBLE, true);
        } else {
            ((SpongeDataHolderBridge)((Object)this)).bridge$remove(Keys.IS_INVISIBLE);
        }
    }

    @Override
    public VanishState bridge$vanishState() {
        return this.impl$vanishState;
    }

    @Override
    public void bridge$vanishState(VanishState state) {
        this.impl$vanishState = state;
    }

    @Override
    public void bridge$setTransient(boolean value) {
        this.impl$transient = value;
    }

    @Override
    public void bridge$setFireImmuneTicks(int ticks) {
        this.impl$hasCustomFireImmuneTicks = true;
        this.impl$fireImmuneTicks = (short)ticks;
    }

    @Override
    public CommandSourceStack bridge$getCommandSource(Cause cause) {
        return this.shadow$createCommandSourceStack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"findDimensionEntryPoint"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getExitPortal(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;ZLnet/minecraft/world/level/border/WorldBorder;)Ljava/util/Optional;"))
    private Optional<BlockUtil.FoundRectangle> impl$redirectGetExitPortal(net.minecraft.world.entity.Entity thisEntity, ServerLevel targetWorld, BlockPos targetPosition, boolean targetIsNether, WorldBorder $$3) {
        try {
            Optional<BlockUtil.FoundRectangle> optional = this.shadow$getExitPortal(targetWorld, targetPosition, targetIsNether, $$3);
            return optional;
        }
        finally {
            this.impl$dontCreateExitPortal = false;
        }
    }

    @Redirect(method={"findDimensionEntryPoint"}, at=@At(value="FIELD", opcode=178, target="Lnet/minecraft/world/level/Level;END:Lnet/minecraft/resources/ResourceKey;"))
    private ResourceKey<Level> impl$getNullInsteadOfEndIfCreatingCustomPortal() {
        if (this.impl$customPortal) {
            return null;
        }
        return Level.END;
    }

    @Redirect(method={"findDimensionEntryPoint"}, at=@At(value="FIELD", opcode=178, target="Lnet/minecraft/world/level/Level;NETHER:Lnet/minecraft/resources/ResourceKey;"))
    private ResourceKey<Level> impl$forceCheckToBeTrueIfCreatingCustomPortal(ServerLevel targetDimension) {
        if (this.impl$customPortal) {
            return targetDimension.dimension();
        }
        return Level.NETHER;
    }

    @Redirect(method={"findDimensionEntryPoint"}, at=@At(value="NEW", target="net/minecraft/world/level/portal/PortalInfo"))
    private PortalInfo impl$addPortalToPortalInfoForEnd(Vec3 var1, Vec3 var2, float var3, float var4, ServerLevel serverLevel) {
        VanillaPortal portal = new VanillaPortal(PortalTypes.END.get(), (ServerLocation)((ServerWorld)serverLevel).location(VecHelper.toVector3d(var1)), null);
        return new SpongePortalInfo(var1, var2, var3, var4, portal);
    }

    protected net.minecraft.world.entity.Entity impl$portalRepositioning(boolean createEndPlatform, ServerLevel serverworld, ServerLevel targetWorld, PortalInfo portalinfo) {
        serverworld.getProfiler().popPush("reloading");
        net.minecraft.world.entity.Entity entity = this.shadow$getType().create((Level)targetWorld);
        if (entity != null) {
            entity.restoreFrom((net.minecraft.world.entity.Entity)this);
            entity.moveTo(portalinfo.pos.x, portalinfo.pos.y, portalinfo.pos.z, portalinfo.yRot, entity.getXRot());
            entity.setDeltaMovement(portalinfo.speed);
            targetWorld.addDuringTeleport(entity);
            if (createEndPlatform && targetWorld.dimension() == Level.END) {
                ServerLevel.makeObsidianPlatform((ServerLevel)targetWorld);
            }
        }
        return entity;
    }

    protected void impl$postPortalForceChangeTasks(net.minecraft.world.entity.Entity entity, ServerLevel targetWorld, boolean isVanilla) {
        this.shadow$removeAfterChangingDimensions();
        this.level.getProfiler().pop();
        ((ServerLevel)this.level).resetEmptyTime();
        targetWorld.resetEmptyTime();
        this.level.getProfiler().pop();
    }

    protected @org.checkerframework.checker.nullness.qual.Nullable net.minecraft.world.entity.Entity impl$postProcessChangeDimension(net.minecraft.world.entity.Entity entity) {
        return entity;
    }

    /*
     * Exception decompiling
     */
    @Override
    public @org.checkerframework.checker.nullness.qual.Nullable net.minecraft.world.entity.Entity bridge$changeDimension(ServerLevel originalDestinationWorld, PortalLogic originalPortalLogic) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void impl$onPreWorldChangeCanceled() {
    }

    protected void impl$onChangingDimension(ServerLevel target) {
    }

    protected void impl$prepareForPortalTeleport(ServerLevel currentWorld, ServerLevel targetWorld) {
    }

    protected void impl$validateEntityAfterTeleport(net.minecraft.world.entity.Entity e, PortalLogic teleporter) {
    }

    protected net.minecraft.world.entity.Entity impl$performGameWinLogic() {
        return (net.minecraft.world.entity.Entity)this;
    }

    private Vector3d impl$getEntityPositionInPotentialExitPortal(BlockUtil.FoundRectangle result) {
        Vec3 vector3d;
        BlockState blockstate = this.level.getBlockState(this.portalEntrancePos);
        if (blockstate.hasProperty((Property)BlockStateProperties.HORIZONTAL_AXIS)) {
            Direction.Axis direction$axis = (Direction.Axis)blockstate.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS);
            BlockUtil.FoundRectangle teleportationrepositioner$result = BlockUtil.getLargestRectangleAround((BlockPos)this.portalEntrancePos, (Direction.Axis)direction$axis, (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, p_242276_2_ -> this.level.getBlockState(p_242276_2_) == blockstate);
            vector3d = this.shadow$getRelativePortalPosition(direction$axis, teleportationrepositioner$result);
        } else {
            vector3d = new Vec3(0.5, 0.0, 0.0);
        }
        return VecHelper.toVector3d(vector3d);
    }

    @Inject(method={"getExitPortal"}, cancellable=true, at={@At(value="RETURN")})
    private void impl$fireRepositionEventWhenFindingAPortal(ServerLevel targetWorld, BlockPos targetPosition, boolean targetIsNether, WorldBorder $$3, CallbackInfoReturnable<Optional<BlockUtil.FoundRectangle>> cir) {
        Optional result;
        Vector3d destinationPosition;
        ServerWorld originalDestinationWorld;
        ChangeEntityWorldEvent.Reposition reposition;
        if (this.impl$shouldFireRepositionEvent && !(reposition = this.bridge$fireRepositionEvent(originalDestinationWorld = this.impl$originalDestinationWorld != null && this.impl$originalDestinationWorld.get() != null ? (ServerWorld)this.impl$originalDestinationWorld.get() : (ServerWorld)targetWorld, (ServerWorld)targetWorld, destinationPosition = (result = (Optional)cir.getReturnValue()).map(this::impl$getEntityPositionInPotentialExitPortal).orElseGet(() -> VecHelper.toVector3d(targetPosition)))).isCancelled() && reposition.destinationPosition() != destinationPosition) {
            cir.setReturnValue(this.shadow$getExitPortal(targetWorld, VecHelper.toBlockPos(reposition.destinationPosition()), targetIsNether, $$3));
            this.impl$dontCreateExitPortal = true;
        }
    }

    @Override
    public final ChangeEntityWorldEvent.Reposition bridge$fireRepositionEvent(ServerWorld originalDestinationWorld, ServerWorld targetWorld, Vector3d destinationPosition) {
        this.impl$shouldFireRepositionEvent = false;
        ChangeEntityWorldEvent.Reposition reposition = SpongeEventFactory.createChangeEntityWorldEventReposition(PhaseTracker.getCauseStackManager().currentCause(), (Entity)((Object)this), (ServerWorld)this.level, VecHelper.toVector3d(this.position), destinationPosition, originalDestinationWorld, destinationPosition, targetWorld);
        SpongeCommon.post(reposition);
        return reposition;
    }

    @Override
    public CompoundTag data$getCompound() {
        return this.impl$customDataCompound;
    }

    @Override
    public void data$setCompound(CompoundTag nbt) {
        this.impl$customDataCompound = nbt;
    }

    @Override
    public NBTDataType data$getNBTDataType() {
        return NBTDataTypes.ENTITY;
    }

    @Overwrite
    public final void teleportToWithTicket(double x, double y, double z) {
        this.impl$teleportToWithTicket(x, y, z, true);
    }

    public final boolean impl$teleportToWithTicket(double x, double y, double z, boolean fireMoveEvent) {
        if (this.level instanceof ServerLevel) {
            Vector3d destinationPosition = ShouldFire.MOVE_ENTITY_EVENT && fireMoveEvent ? this.impl$fireMoveEvent(PhaseTracker.SERVER, new Vector3d(x, y, z)) : new Vector3d(x, y, z);
            ChunkPos chunkpos = new ChunkPos(new BlockPos(destinationPosition.x(), destinationPosition.y(), destinationPosition.z()));
            ((ServerLevel)this.level).getChunkSource().addRegionTicket(TicketType.POST_TELEPORT, chunkpos, 0, (Object)this.shadow$getId());
            this.level.getChunk(chunkpos.x, chunkpos.z);
            this.shadow$teleportTo(destinationPosition.x(), destinationPosition.y(), destinationPosition.z());
            return true;
        }
        return false;
    }

    protected final @org.checkerframework.checker.nullness.qual.Nullable Vector3d impl$fireMoveEvent(PhaseTracker phaseTracker, Vector3d originalDestinationPosition) {
        boolean hasMovementContext = phaseTracker.currentContext().containsKey(EventContextKeys.MOVEMENT_TYPE);
        if (!hasMovementContext) {
            phaseTracker.addContext(EventContextKeys.MOVEMENT_TYPE, MovementTypes.PLUGIN);
        }
        MoveEntityEvent event = SpongeEventFactory.createMoveEntityEvent(phaseTracker.currentCause(), (Entity)((Object)this), VecHelper.toVector3d(this.shadow$position()), originalDestinationPosition, originalDestinationPosition);
        if (!hasMovementContext) {
            phaseTracker.popCause();
            phaseTracker.removeContext(EventContextKeys.MOVEMENT_TYPE);
        }
        if (SpongeCommon.post(event)) {
            return null;
        }
        return event.destinationPosition();
    }

    @Inject(method={"startRiding(Lnet/minecraft/world/entity/Entity;Z)Z"}, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/Entity;vehicle:Lnet/minecraft/world/entity/Entity;", ordinal=0)}, cancellable=true)
    private void impl$onStartRiding(net.minecraft.world.entity.Entity vehicle, boolean force, CallbackInfoReturnable<Boolean> ci) {
        if (!this.level.isClientSide && ShouldFire.RIDE_ENTITY_EVENT_MOUNT) {
            PhaseTracker.getCauseStackManager().pushCause(this);
            if (SpongeCommon.post(SpongeEventFactory.createRideEntityEventMount(PhaseTracker.getCauseStackManager().currentCause(), (Entity)vehicle))) {
                ci.cancel();
            }
            PhaseTracker.getCauseStackManager().popCause();
        }
    }

    @Overwrite
    public void stopRiding() {
        net.minecraft.world.entity.Entity vehicle = this.shadow$getVehicle();
        if (vehicle != null) {
            if (vehicle.isRemoved()) {
                this.bridge$dismountRidingEntity(DismountTypes.DEATH.get());
            } else {
                this.bridge$dismountRidingEntity(DismountTypes.PLAYER.get());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"lavaHurt"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"))
    private boolean impl$createLavaBlockDamageSource(net.minecraft.world.entity.Entity entity, DamageSource source, float damage) {
        if (this.level.isClientSide) {
            return entity.hurt(source, damage);
        }
        try {
            AABB bb = this.shadow$getBoundingBox().inflate((double)-0.1f, (double)-0.4f, (double)-0.1f);
            ServerLocation location = DamageEventUtil.findFirstMatchingBlock((net.minecraft.world.entity.Entity)this, bb, block -> block.getMaterial() == Material.LAVA || block.getBlock() instanceof LavaCauldronBlock);
            DamageSource lava = MinecraftBlockDamageSource.ofFire("lava", location, false);
            ((DamageSourceBridge)lava).bridge$setLava();
            boolean bl = entity.hurt(DamageSource.LAVA, damage);
            return bl;
        }
        finally {
            ((DamageSourceBridge)source).bridge$setLava();
        }
    }

    @Inject(method={"setPos(DDD)V"}, at={@At(value="HEAD")})
    protected void impl$capturePlayerPosition(double x, double y, double z, CallbackInfo ci) {
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void impl$updateVanishState(CallbackInfo callbackInfo) {
        if (this.impl$pendingVisibilityUpdate && !this.level.isClientSide) {
            ChunkMap_TrackedEntityAccessor trackerAccessor = (ChunkMap_TrackedEntityAccessor)((ChunkMapAccessor)((Object)((ServerWorld)this.level).chunkManager())).accessor$entityMap().get(this.shadow$getId());
            if (trackerAccessor != null && this.impl$visibilityTicks % 4 == 0) {
                if (this.bridge$vanishState().invisible()) {
                    for (ServerPlayer entityPlayerMP : trackerAccessor.accessor$seenBy()) {
                        entityPlayerMP.connection.send((Packet)new ClientboundRemoveEntitiesPacket(new int[]{this.shadow$getId()}));
                        if (!((net.minecraft.world.entity.Entity)this instanceof ServerPlayer)) continue;
                        entityPlayerMP.connection.send((Packet)new ClientboundPlayerInfoPacket(ClientboundPlayerInfoPacket.Action.REMOVE_PLAYER, new ServerPlayer[]{(ServerPlayer)this}));
                    }
                } else {
                    this.impl$visibilityTicks = 1;
                    this.impl$pendingVisibilityUpdate = false;
                    for (ServerPlayer entityPlayerMP : SpongeCommon.server().getPlayerList().getPlayers()) {
                        if ((net.minecraft.world.entity.Entity)this == entityPlayerMP) continue;
                        if ((net.minecraft.world.entity.Entity)this instanceof ServerPlayer) {
                            ClientboundPlayerInfoPacket packet = new ClientboundPlayerInfoPacket(ClientboundPlayerInfoPacket.Action.ADD_PLAYER, new ServerPlayer[]{(ServerPlayer)this});
                            entityPlayerMP.connection.send((Packet)packet);
                        }
                        trackerAccessor.accessor$updatePlayer(entityPlayerMP);
                    }
                }
            }
            if (this.impl$visibilityTicks > 0) {
                --this.impl$visibilityTicks;
            } else {
                this.impl$pendingVisibilityUpdate = false;
            }
        }
    }

    @Redirect(method={"move"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;collide(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;"))
    private Vec3 impl$onMoveCollide(net.minecraft.world.entity.Entity entity, Vec3 originalMove) {
        Vec3 afterCollide = this.shadow$collide(originalMove);
        if (ShouldFire.COLLIDE_BLOCK_EVENT_MOVE && !originalMove.equals((Object)afterCollide)) {
            BlockPos pos = new BlockPos(this.position.add(originalMove));
            if (this.blockPosition.equals((Object)pos)) {
                pos = new BlockPos(this.position.add(originalMove.normalize()));
            }
            BlockState state = this.level.getBlockState(pos);
            Direction dir = Direction.closest(new Vector3d(originalMove.x, originalMove.y, originalMove.z));
            if (SpongeCommonEventFactory.handleCollideBlockEvent(state.getBlock(), this.level, pos, state, (net.minecraft.world.entity.Entity)this, dir, SpongeCommonEventFactory.CollisionType.MOVE)) {
                return originalMove;
            }
        }
        return afterCollide;
    }

    @Redirect(method={"checkFallDamage"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/Block;fallOn(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/Entity;F)V"))
    private void impl$onFallOnCollide(Block block, Level world, BlockState state, BlockPos pos, net.minecraft.world.entity.Entity entity, float fallDistance) {
        if (!ShouldFire.COLLIDE_BLOCK_EVENT_FALL || world.isClientSide) {
            block.fallOn(world, state, pos, entity, fallDistance);
            return;
        }
        if (!SpongeCommonEventFactory.handleCollideBlockEvent(block, world, pos, state, entity, Direction.UP, SpongeCommonEventFactory.CollisionType.FALL)) {
            block.fallOn(world, state, pos, entity, fallDistance);
            this.impl$lastCollidedBlockPos = pos;
        }
    }

    @Redirect(method={"move"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/Block;stepOn(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/entity/Entity;)V"))
    private void impl$onStepOnCollide(Block block, Level world, BlockPos pos, BlockState state, net.minecraft.world.entity.Entity entity) {
        if (!ShouldFire.COLLIDE_BLOCK_EVENT_STEP_ON || world.isClientSide) {
            block.stepOn(world, pos, state, entity);
            return;
        }
        Direction dir = Direction.NONE;
        if (!SpongeCommonEventFactory.handleCollideBlockEvent(block, world, pos, state, entity, dir, SpongeCommonEventFactory.CollisionType.STEP_ON)) {
            block.stepOn(world, pos, state, entity);
            this.impl$lastCollidedBlockPos = pos;
        }
    }

    @Redirect(method={"checkInsideBlocks"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;entityInside(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/Entity;)V"))
    private void impl$onCheckInsideBlocksCollide(BlockState blockState, Level worldIn, BlockPos pos, net.minecraft.world.entity.Entity entityIn) {
        if (!ShouldFire.COLLIDE_BLOCK_EVENT_INSIDE || worldIn.isClientSide) {
            blockState.entityInside(worldIn, pos, entityIn);
            return;
        }
        Direction dir = Direction.NONE;
        if (!SpongeCommonEventFactory.handleCollideBlockEvent(blockState.getBlock(), worldIn, pos, blockState, entityIn, dir, SpongeCommonEventFactory.CollisionType.INSIDE)) {
            blockState.entityInside(worldIn, pos, entityIn);
            this.impl$lastCollidedBlockPos = pos;
        }
    }

    @Redirect(method={"playSound"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;isSilent()Z"))
    private boolean impl$checkIsSilentOrInvis(net.minecraft.world.entity.Entity entity) {
        return entity.isSilent() || !this.bridge$vanishState().createsSounds();
    }

    @Redirect(method={"push(Lnet/minecraft/world/entity/Entity;)V"}, at=@At(value="FIELD", target="Lnet/minecraft/world/entity/Entity;noPhysics:Z", opcode=180))
    private boolean impl$applyEntityCollisionCheckVanish(net.minecraft.world.entity.Entity entity) {
        return entity.noPhysics || ((VanishableBridge)entity).bridge$vanishState().ignoresCollisions();
    }

    @Redirect(method={"doWaterSplashEffect"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V"))
    private void impl$spawnParticle(Level instance, ParticleOptions particleOptions, double xCoord, double yCoord, double zCoord, double xOffset, double yOffset, double zOffset) {
        if (this.bridge$vanishState().createsParticles()) {
            this.level.addParticle(particleOptions, xCoord, yCoord, zCoord, xOffset, yOffset, zOffset);
        }
    }

    @Redirect(method={"spawnSprintParticle"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V"))
    private void impl$runningSpawnParticle(Level instance, ParticleOptions particleOptions, double xCoord, double yCoord, double zCoord, double xOffset, double yOffset, double zOffset) {
        if (this.bridge$vanishState().createsParticles()) {
            instance.addParticle(particleOptions, xCoord, yCoord, zCoord, xOffset, yOffset, zOffset);
        }
    }

    @Inject(method={"spawnAtLocation(Lnet/minecraft/world/item/ItemStack;F)Lnet/minecraft/world/entity/item/ItemEntity;"}, at={@At(value="HEAD")}, cancellable=true)
    public void impl$throwDropItemConstructEvent(ItemStack stack, float offsetY, CallbackInfoReturnable<ItemEntity> cir) {
        if (stack.isEmpty()) {
            cir.setReturnValue(null);
            return;
        }
        if (((LevelBridge)this.level).bridge$isFake()) {
            return;
        }
        double posX = this.shadow$position().x;
        double posY = this.shadow$position().y + (double)offsetY;
        double posZ = this.shadow$position().z;
        ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(stack);
        ArrayList<ItemStackSnapshot> original = new ArrayList<ItemStackSnapshot>();
        original.add(snapshot);
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            ItemStack item = SpongeCommonEventFactory.throwDropItemAndConstructEvent((net.minecraft.world.entity.Entity)this, posX, posY, posZ, snapshot, original, frame);
            if (item == null || item.isEmpty()) {
                cir.setReturnValue(null);
                return;
            }
            ItemEntity entityitem = new ItemEntity(this.level, posX, posY, posZ, item);
            entityitem.setDefaultPickUpDelay();
            this.level.addFreshEntity((net.minecraft.world.entity.Entity)entityitem);
            cir.setReturnValue((Object)entityitem);
        }
    }

    @Override
    public @org.checkerframework.checker.nullness.qual.Nullable BlockPos bridge$getLastCollidedBlockPos() {
        return this.impl$lastCollidedBlockPos;
    }

    @Redirect(method={"setRemainingFireTicks"}, at=@At(value="FIELD", target="Lnet/minecraft/world/entity/Entity;remainingFireTicks:I", opcode=181))
    private void impl$ThrowIgniteEventForFire(net.minecraft.world.entity.Entity entity, int ticks) {
        if (!((LevelBridge)this.level).bridge$isFake() && ShouldFire.IGNITE_ENTITY_EVENT && this.remainingFireTicks < 1 && ticks >= 1 && this.impl$canCallIgniteEntityEvent()) {
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                frame.pushCause(((Entity)((Object)this)).location().world());
                IgniteEntityEvent event = SpongeEventFactory.createIgniteEntityEvent(frame.currentCause(), Ticks.of(ticks), Ticks.of(ticks), (Entity)((Object)this));
                if (SpongeCommon.post(event)) {
                    return;
                }
                DataTransactionResult transaction = DataTransactionResult.builder().replace(new ImmutableSpongeValue<Ticks>(Keys.FIRE_TICKS, Ticks.of(Math.max(this.remainingFireTicks, 0)))).success(new ImmutableSpongeValue<Ticks>(Keys.FIRE_TICKS, event.fireTicks())).result(DataTransactionResult.Type.SUCCESS).build();
                ChangeDataHolderEvent.ValueChange valueChange = SpongeEventFactory.createChangeDataHolderEventValueChange(PhaseTracker.SERVER.currentCause(), transaction, (DataHolder.Mutable)((Object)this));
                Sponge.eventManager().post(valueChange);
                if (valueChange.isCancelled()) {
                    return;
                }
                this.remainingFireTicks = valueChange.endResult().successfulValue(Keys.FIRE_TICKS).map(Value::get).map(t -> (int)t.ticks()).orElse(0);
            }
            return;
        }
        this.remainingFireTicks = ticks;
    }

    @Redirect(method={"gameEvent(Lnet/minecraft/world/level/gameevent/GameEvent;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/core/BlockPos;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;gameEvent(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/level/gameevent/GameEvent;Lnet/minecraft/core/BlockPos;)V"))
    private void impl$ignoreGameEventIfVanished(Level instance, net.minecraft.world.entity.Entity entity, GameEvent gameEvent, BlockPos blockPos) {
        if (entity instanceof VanishableBridge && ((VanishableBridge)entity).bridge$vanishState().triggerVibrations()) {
            instance.gameEvent(entity, gameEvent, blockPos);
        }
    }

    @Redirect(method={"getEncodeId"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/EntityType;canSerialize()Z"))
    private boolean impl$respectTransientFlag(EntityType entityType) {
        if (!entityType.canSerialize()) {
            return false;
        }
        return !this.impl$transient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"thunderHit"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"))
    private boolean impl$ThrowDamageEventWithLightingSource(net.minecraft.world.entity.Entity entity, DamageSource source, float damage, ServerLevel level, LightningBolt lightningBolt) {
        if (!this.level.isClientSide) {
            return entity.hurt(source, damage);
        }
        try {
            EntityDamageSource lightning = new EntityDamageSource("lightningBolt", (net.minecraft.world.entity.Entity)lightningBolt);
            ((DamageSourceBridge)lightning).bridge$setLightningSource();
            boolean bl = entity.hurt(DamageSource.LIGHTNING_BOLT, damage);
            return bl;
        }
        finally {
            ((DamageSourceBridge)source).bridge$setLightningSource();
        }
    }

    @Inject(method={"getFireImmuneTicks"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$getFireImmuneTicks(CallbackInfoReturnable<Integer> ci) {
        if (this.impl$hasCustomFireImmuneTicks) {
            ci.setReturnValue((Object)this.impl$fireImmuneTicks);
        }
    }

    @Inject(method={"saveWithoutId"}, at={@At(value="RETURN")})
    private void impl$WriteSpongeDataToCompound(CompoundTag compound, CallbackInfoReturnable<CompoundTag> ci) {
        if (DataUtil.syncDataToTag(this)) {
            compound.merge(this.data$getCompound());
        }
    }

    @Inject(method={"load"}, at={@At(value="RETURN")})
    private void impl$ReadSpongeDataFromCompound(CompoundTag compound, CallbackInfo ci) {
        this.data$setCompound(compound);
        DataUtil.syncTagToData(this);
        this.data$setCompound(null);
    }

    protected boolean impl$canCallIgniteEntityEvent() {
        return !this.shadow$fireImmune();
    }

    protected void impl$callExpireEntityEvent() {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(this);
            Sponge.eventManager().post(SpongeEventFactory.createExpireEntityEvent(frame.currentCause(), (Entity)((Object)this)));
        }
    }

    @Inject(method={"discard"}, at={@At(value="TAIL")})
    private void impl$throwExpireForDiscards(CallbackInfo ci) {
        SpongeCommon.post(SpongeEventFactory.createExpireEntityEvent(PhaseTracker.getInstance().currentCause(), (Entity)((Object)this)));
    }

    private /* synthetic */ net.minecraft.world.entity.Entity lambda$bridge$changeDimension$1(ServerLevel serverworld, ServerLevel targetWorld, PortalInfo portalinfo, Boolean createEndPlatform) {
        return this.impl$portalRepositioning(createEndPlatform, serverworld, targetWorld, portalinfo);
    }

    private /* synthetic */ PortalInfo lambda$bridge$changeDimension$0(ServerLevel x) {
        return this.shadow$findDimensionEntryPoint(x);
    }
}

