/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.level;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.Motive;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.WritableLevelData;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.projectile.EnderPearl;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.world.entity.MobAccessor;
import org.spongepowered.common.accessor.world.entity.item.FallingBlockEntityAccessor;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.entity.projectile.UnknownProjectileSource;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.DataUtil;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={Level.class})
public abstract class LevelMixin
implements LevelBridge,
LevelAccessor {
    @Mutable
    @Shadow
    @Final
    private DimensionType dimensionType;
    @Shadow
    protected float oRainLevel;
    @Shadow
    protected float rainLevel;
    @Shadow
    protected float oThunderLevel;
    @Shadow
    protected float thunderLevel;
    @Shadow
    @Final
    protected List<TickingBlockEntity> blockEntityTickers;
    @Shadow
    @Final
    protected WritableLevelData levelData;

    @Shadow
    public abstract LevelData shadow$getLevelData();

    @Shadow
    public abstract void shadow$updateSkyBrightness();

    @Shadow
    public abstract ResourceKey<Level> shadow$dimension();

    @Shadow
    public abstract DimensionType shadow$dimensionType();

    @Shadow
    public abstract LevelChunk shadow$getChunkAt(BlockPos var1);

    @Shadow
    public abstract DifficultyInstance shadow$getCurrentDifficultyAt(BlockPos var1);

    @Shadow
    public abstract boolean shadow$isRaining();

    @Shadow
    @javax.annotation.Nullable
    public abstract BlockEntity shadow$getBlockEntity(BlockPos var1);

    @Shadow
    public abstract WorldBorder shadow$getWorldBorder();

    @Shadow
    protected abstract void shadow$postGameEventInRadius(@javax.annotation.Nullable net.minecraft.world.entity.Entity var1, GameEvent var2, BlockPos var3, int var4);

    @Override
    public boolean bridge$isFake() {
        return this.isClientSide();
    }

    @Override
    public void bridge$adjustDimensionLogic(DimensionType dimensionType) {
        this.dimensionType = dimensionType;
    }

    @Override
    public <E extends Entity> E bridge$createEntity(DataContainer dataContainer, @Nullable Vector3d position, @Nullable Predicate<Vector3d> positionCheck) throws IllegalArgumentException, IllegalStateException {
        EntityType<@NonNull ? extends Entity> type = dataContainer.getRegistryValue(Constants.Entity.TYPE, RegistryTypes.ENTITY_TYPE).orElseThrow(() -> new IllegalArgumentException("DataContainer does not contain a valid entity type."));
        Vector3d proposedPosition = position == null ? DataUtil.getPosition3d(dataContainer, Constants.Sponge.SNAPSHOT_WORLD_POSITION) : position;
        if (positionCheck != null && !positionCheck.test(proposedPosition)) {
            throw new IllegalArgumentException(String.format("Position (%.2f, %.2f, %.2f) is not a valid position in this context.", proposedPosition.x(), proposedPosition.y(), proposedPosition.z()));
        }
        Vector3d rotation = dataContainer.contains(Constants.Entity.ROTATION) ? DataUtil.getPosition3d(dataContainer, Constants.Entity.ROTATION) : null;
        Vector3d scale = dataContainer.contains(Constants.Entity.SCALE) ? DataUtil.getPosition3d(dataContainer, Constants.Entity.SCALE) : null;
        Entity createdEntity = this.bridge$createEntity(type, position, false);
        dataContainer.getView(Constants.Sponge.UNSAFE_NBT).map(NBTTranslator.INSTANCE::translate).ifPresent(x -> {
            net.minecraft.world.entity.Entity e = (net.minecraft.world.entity.Entity)createdEntity;
            x.remove("Dimension");
            e.load(x);
            e.moveTo(proposedPosition.x(), proposedPosition.y(), proposedPosition.z());
        });
        if (rotation != null) {
            createdEntity.setRotation(rotation);
        }
        if (scale != null) {
            createdEntity.setScale(scale);
        }
        return (E)createdEntity;
    }

    @Override
    public <E extends Entity> E bridge$createEntity(EntityType<E> type, Vector3d position, boolean naturally) throws IllegalArgumentException, IllegalStateException {
        if (type == net.minecraft.world.entity.EntityType.PLAYER) {
            throw new IllegalArgumentException("A Player cannot be created by the API!");
        }
        net.minecraft.world.entity.Entity entity = null;
        double x = position.x();
        double y = position.y();
        double z = position.z();
        Level thisWorld = (Level)this;
        if (type == net.minecraft.world.entity.EntityType.LIGHTNING_BOLT) {
            entity = net.minecraft.world.entity.EntityType.LIGHTNING_BOLT.create(thisWorld);
            entity.moveTo(x, y, z);
            ((LightningBolt)entity).setVisualOnly(false);
        }
        if (type == net.minecraft.world.entity.EntityType.ENDER_PEARL) {
            ArmorStand tempEntity = new ArmorStand(thisWorld, x, y, z);
            tempEntity.setPos(tempEntity.getX(), tempEntity.getY() - (double)tempEntity.getEyeHeight(), tempEntity.getZ());
            entity = new ThrownEnderpearl(thisWorld, (LivingEntity)tempEntity);
            ((EnderPearl)entity).offer(Keys.SHOOTER, UnknownProjectileSource.UNKNOWN);
        }
        if (type == net.minecraft.world.entity.EntityType.FALLING_BLOCK) {
            entity = FallingBlockEntityAccessor.invoker$new(thisWorld, x, y, z, Blocks.SAND.defaultBlockState());
        }
        if (type == net.minecraft.world.entity.EntityType.ITEM) {
            entity = new ItemEntity(thisWorld, x, y, z, new ItemStack((ItemLike)Blocks.STONE));
        }
        if (entity == null) {
            org.spongepowered.api.ResourceKey key = (org.spongepowered.api.ResourceKey)Registry.ENTITY_TYPE.getKey((Object)((net.minecraft.world.entity.EntityType)type));
            try {
                entity = ((net.minecraft.world.entity.EntityType)type).create(thisWorld);
                entity.moveTo(x, y, z);
            }
            catch (Exception e) {
                throw new RuntimeException("There was an issue attempting to construct " + key, e);
            }
        }
        if (entity instanceof HangingEntity && !((HangingEntity)entity).survives()) {
            throw new IllegalArgumentException("Hanging entity does not survive at the given position: " + position);
        }
        if (naturally && entity instanceof Mob) {
            DifficultyInstance difficulty = this.shadow$getCurrentDifficultyAt(new BlockPos(x, y, z));
            ((MobAccessor)entity).invoker$populateDefaultEquipmentSlots(difficulty);
        }
        if (entity instanceof Painting) {
            ((Painting)entity).motive = Motive.KEBAB;
        }
        return (E)((Entity)entity);
    }
}

