/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.server.level;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.bridge.world.entity.PlatformEntityBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.mixin.tracker.world.entity.player.PlayerMixin_Tracker;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin_Tracker
extends PlayerMixin_Tracker {
    @Redirect(method={"drop(Lnet/minecraft/world/item/ItemStack;ZZ)Lnet/minecraft/world/entity/item/ItemEntity;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;drop(Lnet/minecraft/world/item/ItemStack;ZZ)Lnet/minecraft/world/entity/item/ItemEntity;"))
    private @Nullable ItemEntity tracker$throwItemDrop(Player thisPlayer, ItemStack droppedItem, boolean dropAround, boolean traceItem) {
        if (droppedItem.isEmpty()) {
            return null;
        }
        if (((PlatformEntityBridge)((Object)this)).bridge$isFakePlayer()) {
            return super.shadow$drop(droppedItem, dropAround, traceItem);
        }
        if (((LevelBridge)this.level).bridge$isFake()) {
            return super.shadow$drop(droppedItem, dropAround, traceItem);
        }
        double posX1 = this.shadow$getX();
        double posY1 = this.shadow$getEyeY() - (double)0.3f;
        double posZ1 = this.shadow$getZ();
        ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(droppedItem);
        ArrayList<ItemStackSnapshot> original = new ArrayList<ItemStackSnapshot>();
        original.add(snapshot);
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            ItemStack item = SpongeCommonEventFactory.throwDropItemAndConstructEvent((Entity)((ServerPlayer)this), posX1, posY1, posZ1, snapshot, original, frame);
            if (item == null || item.isEmpty()) {
                ItemEntity itemEntity = null;
                return itemEntity;
            }
            ItemEntity itemEntity = new ItemEntity(this.level, posX1, posY1, posZ1, item);
            itemEntity.setPickUpDelay(40);
            if (traceItem) {
                itemEntity.setThrower(this.shadow$getUUID());
            }
            Random random = this.shadow$getRandom();
            if (dropAround) {
                float f = random.nextFloat() * 0.5f;
                float f1 = random.nextFloat() * ((float)Math.PI * 2);
                itemEntity.setDeltaMovement((double)(-Mth.sin((float)f1) * f), (double)0.2f, (double)(Mth.cos((float)f1) * f));
            } else {
                float f8 = Mth.sin((float)(this.shadow$getXRot() * ((float)Math.PI / 180)));
                float f2 = Mth.cos((float)(this.shadow$getXRot() * ((float)Math.PI / 180)));
                float f3 = Mth.sin((float)(this.shadow$getYRot() * ((float)Math.PI / 180)));
                float f4 = Mth.cos((float)(this.shadow$getYRot() * ((float)Math.PI / 180)));
                float f5 = this.random.nextFloat() * ((float)Math.PI * 2);
                float f6 = 0.02f * this.random.nextFloat();
                itemEntity.setDeltaMovement((double)(-f3 * f2 * 0.3f) + Math.cos(f5) * (double)f6, (double)(-f8 * 0.3f + 0.1f + (this.random.nextFloat() - this.random.nextFloat()) * 0.1f), (double)(f4 * f2 * 0.3f) + Math.sin(f5) * (double)f6);
            }
            ItemEntity itemEntity2 = itemEntity;
            return itemEntity2;
        }
    }
}

