/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.profile;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.profile.property.ProfileProperty;
import org.spongepowered.common.profile.SpongeProfileProperty;
import org.spongepowered.common.util.Constants;

public final class SpongeGameProfile
implements GameProfile {
    private static final Gson GSON = new Gson();
    public static final UUID EMPTY_UUID = new UUID(0L, 0L);
    private final UUID uniqueId;
    private final @Nullable String name;
    private final List<SpongeProfileProperty> properties;

    public static SpongeGameProfile of(com.mojang.authlib.GameProfile mcProfile) {
        UUID uniqueId = mcProfile.getId() == null ? EMPTY_UUID : mcProfile.getId();
        String name = mcProfile.getName();
        List<SpongeProfileProperty> properties = mcProfile.getProperties().values().stream().map(SpongeProfileProperty::new).collect(Collectors.toList());
        return new SpongeGameProfile(uniqueId, name, properties);
    }

    public static SpongeGameProfile basicOf(com.mojang.authlib.GameProfile mcProfile) {
        UUID uniqueId = mcProfile.getId() == null ? EMPTY_UUID : mcProfile.getId();
        String name = mcProfile.getName();
        return new SpongeGameProfile(uniqueId, name);
    }

    public static com.mojang.authlib.GameProfile toMcProfile(GameProfile profile) {
        return ((SpongeGameProfile)profile).toMcProfile();
    }

    public static com.mojang.authlib.GameProfile toMcProfileNonNull(GameProfile profile) {
        return ((SpongeGameProfile)profile).toMcProfileNonNull();
    }

    public static GameProfile unsignedOf(GameProfile profile) {
        if (profile.properties().isEmpty()) {
            return profile;
        }
        return new SpongeGameProfile(profile.uniqueId(), profile.name().orElse(null), (List)profile.properties().stream().map(SpongeGameProfile::withoutSignature).collect(ImmutableList.toImmutableList()));
    }

    private static String decodeBase64(String value) {
        return new String(Base64.getDecoder().decode(value.getBytes(StandardCharsets.UTF_8)), Charsets.UTF_8);
    }

    private static String encodeBase64(String value) {
        return new String(Base64.getEncoder().encode(value.getBytes(StandardCharsets.UTF_8)), Charsets.UTF_8);
    }

    private static SpongeProfileProperty withoutSignature(ProfileProperty property) {
        JsonObject json;
        if (!property.hasSignature()) {
            return (SpongeProfileProperty)property;
        }
        String decoded = SpongeGameProfile.decodeBase64(property.value());
        try {
            json = GSON.fromJson(decoded, JsonObject.class);
        }
        catch (Throwable t) {
            return (SpongeProfileProperty)property;
        }
        if (!json.has("signatureRequired")) {
            return (SpongeProfileProperty)property;
        }
        json.remove("signatureRequired");
        String encoded = SpongeGameProfile.encodeBase64(GSON.toJson(json));
        return new SpongeProfileProperty(property.name(), encoded, null);
    }

    public SpongeGameProfile(UUID uniqueId, @Nullable String name) {
        Objects.requireNonNull(uniqueId, "uniqueId");
        this.uniqueId = uniqueId;
        this.name = name;
        this.properties = ImmutableList.of();
    }

    public SpongeGameProfile(UUID uniqueId, @Nullable String name, List<SpongeProfileProperty> properties) {
        Objects.requireNonNull(uniqueId, "uniqueId");
        Objects.requireNonNull(properties, "properties");
        this.uniqueId = uniqueId;
        this.name = name;
        this.properties = ImmutableList.copyOf(properties);
    }

    public com.mojang.authlib.GameProfile toMcProfile() {
        UUID uniqueId = this.uniqueId.equals(EMPTY_UUID) ? null : this.uniqueId;
        String name = this.name;
        com.mojang.authlib.GameProfile mcProfile = new com.mojang.authlib.GameProfile(uniqueId, name);
        for (SpongeProfileProperty property : this.properties) {
            mcProfile.getProperties().put((Object)property.name(), (Object)property.asProperty());
        }
        return mcProfile;
    }

    public com.mojang.authlib.GameProfile toMcProfileNonNull() {
        UUID uniqueId = this.uniqueId;
        String name = Strings.nullToEmpty((String)this.name);
        com.mojang.authlib.GameProfile mcProfile = new com.mojang.authlib.GameProfile(uniqueId, name);
        for (SpongeProfileProperty property : this.properties) {
            mcProfile.getProperties().put((Object)property.name(), (Object)property.asProperty());
        }
        return mcProfile;
    }

    @Override
    public @NonNull UUID uniqueId() {
        return this.uniqueId;
    }

    @Override
    public @NonNull Optional<String> name() {
        return Optional.ofNullable(this.name);
    }

    @Override
    public @NonNull GameProfile withName(@Nullable String name) {
        return new SpongeGameProfile(this.uniqueId, name, this.properties);
    }

    @Override
    public @NonNull List<ProfileProperty> properties() {
        return this.properties;
    }

    @Override
    public @NonNull GameProfile withoutProperties() {
        return new SpongeGameProfile(this.uniqueId, this.name);
    }

    @Override
    public @NonNull GameProfile withProperties(Iterable<ProfileProperty> properties) {
        return new SpongeGameProfile(this.uniqueId, this.name, (List<SpongeProfileProperty>)ImmutableList.builder().addAll(this.properties).addAll(properties).build());
    }

    @Override
    public @NonNull GameProfile withProperty(ProfileProperty property) {
        return new SpongeGameProfile(this.uniqueId, this.name, (List<SpongeProfileProperty>)ImmutableList.builder().addAll(this.properties).add((Object)((SpongeProfileProperty)property)).build());
    }

    @Override
    public @NonNull GameProfile withoutProperties(@NonNull Iterable<ProfileProperty> properties) {
        List toRemove = properties instanceof Collection ? (List)properties : ImmutableList.copyOf(properties);
        return new SpongeGameProfile(this.uniqueId, this.name, (List)this.properties.stream().filter(property -> !toRemove.contains(property)).collect(ImmutableList.toImmutableList()));
    }

    @Override
    public @NonNull GameProfile withoutProperty(ProfileProperty propertyToRemove) {
        return new SpongeGameProfile(this.uniqueId, this.name, (List)this.properties.stream().filter(property -> !propertyToRemove.equals(property)).collect(ImmutableList.toImmutableList()));
    }

    @Override
    public @NonNull GameProfile withoutProperties(Predicate<ProfileProperty> filter) {
        return new SpongeGameProfile(this.uniqueId, this.name, (List)this.properties.stream().filter(property -> !filter.test((ProfileProperty)property)).collect(ImmutableList.toImmutableList()));
    }

    @Override
    public int contentVersion() {
        return 1;
    }

    @Override
    public @NonNull DataContainer toContainer() {
        DataContainer container = DataContainer.createNew().set(Queries.CONTENT_VERSION, this.contentVersion()).set(Constants.Profile.UUID, this.uniqueId().toString());
        if (this.name != null) {
            container.set(Constants.Profile.NAME, this.name);
        }
        if (!this.properties.isEmpty()) {
            ArrayList<DataContainer> entries = new ArrayList<DataContainer>(this.properties.size());
            for (ProfileProperty profileProperty : this.properties) {
                entries.add(profileProperty.toContainer());
            }
            container.set(Constants.Profile.PROPERTIES, entries);
        }
        return container;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeGameProfile that = (SpongeGameProfile)o;
        return this.uniqueId.equals(that.uniqueId) && Objects.equals(this.name, that.name) && this.properties.size() == that.properties.size() && this.properties.containsAll(that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.uniqueId, this.name, Arrays.hashCode(this.properties.toArray()));
    }

    public String toString() {
        return new StringJoiner(", ", SpongeGameProfile.class.getSimpleName() + "[", "]").add("uniqueId=" + this.uniqueId).add("name=" + this.name).toString();
    }

    public static final class Factory
    implements GameProfile.Factory {
        @Override
        public @NonNull GameProfile of(@NonNull UUID uniqueId, @Nullable String name) {
            Objects.requireNonNull(uniqueId);
            return new SpongeGameProfile(uniqueId, name);
        }
    }
}

