/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry;

import com.mojang.serialization.Lifecycle;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;

public final class CallbackRegistry<T>
extends MappedRegistry<T> {
    private final BiConsumer<ResourceKey<T>, T> callback;
    private boolean callbackEnabled;

    public CallbackRegistry(ResourceKey<? extends Registry<T>> key, Lifecycle lifecycle, BiConsumer<ResourceKey<T>, T> callback) {
        super(key, lifecycle, null);
        this.callback = callback;
    }

    public Holder<T> register(ResourceKey<T> key, T instance, Lifecycle lifecycle) {
        Holder value = super.register(key, instance, lifecycle);
        if (this.callbackEnabled) {
            this.callback.accept((ResourceKey<ResourceKey<T>>)key, (ResourceKey<T>)instance);
        }
        return value;
    }

    public void setCallbackEnabled(boolean callbackEnabled) {
        this.callbackEnabled = callbackEnabled;
    }
}

