/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import org.spongepowered.api.Server;
import org.spongepowered.api.effect.potion.PotionEffect;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.cause.entity.damage.DamageFunction;
import org.spongepowered.api.event.cause.entity.damage.DamageModifier;
import org.spongepowered.api.event.cause.entity.damage.DamageModifierTypes;
import org.spongepowered.api.event.cause.entity.damage.source.BlockDamageSource;
import org.spongepowered.api.event.cause.entity.damage.source.FallingBlockDamageSource;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.accessor.world.entity.LivingEntityAccessor;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.VecHelper;

public final class DamageEventUtil {
    public static final DoubleUnaryOperator HARD_HAT_FUNCTION = damage -> -(damage - damage * 0.75);

    private DamageEventUtil() {
    }

    public static DoubleUnaryOperator createResistanceFunction(int resistanceAmplifier) {
        int base = (resistanceAmplifier + 1) * 5;
        int modifier = 25 - base;
        return damage -> -(damage - Math.max(damage * (double)modifier / 25.0, 0.0));
    }

    public static Optional<DamageFunction> createHardHatModifier(LivingEntity living, DamageSource damageSource) {
        if (damageSource instanceof FallingBlockDamageSource && !living.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
            DamageModifier modifier = DamageModifier.builder().cause(Cause.of(EventContext.empty(), ((org.spongepowered.api.item.inventory.ItemStack)living.getItemBySlot(EquipmentSlot.HEAD)).createSnapshot())).type(DamageModifierTypes.HARD_HAT).build();
            return Optional.of(new DamageFunction(modifier, HARD_HAT_FUNCTION));
        }
        return Optional.empty();
    }

    public static Optional<DamageFunction> createArmorModifiers(LivingEntity living, DamageSource damageSource) {
        DamageFunction armorModifier;
        if (damageSource.isBypassArmor()) {
            return Optional.empty();
        }
        DoubleUnaryOperator function = incomingDamage -> -(incomingDamage - (double)CombatRules.getDamageAfterAbsorb((float)((float)incomingDamage), (float)living.getArmorValue(), (float)((float)living.getAttributeValue(Attributes.ARMOR_TOUGHNESS))));
        try (CauseStackManager.StackFrame frame = ((Server)living.getServer()).causeStackManager().pushCauseFrame();){
            frame.pushCause(living);
            frame.pushCause(Attributes.ARMOR_TOUGHNESS);
            armorModifier = DamageFunction.of(DamageModifier.builder().cause(frame.currentCause()).type(DamageModifierTypes.ARMOR).build(), function);
        }
        return Optional.of(armorModifier);
    }

    public static Optional<DamageFunction> createResistanceModifier(LivingEntity living, DamageSource damageSource) {
        PotionEffect effect = (PotionEffect)living.getEffect(MobEffects.DAMAGE_RESISTANCE);
        if (!damageSource.isBypassMagic() && effect != null && damageSource != DamageSource.OUT_OF_WORLD) {
            return Optional.of(new DamageFunction(DamageModifier.builder().cause(Cause.of(EventContext.empty(), effect)).type(DamageModifierTypes.DEFENSIVE_POTION_EFFECT).build(), DamageEventUtil.createResistanceFunction(effect.amplifier())));
        }
        return Optional.empty();
    }

    public static Optional<List<DamageFunction>> createEnchantmentModifiers(LivingEntity living, DamageSource damageSource) {
        if (damageSource.isBypassMagic()) {
            return Optional.empty();
        }
        Iterable inventory = living.getArmorSlots();
        int damageProtection = EnchantmentHelper.getDamageProtection((Iterable)inventory, (DamageSource)damageSource);
        if (damageProtection <= 0) {
            return Optional.empty();
        }
        ArrayList<DamageFunction> modifiers = new ArrayList<DamageFunction>();
        DoubleUnaryOperator enchantmentFunction = incomingDamage -> -(incomingDamage - (double)CombatRules.getDamageAfterMagicAbsorb((float)((float)incomingDamage), (float)damageProtection));
        try (CauseStackManager.StackFrame frame = ((Server)living.getServer()).causeStackManager().pushCauseFrame();){
            frame.pushCause(living);
            DamageModifier enchantmentModifier = DamageModifier.builder().cause(frame.currentCause()).type(DamageModifierTypes.ARMOR_ENCHANTMENT).build();
            modifiers.add(new DamageFunction(enchantmentModifier, enchantmentFunction));
        }
        return Optional.of(modifiers);
    }

    public static Optional<DamageFunction> createAbsorptionModifier(LivingEntity living) {
        float absorptionAmount = living.getAbsorptionAmount();
        if (absorptionAmount > 0.0f) {
            DoubleUnaryOperator function = damage -> -Math.max(damage - Math.max(damage - (double)absorptionAmount, 0.0), 0.0);
            DamageModifier modifier = DamageModifier.builder().cause(Cause.of(EventContext.empty(), living)).type(DamageModifierTypes.ABSORPTION).build();
            return Optional.of(new DamageFunction(modifier, function));
        }
        return Optional.empty();
    }

    public static ServerLocation findFirstMatchingBlock(net.minecraft.world.entity.Entity entity, AABB bb, Predicate<BlockState> predicate) {
        int i = Mth.floor((double)bb.minX);
        int j = Mth.floor((double)(bb.maxX + 1.0));
        int k = Mth.floor((double)bb.minY);
        int l = Mth.floor((double)(bb.maxY + 1.0));
        int i1 = Mth.floor((double)bb.minZ);
        int j1 = Mth.floor((double)(bb.maxZ + 1.0));
        ChunkSource chunkSource = entity.level.getChunkSource();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    BlockPos blockPos = new BlockPos(k1, l1, i2);
                    LevelChunk chunk = chunkSource.getChunk(blockPos.getX() >> 4, blockPos.getZ() >> 4, false);
                    if (chunk == null || chunk.isEmpty() || !predicate.test(chunk.getBlockState(blockPos))) continue;
                    return ServerLocation.of((ServerWorld)entity.level, k1, l1, i2);
                }
            }
        }
        return ((Entity)entity).serverLocation();
    }

    public static void generateCauseFor(DamageSource damageSource, CauseStackManager.StackFrame frame) {
        if (damageSource instanceof EntityDamageSource) {
            net.minecraft.world.entity.Entity source = damageSource.getEntity();
            if (!(source instanceof Player) && source instanceof CreatorTrackedBridge) {
                CreatorTrackedBridge creatorBridge = (CreatorTrackedBridge)source;
                creatorBridge.tracker$getCreatorUUID().ifPresent(creator -> frame.addContext(EventContextKeys.CREATOR, creator));
                creatorBridge.tracker$getNotifierUUID().ifPresent(notifier -> frame.addContext(EventContextKeys.NOTIFIER, notifier));
            }
        } else if (damageSource instanceof BlockDamageSource) {
            ServerLocation location = ((BlockDamageSource)damageSource).location();
            BlockPos blockPos = VecHelper.toBlockPos(location);
            LevelChunkBridge chunkBridge = (LevelChunkBridge)((Level)location.world()).getChunkAt(blockPos);
            chunkBridge.bridge$getBlockCreatorUUID(blockPos).ifPresent(creator -> frame.addContext(EventContextKeys.CREATOR, creator));
            chunkBridge.bridge$getBlockNotifierUUID(blockPos).ifPresent(notifier -> frame.addContext(EventContextKeys.NOTIFIER, notifier));
        }
        frame.pushCause(damageSource);
    }

    public static List<DamageFunction> createAttackEnchantmentFunction(ItemStack heldItem, MobType creatureAttribute, float attackStrength) {
        if (heldItem.isEmpty()) {
            return Collections.emptyList();
        }
        ListTag enchantmentCompounds = heldItem.getEnchantmentTags();
        if (enchantmentCompounds.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<Enchantment, Collection> enchantments = new HashMap<Enchantment, Collection>();
        for (int i = 0; i < enchantmentCompounds.size(); ++i) {
            String id = enchantmentCompounds.getCompound(i).getString("id");
            int enchantmentLevel = enchantmentCompounds.getCompound(i).getInt("lvl");
            Enchantment enchantment = (Enchantment)Registry.ENCHANTMENT.get(new ResourceLocation(id));
            if (enchantment == null) continue;
            enchantments.computeIfAbsent(enchantment, k -> new ArrayList()).add(enchantmentLevel);
        }
        if (enchantments.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DamageFunction> damageModifierFunctions = new ArrayList<DamageFunction>();
        ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(heldItem);
        for (Map.Entry entry : enchantments.entrySet()) {
            DamageModifier enchantmentModifier = DamageModifier.builder().type(DamageModifierTypes.WEAPON_ENCHANTMENT).cause(Cause.of(EventContext.empty(), snapshot, entry)).build();
            DoubleUnaryOperator enchantmentFunction = damage -> {
                double totalDamage = 0.0;
                Iterator iterator = ((Collection)entry.getValue()).iterator();
                while (iterator.hasNext()) {
                    int level = (Integer)iterator.next();
                    totalDamage += (double)((Enchantment)entry.getKey()).getDamageBonus(level, creatureAttribute) * (double)attackStrength;
                }
                return totalDamage;
            };
            damageModifierFunctions.add(new DamageFunction(enchantmentModifier, enchantmentFunction));
        }
        return damageModifierFunctions;
    }

    public static DamageFunction provideCriticalAttackTuple(Player player, double criticalModifier) {
        DamageModifier modifier = DamageModifier.builder().cause(Cause.of(EventContext.empty(), player)).type(DamageModifierTypes.CRITICAL_HIT).build();
        DoubleUnaryOperator function = damage -> damage * criticalModifier;
        return new DamageFunction(modifier, function);
    }

    public static DamageFunction provideCooldownAttackStrengthFunction(Player player, float attackStrength) {
        DamageModifier modifier = DamageModifier.builder().cause(Cause.of(EventContext.empty(), player)).type(DamageModifierTypes.ATTACK_COOLDOWN).build();
        DoubleUnaryOperator function = damage -> -damage + damage * (double)(0.2f + attackStrength * attackStrength * 0.8f);
        return new DamageFunction(modifier, function);
    }

    public static Optional<DamageFunction> createShieldFunction(LivingEntity entity, DamageSource source, float amount) {
        if (entity.isBlocking() && (double)amount > 0.0 && ((LivingEntityAccessor)entity).invoker$isDamageSourceBlocked(source)) {
            DamageModifier modifier = DamageModifier.builder().cause(Cause.of(EventContext.empty(), entity, ((org.spongepowered.api.item.inventory.ItemStack)entity.getUseItem()).createSnapshot())).type(DamageModifierTypes.SHIELD).build();
            return Optional.of(new DamageFunction(modifier, damage -> -damage));
        }
        return Optional.empty();
    }
}

