/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.biome;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.CheckerboardColumnBiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.biome.TheEndBiomeSource;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.registry.RegistryReference;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.world.biome.AttributedBiome;
import org.spongepowered.api.world.biome.BiomeAttributes;
import org.spongepowered.api.world.biome.provider.BiomeProvider;
import org.spongepowered.api.world.biome.provider.CheckerboardBiomeConfig;
import org.spongepowered.api.world.biome.provider.ConfigurableBiomeProvider;
import org.spongepowered.api.world.biome.provider.EndStyleBiomeConfig;
import org.spongepowered.api.world.biome.provider.MultiNoiseBiomeConfig;
import org.spongepowered.common.accessor.world.level.biome.MultiNoiseBiomeSourceAccessor;
import org.spongepowered.common.accessor.world.level.biome.TheEndBiomeSourceAccessor;
import org.spongepowered.common.server.BootstrapProperties;

public final class SpongeBiomeProviderFactory
implements BiomeProvider.Factory {
    @Override
    public ConfigurableBiomeProvider<MultiNoiseBiomeConfig> overworld() {
        Registry biomeRegistry = (Registry)Sponge.server().registry(RegistryTypes.BIOME);
        return (ConfigurableBiomeProvider)MultiNoiseBiomeSource.Preset.OVERWORLD.biomeSource(biomeRegistry);
    }

    @Override
    public <T extends MultiNoiseBiomeConfig> ConfigurableBiomeProvider<T> multiNoise(T config) {
        Registry biomeRegistry = (Registry)Sponge.server().registry(RegistryTypes.BIOME);
        ArrayList<Pair> climateParams = new ArrayList<Pair>();
        for (AttributedBiome attributedBiome : config.attributedBiomes()) {
            BiomeAttributes attr = attributedBiome.attributes();
            Climate.ParameterPoint point = Climate.parameters((Climate.Parameter)Climate.Parameter.span((float)attr.temperature().min().floatValue(), (float)attr.temperature().max().floatValue()), (Climate.Parameter)Climate.Parameter.span((float)attr.humidity().min().floatValue(), (float)attr.humidity().max().floatValue()), (Climate.Parameter)Climate.Parameter.span((float)attr.continentalness().min().floatValue(), (float)attr.continentalness().max().floatValue()), (Climate.Parameter)Climate.Parameter.span((float)attr.erosion().min().floatValue(), (float)attr.erosion().max().floatValue()), (Climate.Parameter)Climate.Parameter.span((float)attr.depth().min().floatValue(), (float)attr.depth().max().floatValue()), (Climate.Parameter)Climate.Parameter.span((float)attr.weirdness().min().floatValue(), (float)attr.weirdness().max().floatValue()), (float)attr.offset());
            Holder biome = biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registry.BIOME_REGISTRY, (ResourceLocation)((ResourceLocation)attributedBiome.biome().location())));
            climateParams.add(Pair.of((Object)point, (Object)biome));
        }
        return (ConfigurableBiomeProvider)MultiNoiseBiomeSourceAccessor.invoker$new((Climate.ParameterList<Holder<Biome>>)new Climate.ParameterList(climateParams));
    }

    @Override
    public ConfigurableBiomeProvider<MultiNoiseBiomeConfig> nether() {
        Registry biomeRegistry = (Registry)Sponge.server().registry(RegistryTypes.BIOME);
        return (ConfigurableBiomeProvider)MultiNoiseBiomeSource.Preset.NETHER.biomeSource(biomeRegistry);
    }

    @Override
    public <T extends EndStyleBiomeConfig> ConfigurableBiomeProvider<T> endStyle(T config) {
        Registry biomeRegistry = (Registry)Sponge.server().registry(RegistryTypes.BIOME);
        return (ConfigurableBiomeProvider)TheEndBiomeSourceAccessor.invoker$new(config.seed(), (Holder<Biome>)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registry.BIOME_REGISTRY, (ResourceLocation)((ResourceLocation)config.endBiome().location()))), (Holder<Biome>)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registry.BIOME_REGISTRY, (ResourceLocation)((ResourceLocation)config.highlandsBiome().location()))), (Holder<Biome>)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registry.BIOME_REGISTRY, (ResourceLocation)((ResourceLocation)config.midlandsBiome().location()))), (Holder<Biome>)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registry.BIOME_REGISTRY, (ResourceLocation)((ResourceLocation)config.islandsBiome().location()))), (Holder<Biome>)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registry.BIOME_REGISTRY, (ResourceLocation)((ResourceLocation)config.barrensBiome().location()))));
    }

    @Override
    public ConfigurableBiomeProvider<EndStyleBiomeConfig> end() {
        Registry biomeRegistry = (Registry)Sponge.server().registry(RegistryTypes.BIOME);
        long seed = BootstrapProperties.worldGenSettings.seed();
        return (ConfigurableBiomeProvider)new TheEndBiomeSource(biomeRegistry, seed);
    }

    @Override
    public <T extends CheckerboardBiomeConfig> ConfigurableBiomeProvider<T> checkerboard(T config) {
        Registry biomeRegistry = (Registry)Sponge.server().registry(RegistryTypes.BIOME);
        ArrayList<Holder> biomes = new ArrayList<Holder>();
        for (RegistryReference<org.spongepowered.api.world.biome.Biome> biome : config.biomes()) {
            ResourceKey key = ResourceKey.create((ResourceKey)Registry.BIOME_REGISTRY, (ResourceLocation)((ResourceLocation)biome.location()));
            biomes.add(biomeRegistry.getHolderOrThrow(key));
        }
        return (ConfigurableBiomeProvider)new CheckerboardColumnBiomeSource((HolderSet)HolderSet.direct(biomes), config.scale());
    }

    @Override
    public BiomeProvider fixed(RegistryReference<org.spongepowered.api.world.biome.Biome> biome) {
        Objects.requireNonNull(biome, "biome");
        return (BiomeProvider)new FixedBiomeSource((Holder)biome);
    }
}

