/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.generation;

import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.biome.TheEndBiomeSource;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.world.biome.provider.BiomeProvider;
import org.spongepowered.api.world.generation.ChunkGenerator;
import org.spongepowered.api.world.generation.ConfigurableChunkGenerator;
import org.spongepowered.api.world.generation.config.FlatGeneratorConfig;
import org.spongepowered.api.world.generation.config.NoiseGeneratorConfig;
import org.spongepowered.common.server.BootstrapProperties;
import org.spongepowered.common.util.SeedUtil;

public final class SpongeChunkGeneratorFactory
implements ChunkGenerator.Factory {
    @Override
    public <T extends FlatGeneratorConfig> ConfigurableChunkGenerator<T> flat(T config) {
        Registry structureRegistry = BootstrapProperties.registries.registryOrThrow(Registry.STRUCTURE_SET_REGISTRY);
        return (ConfigurableChunkGenerator)new FlatLevelSource(structureRegistry, (FlatLevelGeneratorSettings)config);
    }

    private <T extends NoiseGeneratorConfig> ConfigurableChunkGenerator<T> noiseBasedChunkGenerator(long seed, BiomeSource biomeSource, Holder<NoiseGeneratorSettings> noiseGeneratorSettings) {
        Registry noiseRegistry = BootstrapProperties.registries.registryOrThrow(Registry.NOISE_REGISTRY);
        Registry structureRegistry = BootstrapProperties.registries.registryOrThrow(Registry.STRUCTURE_SET_REGISTRY);
        return (ConfigurableChunkGenerator)new NoiseBasedChunkGenerator(structureRegistry, noiseRegistry, biomeSource, seed, noiseGeneratorSettings);
    }

    @Override
    public <T extends NoiseGeneratorConfig> ConfigurableChunkGenerator<T> noise(BiomeProvider provider, T config) {
        long seed = BootstrapProperties.worldGenSettings.seed();
        BiomeSource biomeSource = (BiomeSource)Objects.requireNonNull(provider, "provider");
        NoiseGeneratorSettings noiseGeneratorSettings = (NoiseGeneratorSettings)Objects.requireNonNull(config, "config");
        return this.noiseBasedChunkGenerator(seed, biomeSource, (Holder<NoiseGeneratorSettings>)Holder.direct((Object)noiseGeneratorSettings));
    }

    @Override
    public <T extends NoiseGeneratorConfig> ConfigurableChunkGenerator<T> noise(BiomeProvider provider, long seed, T config) {
        BiomeSource biomeSource = (BiomeSource)Objects.requireNonNull(provider, "provider");
        NoiseGeneratorSettings noiseGeneratorSettings = (NoiseGeneratorSettings)Objects.requireNonNull(config, "config");
        return this.noiseBasedChunkGenerator(seed, biomeSource, (Holder<NoiseGeneratorSettings>)Holder.direct((Object)noiseGeneratorSettings));
    }

    @Override
    public <T extends NoiseGeneratorConfig> ConfigurableChunkGenerator<T> noise(BiomeProvider provider, String seed, T config) {
        return this.noise(provider, SeedUtil.compute(seed), config);
    }

    @Override
    public ConfigurableChunkGenerator<NoiseGeneratorConfig> overworld() {
        long seed = BootstrapProperties.worldGenSettings.seed();
        return (ConfigurableChunkGenerator)WorldGenSettings.makeDefaultOverworld((RegistryAccess)BootstrapProperties.registries, (long)seed);
    }

    @Override
    public ConfigurableChunkGenerator<NoiseGeneratorConfig> theNether() {
        Registry biomeRegistry = (Registry)Sponge.server().registry(RegistryTypes.BIOME);
        Registry noiseGeneratorSettingsRegistry = BootstrapProperties.registries.registryOrThrow(Registry.NOISE_GENERATOR_SETTINGS_REGISTRY);
        long seed = BootstrapProperties.worldGenSettings.seed();
        MultiNoiseBiomeSource biomeSource = MultiNoiseBiomeSource.Preset.NETHER.biomeSource(biomeRegistry);
        return this.noiseBasedChunkGenerator(seed, (BiomeSource)biomeSource, (Holder<NoiseGeneratorSettings>)noiseGeneratorSettingsRegistry.getHolderOrThrow(NoiseGeneratorSettings.NETHER));
    }

    @Override
    public ConfigurableChunkGenerator<NoiseGeneratorConfig> theEnd() {
        Registry biomeRegistry = (Registry)Sponge.server().registry(RegistryTypes.BIOME);
        Registry noiseGeneratorSettingsRegistry = BootstrapProperties.registries.registryOrThrow(Registry.NOISE_GENERATOR_SETTINGS_REGISTRY);
        long seed = BootstrapProperties.worldGenSettings.seed();
        TheEndBiomeSource biomeSource = new TheEndBiomeSource(biomeRegistry, seed);
        return this.noiseBasedChunkGenerator(seed, (BiomeSource)biomeSource, (Holder<NoiseGeneratorSettings>)noiseGeneratorSettingsRegistry.getHolderOrThrow(NoiseGeneratorSettings.END));
    }
}

