/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.generation;

import com.mojang.serialization.Lifecycle;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import org.spongepowered.api.world.generation.config.WorldGenerationConfig;
import org.spongepowered.common.accessor.world.gen.DimensionGeneratorSettingsAccessor;
import org.spongepowered.common.server.BootstrapProperties;
import org.spongepowered.common.util.SeedUtil;

public final class SpongeWorldGenerationConfigMutableBuilder
implements WorldGenerationConfig.Mutable.Builder {
    private long seed;
    private boolean generateFeatures;
    private boolean generateBonusChest;

    @Override
    public WorldGenerationConfig.Mutable.Builder seed(long seed) {
        this.seed = seed;
        return this;
    }

    @Override
    public void seed(String seed) {
        this.seed = SeedUtil.compute(seed);
    }

    @Override
    public WorldGenerationConfig.Mutable.Builder generateFeatures(boolean generateFeatures) {
        this.generateFeatures = generateFeatures;
        return this;
    }

    @Override
    public WorldGenerationConfig.Mutable.Builder generateBonusChest(boolean generateBonusChest) {
        this.generateBonusChest = generateBonusChest;
        return this;
    }

    @Override
    public WorldGenerationConfig.Mutable.Builder reset() {
        WorldGenSettings defaultSettings = BootstrapProperties.worldGenSettings;
        this.seed = defaultSettings.seed();
        this.generateFeatures = defaultSettings.generateFeatures();
        this.generateBonusChest = defaultSettings.generateBonusChest();
        return this;
    }

    @Override
    public WorldGenerationConfig.Mutable.Builder from(WorldGenerationConfig value) {
        this.seed = Objects.requireNonNull(value, "value").seed();
        this.generateFeatures = value.generateFeatures();
        this.generateBonusChest = value.generateBonusChest();
        return this;
    }

    @Override
    public WorldGenerationConfig.Mutable build() {
        return (WorldGenerationConfig.Mutable)DimensionGeneratorSettingsAccessor.invoker$new(this.seed, this.generateFeatures, this.generateBonusChest, (Registry<LevelStem>)new MappedRegistry(Registry.LEVEL_STEM_REGISTRY, Lifecycle.stable(), null), Optional.empty());
    }
}

