/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.server;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.worldgen.features.MiscOverworldFeatures;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.ai.village.VillageSiege;
import net.minecraft.world.entity.npc.CatSpawner;
import net.minecraft.world.entity.npc.WanderingTraderSpawner;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ForcedChunksSavedData;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.PatrolSpawner;
import net.minecraft.world.level.levelgen.PhantomSpawner;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.storage.CommandStorage;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WorldData;
import org.apache.commons.io.FilenameUtils;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Server;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.world.LoadWorldEvent;
import org.spongepowered.api.event.world.UnloadWorldEvent;
import org.spongepowered.api.registry.RegistryEntry;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.util.file.DeleteFileVisitor;
import org.spongepowered.api.world.DefaultWorldKeys;
import org.spongepowered.api.world.WorldType;
import org.spongepowered.api.world.WorldTypes;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.api.world.server.WorldManager;
import org.spongepowered.api.world.server.WorldTemplate;
import org.spongepowered.api.world.server.storage.ServerWorldProperties;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.accessor.server.MinecraftServerAccessor;
import org.spongepowered.common.accessor.world.gen.DimensionGeneratorSettingsAccessor;
import org.spongepowered.common.accessor.world.level.storage.LevelStorageSource_LevelStorageAccessAccessor;
import org.spongepowered.common.accessor.world.level.storage.PrimaryLevelDataAccessor;
import org.spongepowered.common.bridge.ResourceKeyBridge;
import org.spongepowered.common.bridge.server.level.ServerLevelBridge;
import org.spongepowered.common.bridge.world.level.dimension.LevelStemBridge;
import org.spongepowered.common.bridge.world.level.levelgen.WorldGenSettingsBridge;
import org.spongepowered.common.bridge.world.level.storage.PrimaryLevelDataBridge;
import org.spongepowered.common.config.SpongeGameConfigs;
import org.spongepowered.common.config.inheritable.InheritableConfigHandle;
import org.spongepowered.common.config.inheritable.WorldConfig;
import org.spongepowered.common.datapack.DataPackSerializer;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.hooks.PlatformHooks;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.common.server.BootstrapProperties;
import org.spongepowered.common.user.SpongeUserManager;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.FutureUtil;
import org.spongepowered.common.world.server.SpongeWorldTemplate;

public abstract class SpongeWorldManager
implements WorldManager {
    private final MinecraftServer server;
    private final Path dimensionsDataPackDirectory;
    private final Path defaultWorldDirectory;
    private final Path customWorldsDirectory;
    private final Map<net.minecraft.resources.ResourceKey<Level>, ServerLevel> worlds;
    private static final TicketType<ResourceLocation> SPAWN_CHUNKS = TicketType.create((String)"spawn_chunks", ResourceLocation::compareTo);

    public SpongeWorldManager(MinecraftServer server) {
        this.server = server;
        this.dimensionsDataPackDirectory = ((MinecraftServerAccessor)server).accessor$storageSource().getLevelPath(LevelResource.DATAPACK_DIR).resolve("plugin_dimension").resolve("data");
        try {
            Files.createDirectories(this.dimensionsDataPackDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.defaultWorldDirectory = ((LevelStorageSource_LevelStorageAccessAccessor)((MinecraftServerAccessor)this.server).accessor$storageSource()).accessor$levelPath();
        this.customWorldsDirectory = this.defaultWorldDirectory.resolve("dimensions");
        try {
            Files.createDirectories(this.customWorldsDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.worlds = ((MinecraftServerAccessor)this.server).accessor$levels();
    }

    @Override
    public Server server() {
        return (Server)this.server;
    }

    public Path getDefaultWorldDirectory() {
        return this.defaultWorldDirectory;
    }

    public Path getDimensionDataPackDirectory() {
        return this.dimensionsDataPackDirectory;
    }

    @Override
    public Optional<ServerWorld> world(ResourceKey key) {
        return Optional.ofNullable((ServerWorld)this.worlds.get(SpongeWorldManager.createRegistryKey(Objects.requireNonNull(key, "key"))));
    }

    @Override
    public Optional<Path> worldDirectory(ResourceKey key) {
        Objects.requireNonNull(key, "key");
        Path directory = this.getDirectory(key);
        if (Files.notExists(directory, new LinkOption[0])) {
            return Optional.empty();
        }
        return Optional.of(directory);
    }

    @Override
    public Collection<ServerWorld> worlds() {
        return Collections.unmodifiableCollection(this.worlds.values());
    }

    @Override
    public List<ResourceKey> worldKeys() {
        ArrayList<ResourceKey> worldKeys = new ArrayList<ResourceKey>();
        worldKeys.add(DefaultWorldKeys.DEFAULT);
        if (Files.exists(this.getDirectory(DefaultWorldKeys.THE_NETHER), new LinkOption[0])) {
            worldKeys.add(DefaultWorldKeys.THE_NETHER);
        }
        if (Files.exists(this.getDirectory(DefaultWorldKeys.THE_END), new LinkOption[0])) {
            worldKeys.add(DefaultWorldKeys.THE_END);
        }
        try {
            for (Path namespacedDirectory : Files.list(this.customWorldsDirectory).toList()) {
                if (this.customWorldsDirectory.equals(namespacedDirectory)) continue;
                for (Path valueDirectory : Files.list(namespacedDirectory).toList()) {
                    if (namespacedDirectory.equals(valueDirectory)) continue;
                    worldKeys.add(ResourceKey.of(namespacedDirectory.getFileName().toString(), valueDirectory.getFileName().toString()));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Collections.unmodifiableList(worldKeys);
    }

    @Override
    public List<ResourceKey> templateKeys() {
        ArrayList<ResourceKey> templateKeys = new ArrayList<ResourceKey>();
        templateKeys.add(WorldTypes.OVERWORLD.location());
        templateKeys.add(WorldTypes.THE_NETHER.location());
        templateKeys.add(WorldTypes.THE_END.location());
        try (Stream<Path> pluginDirectories = Files.list(this.getDimensionDataPackDirectory());){
            pluginDirectories.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(pluginDirectory -> {
                Path dimensionPath = pluginDirectory.resolve("dimension");
                if (Files.isDirectory(dimensionPath, new LinkOption[0])) {
                    try (Stream<Path> pluginTemplates = Files.list(dimensionPath);){
                        pluginTemplates.filter(template -> template.toString().endsWith(".json")).forEach(template -> templateKeys.add((ResourceKey)new ResourceLocation(pluginDirectory.getFileName().toString(), FilenameUtils.removeExtension((String)template.getFileName().toString()))));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return templateKeys;
    }

    @Override
    public boolean worldExists(ResourceKey key) {
        net.minecraft.resources.ResourceKey<Level> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(key, "key"));
        if (Level.OVERWORLD.equals(registryKey)) {
            return true;
        }
        if (this.worlds.get(registryKey) != null) {
            return true;
        }
        return Files.exists(this.getDirectory(key), new LinkOption[0]);
    }

    @Override
    public Optional<ResourceKey> worldKey(UUID uniqueId) {
        Objects.requireNonNull(uniqueId, "uniqueId");
        return this.worlds.values().stream().filter(w -> ((ServerWorld)w).uniqueId().equals(uniqueId)).map(w -> (ServerWorld)w).map(ServerWorld::key).findAny();
    }

    @Override
    public Collection<ServerWorld> worldsOfType(WorldType type) {
        Objects.requireNonNull(type, "type");
        return this.worlds().stream().filter(w -> w.worldType() == type).collect(Collectors.toList());
    }

    @Override
    public CompletableFuture<ServerWorld> loadWorld(WorldTemplate template) {
        ResourceKey key = Objects.requireNonNull(template, "template").key();
        net.minecraft.resources.ResourceKey<Level> registryKey = SpongeWorldManager.createRegistryKey(key);
        if (Level.OVERWORLD.equals(registryKey)) {
            return FutureUtil.completedWithException(new IllegalArgumentException("The default world cannot be told to load!"));
        }
        ServerLevel serverWorld = this.worlds.get(registryKey);
        if (serverWorld != null) {
            return CompletableFuture.completedFuture((ServerWorld)serverWorld);
        }
        this.saveTemplate(template);
        return this.loadWorld0(registryKey, ((SpongeWorldTemplate)template).asLevelStem(), (WorldGenSettings)template.generationConfig());
    }

    @Override
    public CompletableFuture<ServerWorld> loadWorld(ResourceKey key) {
        net.minecraft.resources.ResourceKey<Level> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(key, "key"));
        if (Level.OVERWORLD.equals(registryKey)) {
            return FutureUtil.completedWithException(new IllegalArgumentException("The default world cannot be told to load!"));
        }
        ServerLevel world = this.worlds.get(registryKey);
        if (world != null) {
            return CompletableFuture.completedFuture((ServerWorld)world);
        }
        return this.loadTemplate(key).thenCompose(r -> {
            WorldTemplate loadedTemplate = r.orElse(null);
            if (loadedTemplate == null) {
                LevelStem scratch = (LevelStem)BootstrapProperties.worldGenSettings.dimensions().get(SpongeWorldManager.createStemKey(key));
                if (scratch != null) {
                    ((ResourceKeyBridge)scratch).bridge$setKey(key);
                    loadedTemplate = new SpongeWorldTemplate(scratch);
                }
                if (loadedTemplate == null) {
                    return FutureUtil.completedWithException(new IOException(String.format("Failed to load a template for '%s'!", key)));
                }
                this.saveTemplate(loadedTemplate);
            }
            return this.loadWorld0(registryKey, ((SpongeWorldTemplate)loadedTemplate).asLevelStem(), (WorldGenSettings)loadedTemplate.generationConfig());
        });
    }

    private CompletableFuture<ServerWorld> loadWorld0(net.minecraft.resources.ResourceKey<Level> registryKey, LevelStem template, WorldGenSettings generatorSettings) {
        LevelStorageSource.LevelStorageAccess storageSource;
        PrimaryLevelData defaultLevelData = (PrimaryLevelData)this.server.getWorldData();
        LevelSettings defaultLevelSettings = ((PrimaryLevelDataAccessor)defaultLevelData).accessor$settings();
        LevelStemBridge templateBridge = (LevelStemBridge)template;
        ResourceKey worldKey = ((ResourceKeyBridge)((Object)templateBridge)).bridge$getKey();
        Holder dimensionTypeHolder = template.typeHolder();
        WorldType worldType = (WorldType)dimensionTypeHolder.value();
        Optional<ResourceKey> worldTypeKey = RegistryTypes.WORLD_TYPE.get().findValueKey(worldType);
        MinecraftServerAccessor.accessor$LOGGER().info("Loading world '{}' ({})", (Object)worldKey, (Object)worldTypeKey.map(Object::toString).orElse("inline"));
        String directoryName = this.getDirectoryName(worldKey);
        try {
            storageSource = this.createStorageSource(worldKey);
        }
        catch (IOException e) {
            return FutureUtil.completedWithException(new RuntimeException(String.format("Failed to create level data for world '%s'!", worldKey), e));
        }
        PrimaryLevelData levelData = (PrimaryLevelData)storageSource.getDataTag(BootstrapProperties.worldSettingsAdapter, defaultLevelSettings.getDataPackConfig(), Lifecycle.stable());
        if (levelData == null) {
            WorldGenSettings generationSettings;
            LevelSettings levelSettings;
            if (this.server.isDemo()) {
                levelSettings = MinecraftServer.DEMO_SETTINGS;
                generationSettings = WorldGenSettings.demoSettings((RegistryAccess)BootstrapProperties.registries);
            } else {
                levelSettings = new LevelSettings(directoryName, (GameType)BootstrapProperties.gameMode.get(Sponge.game()), templateBridge.bridge$hardcore().orElse(BootstrapProperties.hardcore).booleanValue(), (Difficulty)BootstrapProperties.difficulty.get(Sponge.game()), templateBridge.bridge$commands().orElse(BootstrapProperties.commands).booleanValue(), new GameRules(), defaultLevelData.getDataPackConfig());
                generationSettings = generatorSettings;
            }
            levelData = new PrimaryLevelData(levelSettings, generationSettings, Lifecycle.stable());
        }
        ((PrimaryLevelDataBridge)levelData).bridge$populateFromDimension(template);
        InheritableConfigHandle<WorldConfig> configAdapter = SpongeGameConfigs.createWorld(worldTypeKey.orElse(null), worldKey);
        ((PrimaryLevelDataBridge)levelData).bridge$configAdapter(configAdapter);
        levelData.setModdedInfo(this.server.getServerModName(), this.server.getModdedStatus().shouldReportAsModified());
        boolean isDebugGeneration = levelData.worldGenSettings().isDebug();
        long seed = BiomeManager.obfuscateSeed((long)levelData.worldGenSettings().seed());
        ChunkProgressListener chunkStatusListener = ((MinecraftServerAccessor)this.server).accessor$progressListenerFactory().create(11);
        ServerLevel world = new ServerLevel(this.server, ((MinecraftServerAccessor)this.server).accessor$executor(), storageSource, (ServerLevelData)levelData, registryKey, dimensionTypeHolder, chunkStatusListener, template.generator(), isDebugGeneration, seed, (List)ImmutableList.of(), true);
        this.worlds.put(registryKey, world);
        this.prepareWorld(world, isDebugGeneration);
        ((MinecraftServerAccessor)this.server).invoker$forceDifficulty();
        return this.postWorldLoad(world, false).thenApply(w -> (ServerWorld)w);
    }

    @Override
    public CompletableFuture<Boolean> unloadWorld(ResourceKey key) {
        net.minecraft.resources.ResourceKey<Level> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(key, "key"));
        if (Level.OVERWORLD.equals(registryKey)) {
            return CompletableFuture.completedFuture(false);
        }
        ServerLevel world = this.worlds.get(registryKey);
        if (world == null) {
            return CompletableFuture.completedFuture(false);
        }
        return this.unloadWorld((ServerWorld)world);
    }

    @Override
    public CompletableFuture<Boolean> unloadWorld(ServerWorld world) {
        net.minecraft.resources.ResourceKey<Level> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(world, "world").key());
        if (Level.OVERWORLD.equals(registryKey)) {
            return CompletableFuture.completedFuture(false);
        }
        if (world != this.worlds.get(registryKey)) {
            return CompletableFuture.completedFuture(false);
        }
        try {
            this.unloadWorld0((ServerLevel)world);
            return CompletableFuture.completedFuture(true);
        }
        catch (IOException e) {
            return FutureUtil.completedWithException(e);
        }
    }

    @Override
    public boolean templateExists(ResourceKey key) {
        return Files.exists(this.getDataPackFile(Objects.requireNonNull(key, "key")), new LinkOption[0]);
    }

    @Override
    public CompletableFuture<Optional<WorldTemplate>> loadTemplate(ResourceKey key) {
        Path dataPackFile = this.getDataPackFile(Objects.requireNonNull(key, "key"));
        if (Files.exists(dataPackFile, new LinkOption[0])) {
            CompletableFuture<Optional<WorldTemplate>> completableFuture;
            block9: {
                BufferedReader reader = Files.newBufferedReader(dataPackFile);
                try {
                    LevelStem template = SpongeWorldManager.stemFromJson(key, JsonParser.parseReader(reader));
                    completableFuture = CompletableFuture.completedFuture(Optional.of(((LevelStemBridge)template).bridge$asTemplate()));
                    if (reader == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        return FutureUtil.completedWithException(e);
                    }
                }
                reader.close();
            }
            return completableFuture;
        }
        return CompletableFuture.completedFuture(Optional.empty());
    }

    @Override
    public CompletableFuture<Boolean> saveTemplate(WorldTemplate template) {
        LevelStem scratch = ((SpongeWorldTemplate)Objects.requireNonNull(template, "template")).asLevelStem();
        try {
            JsonElement element = SpongeWorldManager.stemToJson(scratch);
            this.writeTemplate(element, template.key());
        }
        catch (Exception ex) {
            return FutureUtil.completedWithException(ex);
        }
        return CompletableFuture.completedFuture(true);
    }

    private void writeTemplate(JsonElement element, ResourceKey key) throws IOException {
        Path dataPackFile = this.getDataPackFile(key);
        Files.createDirectories(dataPackFile.getParent(), new FileAttribute[0]);
        DataPackSerializer.writeFile(dataPackFile, element);
        DataPackSerializer.writePackMetadata("World", this.dimensionsDataPackDirectory.getParent());
    }

    @Override
    public CompletableFuture<Optional<ServerWorldProperties>> loadProperties(ResourceKey key) {
        WorldData levelData;
        net.minecraft.resources.ResourceKey<Level> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(key, "key"));
        if (this.worlds.get(registryKey) != null) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        if (!this.worldExists(key)) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        try (LevelStorageSource.LevelStorageAccess storageSource = this.createStorageSource(key);){
            PrimaryLevelData defaultLevelData = (PrimaryLevelData)this.server.getWorldData();
            LevelSettings defaultLevelSettings = ((PrimaryLevelDataAccessor)defaultLevelData).accessor$settings();
            levelData = storageSource.getDataTag(BootstrapProperties.worldSettingsAdapter, defaultLevelSettings.getDataPackConfig(), Lifecycle.stable());
        }
        catch (Exception ex) {
            return FutureUtil.completedWithException(ex);
        }
        if (levelData == null) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        return this.loadTemplate(key).thenCompose(template -> {
            if (template.isPresent()) {
                LevelStem scratch = ((SpongeWorldTemplate)template.get()).asLevelStem();
                ((PrimaryLevelDataBridge)levelData).bridge$populateFromDimension(scratch);
            } else {
                ((ResourceKeyBridge)levelData).bridge$setKey(key);
            }
            return CompletableFuture.completedFuture(Optional.of((ServerWorldProperties)levelData));
        });
    }

    @Override
    public CompletableFuture<Boolean> saveProperties(ServerWorldProperties properties) {
        net.minecraft.resources.ResourceKey<Level> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(properties, "properties").key());
        if (this.worlds.get(registryKey) != null) {
            return CompletableFuture.completedFuture(false);
        }
        ResourceKey key = properties.key();
        try (LevelStorageSource.LevelStorageAccess storageSource = this.createStorageSource(key);){
            storageSource.saveDataTag(BootstrapProperties.registries, (WorldData)properties, null);
        }
        catch (Exception ex) {
            return FutureUtil.completedWithException(ex);
        }
        return this.loadTemplate(key).thenCompose(r -> {
            WorldTemplate template = r.orElse(null);
            if (template != null) {
                LevelStem scratch = ((SpongeWorldTemplate)template).asLevelStem();
                ((LevelStemBridge)scratch).bridge$populateFromLevelData((PrimaryLevelData)properties);
                return this.saveTemplate(((LevelStemBridge)scratch).bridge$asTemplate());
            }
            return CompletableFuture.completedFuture(true);
        });
    }

    @Override
    public CompletableFuture<Boolean> copyWorld(ResourceKey key, ResourceKey copyKey) {
        JsonElement template;
        net.minecraft.resources.ResourceKey<Level> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(key, "key"));
        if (DefaultWorldKeys.DEFAULT.equals(copyKey)) {
            return CompletableFuture.completedFuture(false);
        }
        if (!this.worldExists(key)) {
            return CompletableFuture.completedFuture(false);
        }
        if (this.worldExists(copyKey)) {
            return CompletableFuture.completedFuture(false);
        }
        ServerLevel loadedWorld = this.worlds.get(registryKey);
        boolean disableLevelSaving = false;
        if (loadedWorld != null) {
            disableLevelSaving = loadedWorld.noSave;
            loadedWorld.save(null, true, loadedWorld.noSave);
            loadedWorld.noSave = true;
        }
        final boolean isDefaultWorld = DefaultWorldKeys.DEFAULT.equals(key);
        final Path originalDirectory = this.getDirectory(key);
        final Path copyDirectory = this.getDirectory(copyKey);
        try {
            Files.walkFileTree(originalDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (dir.getFileName().toString().equals("dimensions")) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    if (isDefaultWorld && SpongeWorldManager.this.isVanillaSubWorld(dir.getFileName().toString())) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    Path relativize = originalDirectory.relativize(dir);
                    Path directory = copyDirectory.resolve(relativize);
                    Files.createDirectories(directory, new FileAttribute[0]);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String fileName = file.getFileName().toString();
                    if (fileName.equals("level_sponge.dat_old")) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (fileName.equals(Constants.World.LEVEL_DAT_OLD)) {
                        return FileVisitResult.CONTINUE;
                    }
                    Files.copy(file, copyDirectory.resolve(originalDirectory.relativize(file)), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            try {
                Files.walkFileTree(copyDirectory, DeleteFileVisitor.INSTANCE);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return FutureUtil.completedWithException(e);
        }
        if (loadedWorld != null) {
            loadedWorld.noSave = disableLevelSaving;
        }
        Path configFile = this.getConfigFile(key);
        Path copiedConfigFile = this.getConfigFile(copyKey);
        try {
            Files.createDirectories(copiedConfigFile.getParent(), new FileAttribute[0]);
            Files.copy(configFile, copiedConfigFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            return FutureUtil.completedWithException(e);
        }
        if (this.isVanillaWorld(key)) {
            LevelStem stem = (LevelStem)this.server.getWorldData().worldGenSettings().dimensions().get(SpongeWorldManager.createStemKey(key));
            template = SpongeWorldManager.stemToJson(stem);
        } else {
            try (BufferedReader reader = Files.newBufferedReader(this.getDataPackFile(key));){
                template = JsonParser.parseReader(reader);
            }
            catch (IOException e) {
                return FutureUtil.completedWithException(e);
            }
        }
        JsonObject spongeData = template.getAsJsonObject().getAsJsonObject("#sponge");
        spongeData.remove("unique_id");
        try {
            this.writeTemplate(template, copyKey);
        }
        catch (IOException e) {
            return FutureUtil.completedWithException(e);
        }
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public CompletableFuture<Boolean> moveWorld(ResourceKey key, ResourceKey movedKey) {
        net.minecraft.resources.ResourceKey<Level> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(key, "key"));
        if (Level.OVERWORLD.equals(registryKey)) {
            return CompletableFuture.completedFuture(false);
        }
        if (!this.worldExists(key)) {
            return CompletableFuture.completedFuture(false);
        }
        if (this.worldExists(movedKey)) {
            return CompletableFuture.completedFuture(false);
        }
        ServerLevel loadedWorld = this.worlds.get(registryKey);
        if (loadedWorld != null) {
            try {
                this.unloadWorld0(loadedWorld);
            }
            catch (IOException e) {
                return FutureUtil.completedWithException(e);
            }
        }
        Path originalDirectory = this.getDirectory(key);
        Path movedDirectory = this.getDirectory(movedKey);
        try {
            Files.createDirectories(movedDirectory, new FileAttribute[0]);
            Files.move(originalDirectory, movedDirectory, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            return FutureUtil.completedWithException(e);
        }
        Path configFile = this.getConfigFile(key);
        Path movedConfigFile = this.getConfigFile(movedKey);
        try {
            Files.createDirectories(movedConfigFile.getParent(), new FileAttribute[0]);
            Files.move(configFile, movedConfigFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            return FutureUtil.completedWithException(e);
        }
        if (this.isVanillaWorld(key)) {
            LevelStem stem = (LevelStem)this.server.getWorldData().worldGenSettings().dimensions().get(SpongeWorldManager.createStemKey(key));
            JsonElement template = SpongeWorldManager.stemToJson(stem);
            try {
                this.writeTemplate(template, movedKey);
            }
            catch (IOException e) {
                return FutureUtil.completedWithException(e);
            }
        }
        Path dimensionTemplate = this.getDataPackFile(key);
        Path movedDimensionTemplate = this.getDataPackFile(movedKey);
        try {
            Files.createDirectories(movedDimensionTemplate.getParent(), new FileAttribute[0]);
            Files.move(dimensionTemplate, movedDimensionTemplate, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            return FutureUtil.completedWithException(e);
        }
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public CompletableFuture<Boolean> deleteWorld(ResourceKey key) {
        Path directory;
        net.minecraft.resources.ResourceKey<Level> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(key, "key"));
        if (Level.OVERWORLD.equals(registryKey)) {
            return CompletableFuture.completedFuture(false);
        }
        if (!this.worldExists(key)) {
            return CompletableFuture.completedFuture(false);
        }
        ServerLevel loadedWorld = this.worlds.get(registryKey);
        if (loadedWorld != null) {
            boolean disableLevelSaving = loadedWorld.noSave;
            loadedWorld.noSave = true;
            try {
                this.unloadWorld0(loadedWorld);
            }
            catch (IOException e) {
                loadedWorld.noSave = disableLevelSaving;
                return FutureUtil.completedWithException(e);
            }
        }
        if (Files.exists(directory = this.getDirectory(key), new LinkOption[0])) {
            try {
                Files.walkFileTree(directory, DeleteFileVisitor.INSTANCE);
            }
            catch (IOException e) {
                return FutureUtil.completedWithException(e);
            }
        }
        Path configFile = this.getConfigFile(key);
        try {
            Files.deleteIfExists(configFile);
        }
        catch (IOException e) {
            return FutureUtil.completedWithException(e);
        }
        Path dimensionTemplate = this.getDataPackFile(key);
        try {
            Files.deleteIfExists(dimensionTemplate);
        }
        catch (IOException e) {
            return FutureUtil.completedWithException(e);
        }
        return CompletableFuture.completedFuture(true);
    }

    private void unloadWorld0(ServerLevel world) throws IOException {
        net.minecraft.resources.ResourceKey registryKey = world.dimension();
        if (world.getPlayers(p -> true).size() != 0) {
            throw new IOException(String.format("World '%s' was told to unload but players remain.", registryKey.location()));
        }
        Optional<ResourceKey> worldTypeKey = RegistryTypes.WORLD_TYPE.get().findValueKey((WorldType)world.dimensionType());
        SpongeCommon.logger().info("Unloading world '{}' ({})", (Object)registryKey.location(), (Object)worldTypeKey.map(Object::toString).orElse("inline"));
        UnloadWorldEvent unloadWorldEvent = SpongeEventFactory.createUnloadWorldEvent(PhaseTracker.getCauseStackManager().currentCause(), (ServerWorld)world);
        SpongeCommon.post(unloadWorldEvent);
        BlockPos spawnPoint = world.getSharedSpawnPos();
        world.getChunkSource().removeRegionTicket(SPAWN_CHUNKS, new ChunkPos(spawnPoint), 11, (Object)registryKey.location());
        ((PrimaryLevelDataBridge)world.getLevelData()).bridge$configAdapter().save();
        try {
            world.save(null, true, world.noSave);
            world.close();
            ((ServerLevelBridge)world).bridge$getLevelSave().close();
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        this.worlds.remove(registryKey);
    }

    public void loadLevel() {
        boolean multiworldEnabled;
        PrimaryLevelData defaultLevelData = (PrimaryLevelData)this.server.getWorldData();
        WorldGenSettings defaultGenerationSettings = defaultLevelData.worldGenSettings();
        LevelSettings defaultLevelSettings = ((PrimaryLevelDataAccessor)defaultLevelData).accessor$settings();
        Registry templates = defaultGenerationSettings.dimensions();
        boolean bl = multiworldEnabled = this.server.isSingleplayer() || this.server.isNetherEnabled();
        if (!multiworldEnabled) {
            SpongeCommon.logger().warn("The option 'allow-nether' has been set to 'false' in the server.properties. Multi-World support has been disabled and no worlds besides the default world will be loaded.");
        }
        for (RegistryEntry registryEntry : ((org.spongepowered.api.registry.Registry)templates).streamEntries().collect(Collectors.toList())) {
            boolean isDebugGeneration;
            PrimaryLevelData levelData;
            LevelStorageSource.LevelStorageAccess storageSource;
            ResourceKey worldKey = registryEntry.key();
            LevelStem template = (LevelStem)registryEntry.value();
            LevelStemBridge templateBridge = (LevelStemBridge)template;
            ((ResourceKeyBridge)((Object)templateBridge)).bridge$setKey(worldKey);
            boolean isDefaultWorld = DefaultWorldKeys.DEFAULT.equals(worldKey);
            if (!isDefaultWorld && !multiworldEnabled) continue;
            Holder dimensionTypeHolder = template.typeHolder();
            WorldType worldType = (WorldType)dimensionTypeHolder.value();
            Optional<ResourceKey> worldTypeKey = RegistryTypes.WORLD_TYPE.get().findValueKey(worldType);
            MinecraftServerAccessor.accessor$LOGGER().info("Loading world '{}' ({})", (Object)worldKey, (Object)worldTypeKey.map(Object::toString).orElse("inline"));
            if (!isDefaultWorld && !templateBridge.bridge$loadOnStartup()) {
                SpongeCommon.logger().warn("World '{}' has been disabled from loading at startup. Skipping...", (Object)worldKey);
                continue;
            }
            String directoryName = this.getDirectoryName(worldKey);
            if (isDefaultWorld) {
                storageSource = ((MinecraftServerAccessor)this.server).accessor$storageSource();
            } else {
                try {
                    storageSource = this.createStorageSource(worldKey);
                }
                catch (IOException e) {
                    throw new RuntimeException(String.format("Failed to create level data for world '%s'!", worldKey), e);
                }
            }
            if (isDefaultWorld) {
                levelData = defaultLevelData;
                isDebugGeneration = defaultGenerationSettings.isDebug();
            } else {
                levelData = (PrimaryLevelData)storageSource.getDataTag(BootstrapProperties.worldSettingsAdapter, defaultLevelSettings.getDataPackConfig(), Lifecycle.stable());
                if (levelData == null) {
                    WorldGenSettings generationSettings;
                    LevelSettings levelSettings;
                    if (this.server.isDemo()) {
                        levelSettings = MinecraftServer.DEMO_SETTINGS;
                        generationSettings = WorldGenSettings.demoSettings((RegistryAccess)BootstrapProperties.registries);
                    } else {
                        levelSettings = new LevelSettings(directoryName, (GameType)BootstrapProperties.gameMode.get(Sponge.game()), templateBridge.bridge$hardcore().orElse(BootstrapProperties.hardcore).booleanValue(), (Difficulty)BootstrapProperties.difficulty.get(Sponge.game()), templateBridge.bridge$commands().orElse(BootstrapProperties.commands).booleanValue(), new GameRules(), defaultLevelData.getDataPackConfig());
                        generationSettings = ((WorldGenSettingsBridge)defaultLevelData.worldGenSettings()).bridge$copy();
                    }
                    isDebugGeneration = generationSettings.isDebug();
                    ((DimensionGeneratorSettingsAccessor)generationSettings).accessor$dimensions((Registry<LevelStem>)new MappedRegistry(Registry.LEVEL_STEM_REGISTRY, Lifecycle.stable(), null));
                    levelData = new PrimaryLevelData(levelSettings, generationSettings, Lifecycle.stable());
                } else {
                    isDebugGeneration = levelData.worldGenSettings().isDebug();
                }
            }
            ((PrimaryLevelDataBridge)levelData).bridge$populateFromDimension(template);
            InheritableConfigHandle<WorldConfig> configAdapter = SpongeGameConfigs.createWorld(worldTypeKey.orElse(null), worldKey);
            ((PrimaryLevelDataBridge)levelData).bridge$configAdapter(configAdapter);
            levelData.setModdedInfo(this.server.getServerModName(), this.server.getModdedStatus().shouldReportAsModified());
            long seed = BiomeManager.obfuscateSeed((long)levelData.worldGenSettings().seed());
            net.minecraft.resources.ResourceKey<Level> registryKey = SpongeWorldManager.createRegistryKey(worldKey);
            ChunkProgressListener chunkStatusListener = ((MinecraftServerAccessor)this.server).accessor$progressListenerFactory().create(11);
            ImmutableList spawners = isDefaultWorld ? ImmutableList.of((Object)new PhantomSpawner(), (Object)new PatrolSpawner(), (Object)new CatSpawner(), (Object)new VillageSiege(), (Object)new WanderingTraderSpawner((ServerLevelData)levelData)) : ImmutableList.of();
            ServerLevel world = new ServerLevel(this.server, ((MinecraftServerAccessor)this.server).accessor$executor(), storageSource, (ServerLevelData)levelData, registryKey, dimensionTypeHolder, chunkStatusListener, template.generator(), isDebugGeneration, seed, (List)spawners, true);
            world.getWorldBorder().applySettings(levelData.getWorldBorder());
            this.worlds.put(registryKey, world);
            this.prepareWorld(world, isDebugGeneration);
        }
        ((MinecraftServerAccessor)this.server).invoker$forceDifficulty();
        for (Map.Entry entry : this.worlds.entrySet()) {
            try {
                this.postWorldLoad((ServerLevel)entry.getValue(), true).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IllegalStateException(e);
            }
        }
        ((SpongeUserManager)Sponge.server().userManager()).init();
        ((SpongeServer)SpongeCommon.server()).getPlayerDataManager().load();
    }

    private void prepareWorld(ServerLevel world, boolean isDebugGeneration) {
        boolean isDefaultWorld = Level.OVERWORLD.equals(world.dimension());
        PrimaryLevelData levelData = (PrimaryLevelData)world.getLevelData();
        if (isDefaultWorld) {
            ((MinecraftServerAccessor)this.server).accessor$readScoreboard(world.getDataStorage());
            ((MinecraftServerAccessor)this.server).accessor$commandStorage(new CommandStorage(world.getDataStorage()));
        }
        boolean isInitialized = levelData.isInitialized();
        LoadWorldEvent loadWorldEvent = SpongeEventFactory.createLoadWorldEvent(PhaseTracker.getCauseStackManager().currentCause(), (ServerWorld)world, isInitialized);
        SpongeCommon.post(loadWorldEvent);
        PlatformHooks.INSTANCE.getWorldHooks().postLoadWorld(world);
        ((PrimaryLevelDataBridge)world.getLevelData()).bridge$viewDistance().ifPresent(v -> ((PrimaryLevelDataBridge)world.getLevelData()).bridge$setViewDistance((Integer)v));
        world.getWorldBorder().applySettings(levelData.getWorldBorder());
        if (!isInitialized) {
            try {
                boolean hasSpawnAlready = ((PrimaryLevelDataBridge)world.getLevelData()).bridge$customSpawnPosition();
                if (!hasSpawnAlready) {
                    if (isDefaultWorld || ((ServerWorldProperties)world.getLevelData()).performsSpawnLogic()) {
                        MinecraftServerAccessor.invoker$setInitialSpawn(world, (ServerLevelData)levelData, levelData.worldGenSettings().generateBonusChest(), !isDebugGeneration);
                    } else if (Level.END.equals(world.dimension())) {
                        ((PrimaryLevelData)world.getLevelData()).setSpawn(ServerLevel.END_SPAWN_POINT, 0.0f);
                    }
                } else if (levelData.worldGenSettings().generateBonusChest()) {
                    ((ConfiguredFeature)MiscOverworldFeatures.BONUS_CHEST.value()).place((WorldGenLevel)world, world.getChunkSource().getGenerator(), world.random, new BlockPos(levelData.getXSpawn(), levelData.getYSpawn(), levelData.getZSpawn()));
                }
                levelData.setInitialized(true);
                if (isDebugGeneration) {
                    ((MinecraftServerAccessor)this.server).invoker$setupDebugLevel((WorldData)levelData);
                }
            }
            catch (Throwable throwable) {
                CrashReport crashReport = CrashReport.forThrowable((Throwable)throwable, (String)("Exception initializing world '" + world.dimension().location() + "'"));
                try {
                    world.fillReportDetails(crashReport);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw new ReportedException(crashReport);
            }
            levelData.setInitialized(true);
        }
        this.server.getPlayerList().addWorldborderListener(world);
        if (levelData.getCustomBossEvents() != null) {
            ((ServerLevelBridge)world).bridge$getBossBarManager().load(levelData.getCustomBossEvents());
        }
    }

    private CompletableFuture<ServerLevel> postWorldLoad(ServerLevel world, boolean blocking) {
        PrimaryLevelData levelData = (PrimaryLevelData)world.getLevelData();
        PrimaryLevelDataBridge levelBridge = (PrimaryLevelDataBridge)levelData;
        if (Level.OVERWORLD.equals(world.dimension()) || levelBridge.bridge$performsSpawnLogic()) {
            Optional<ResourceKey> worldTypeKey = RegistryTypes.WORLD_TYPE.get().findValueKey((WorldType)world.dimensionType());
            MinecraftServerAccessor.accessor$LOGGER().info("Preparing start region for world '{}' ({})", (Object)world.dimension().location(), (Object)worldTypeKey.map(Object::toString).orElse("inline"));
            if (blocking) {
                this.loadSpawnChunks(world);
                return CompletableFuture.completedFuture(world);
            }
            return this.loadSpawnChunksAsync(world);
        }
        return CompletableFuture.completedFuture(world);
    }

    private CompletableFuture<ServerLevel> loadSpawnChunksAsync(ServerLevel world) {
        BlockPos spawnPoint = world.getSharedSpawnPos();
        ChunkPos chunkPos = new ChunkPos(spawnPoint);
        ServerChunkCache serverChunkProvider = world.getChunkSource();
        serverChunkProvider.getLightEngine().setTaskPerBatch(500);
        int borderRadius = 11;
        int diameter = 21;
        int spawnChunks = 441;
        serverChunkProvider.addRegionTicket(SPAWN_CHUNKS, chunkPos, 11, (Object)world.dimension().location());
        CompletableFuture generationFuture = new CompletableFuture();
        Sponge.asyncScheduler().submit(Task.builder().plugin(((Launch)Launch.instance()).platformPlugin()).execute(task -> {
            if (serverChunkProvider.getTickingGenerated() >= 441) {
                Sponge.server().scheduler().submit(Task.builder().plugin(((Launch)Launch.instance()).platformPlugin()).execute(() -> generationFuture.complete(world)).build());
                task.cancel();
                Optional<ResourceKey> worldTypeKey = RegistryTypes.WORLD_TYPE.get().findValueKey((WorldType)world.dimensionType());
                MinecraftServerAccessor.accessor$LOGGER().info("Done preparing start region for world '{}' ({})", (Object)world.dimension().location(), (Object)worldTypeKey.map(Object::toString).orElse("inline"));
            }
        }).interval(10L, TimeUnit.MILLISECONDS).build());
        return generationFuture.thenApply(v -> {
            this.updateForcedChunks(world, serverChunkProvider);
            serverChunkProvider.getLightEngine().setTaskPerBatch(5);
            if (!((PrimaryLevelDataBridge)world.getLevelData()).bridge$performsSpawnLogic()) {
                serverChunkProvider.removeRegionTicket(SPAWN_CHUNKS, chunkPos, 11, (Object)world.dimension().location());
            }
            return world;
        });
    }

    private void loadSpawnChunks(ServerLevel world) {
        BlockPos spawnPoint = world.getSharedSpawnPos();
        ChunkPos chunkPos = new ChunkPos(spawnPoint);
        ChunkProgressListener chunkStatusListener = ((ServerLevelBridge)world).bridge$getChunkStatusListener();
        chunkStatusListener.updateSpawnPos(chunkPos);
        ServerChunkCache serverChunkProvider = world.getChunkSource();
        serverChunkProvider.getLightEngine().setTaskPerBatch(500);
        ((MinecraftServerAccessor)this.server).accessor$nextTickTime(Util.getMillis());
        serverChunkProvider.addRegionTicket(SPAWN_CHUNKS, chunkPos, 11, (Object)world.dimension().location());
        while (serverChunkProvider.getTickingGenerated() != 441) {
            ((MinecraftServerAccessor)this.server).accessor$nextTickTime(Util.getMillis() + 10L);
            ((MinecraftServerAccessor)this.server).accessor$waitUntilNextTick();
        }
        ((MinecraftServerAccessor)this.server).accessor$nextTickTime(Util.getMillis() + 10L);
        ((MinecraftServerAccessor)this.server).accessor$waitUntilNextTick();
        this.updateForcedChunks(world, serverChunkProvider);
        ((MinecraftServerAccessor)this.server).accessor$nextTickTime(Util.getMillis() + 10L);
        ((MinecraftServerAccessor)this.server).accessor$waitUntilNextTick();
        chunkStatusListener.stop();
        serverChunkProvider.getLightEngine().setTaskPerBatch(5);
        if (!((PrimaryLevelDataBridge)world.getLevelData()).bridge$performsSpawnLogic()) {
            serverChunkProvider.removeRegionTicket(SPAWN_CHUNKS, chunkPos, 11, (Object)world.dimension().location());
        }
    }

    private void updateForcedChunks(ServerLevel world, ServerChunkCache serverChunkProvider) {
        ForcedChunksSavedData forcedChunksSaveData = (ForcedChunksSavedData)world.getDataStorage().get(ForcedChunksSavedData::load, "chunks");
        if (forcedChunksSaveData != null) {
            LongIterator longIterator = forcedChunksSaveData.getChunks().iterator();
            while (longIterator.hasNext()) {
                long i = longIterator.nextLong();
                ChunkPos forceChunkPos = new ChunkPos(i);
                serverChunkProvider.updateChunkForced(forceChunkPos, true);
            }
        }
    }

    public static net.minecraft.resources.ResourceKey<Level> createRegistryKey(ResourceKey key) {
        return net.minecraft.resources.ResourceKey.create((net.minecraft.resources.ResourceKey)Registry.DIMENSION_REGISTRY, (ResourceLocation)((ResourceLocation)key));
    }

    public static net.minecraft.resources.ResourceKey<LevelStem> createStemKey(ResourceKey key) {
        return net.minecraft.resources.ResourceKey.create((net.minecraft.resources.ResourceKey)Registry.LEVEL_STEM_REGISTRY, (ResourceLocation)((ResourceLocation)key));
    }

    private static LevelStem stemFromJson(ResourceKey key, JsonElement element) throws IOException {
        LevelStem stem = (LevelStem)LevelStem.CODEC.parse(new Dynamic((DynamicOps)RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)BootstrapProperties.registries), (Object)element)).getOrThrow(true, s -> {});
        ((LevelStemBridge)stem).bridge$setFromSettings(false);
        ((ResourceKeyBridge)stem).bridge$setKey(key);
        return stem;
    }

    private static JsonElement stemToJson(LevelStem stem) {
        return (JsonElement)LevelStem.CODEC.encodeStart((DynamicOps)RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)BootstrapProperties.registries), (Object)stem).getOrThrow(true, s -> {});
    }

    private LevelStorageSource.LevelStorageAccess createStorageSource(ResourceKey key) throws IOException {
        if (DefaultWorldKeys.DEFAULT.equals(key)) {
            LevelStorageSource.createDefault((Path)this.defaultWorldDirectory.getParent()).createAccess(this.defaultWorldDirectory.getFileName().toString());
        }
        if (DefaultWorldKeys.THE_NETHER.equals(key)) {
            return LevelStorageSource.createDefault((Path)this.defaultWorldDirectory).createAccess("DIM-1");
        }
        if (DefaultWorldKeys.THE_END.equals(key)) {
            return LevelStorageSource.createDefault((Path)this.defaultWorldDirectory).createAccess("DIM1");
        }
        return LevelStorageSource.createDefault((Path)this.customWorldsDirectory).createAccess(key.namespace() + File.separator + key.value());
    }

    private String getDirectoryName(ResourceKey key) {
        if (DefaultWorldKeys.DEFAULT.equals(key)) {
            return "";
        }
        if (DefaultWorldKeys.THE_NETHER.equals(key)) {
            return "DIM-1";
        }
        if (DefaultWorldKeys.THE_END.equals(key)) {
            return "DIM1";
        }
        return key.value();
    }

    private Path getDirectory(ResourceKey key) {
        if (DefaultWorldKeys.DEFAULT.equals(key)) {
            return this.defaultWorldDirectory;
        }
        if (DefaultWorldKeys.THE_NETHER.equals(key)) {
            return this.defaultWorldDirectory.resolve("DIM-1");
        }
        if (DefaultWorldKeys.THE_END.equals(key)) {
            return this.defaultWorldDirectory.resolve("DIM1");
        }
        return this.customWorldsDirectory.resolve(key.namespace()).resolve(key.value());
    }

    private boolean isVanillaWorld(ResourceKey key) {
        return DefaultWorldKeys.DEFAULT.equals(key) || DefaultWorldKeys.THE_NETHER.equals(key) || DefaultWorldKeys.THE_END.equals(key);
    }

    private boolean isVanillaSubWorld(String directoryName) {
        return "DIM-1".equals(directoryName) || "DIM1".equals(directoryName);
    }

    private Path getDataPackFile(ResourceKey key) {
        return this.getDimensionDataPackDirectory().resolve(key.namespace()).resolve("dimension").resolve(key.value() + ".json");
    }

    private Path getConfigFile(ResourceKey key) {
        return SpongeCommon.spongeConfigDirectory().resolve(((Launch)Launch.instance()).id()).resolve("worlds").resolve(key.namespace()).resolve(key.value() + ".conf");
    }
}

