/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.configurate.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationVisitor;

final class JacksonVisitor
implements ConfigurationVisitor<JsonGenerator, Void, ConfigurateException> {
    static final ThreadLocal<JacksonVisitor> INSTANCE = ThreadLocal.withInitial(JacksonVisitor::new);
    private @Nullable ConfigurationNode start;

    private JacksonVisitor() {
    }

    @Override
    public JsonGenerator newState() {
        throw new UnsupportedOperationException("Generator must be provided");
    }

    @Override
    public void beginVisit(ConfigurationNode node, JsonGenerator state) {
        this.start = node;
    }

    @Override
    public void enterNode(ConfigurationNode node, JsonGenerator generator) throws ConfigurateException {
        @Nullable ConfigurationNode parent = node.parent();
        if (node != this.start && parent != null && parent.isMap()) {
            @Nullable Object key = node.key();
            if (key == null) {
                throw new ConfigurateException(node, "Node must have key to be a value in a mapping");
            }
            try {
                generator.writeFieldName(key.toString());
            }
            catch (IOException ex) {
                throw new ConfigurateException(node, (Throwable)ex);
            }
        }
    }

    @Override
    public void enterMappingNode(ConfigurationNode node, JsonGenerator state) throws ConfigurateException {
        try {
            state.writeStartObject();
        }
        catch (IOException ex) {
            throw new ConfigurateException(node, (Throwable)ex);
        }
    }

    @Override
    public void enterListNode(ConfigurationNode node, JsonGenerator state) throws ConfigurateException {
        try {
            state.writeStartArray();
        }
        catch (IOException ex) {
            throw new ConfigurateException(node, (Throwable)ex);
        }
    }

    @Override
    public void enterScalarNode(ConfigurationNode node, JsonGenerator generator) throws ConfigurateException {
        @Nullable Object value = node.rawScalar();
        try {
            if (value instanceof Double) {
                generator.writeNumber((Double)value);
            } else if (value instanceof Float) {
                generator.writeNumber(((Float)value).floatValue());
            } else if (value instanceof Long) {
                generator.writeNumber((Long)value);
            } else if (value instanceof Integer) {
                generator.writeNumber((Integer)value);
            } else if (value instanceof Boolean) {
                generator.writeBoolean((Boolean)value);
            } else if (value instanceof byte[]) {
                generator.writeBinary((byte[])value);
            } else if (value == null) {
                generator.writeNull();
            } else {
                generator.writeString(value.toString());
            }
        }
        catch (IOException ex) {
            throw new ConfigurateException(node, (Throwable)ex);
        }
    }

    @Override
    public void exitMappingNode(ConfigurationNode node, JsonGenerator state) throws ConfigurateException {
        try {
            state.writeEndObject();
        }
        catch (IOException ex) {
            throw new ConfigurateException(node, (Throwable)ex);
        }
    }

    @Override
    public void exitListNode(ConfigurationNode node, JsonGenerator state) throws ConfigurateException {
        try {
            state.writeEndArray();
        }
        catch (IOException ex) {
            throw new ConfigurateException(node, (Throwable)ex);
        }
    }

    @Override
    public Void endVisit(JsonGenerator state) throws ConfigurateException {
        @Nullable ConfigurationNode start = this.start;
        this.start = null;
        try {
            state.flush();
        }
        catch (IOException ex) {
            throw new ConfigurateException(start, (Throwable)ex);
        }
        return null;
    }
}

