/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.server.packs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.ResourcePackFileNotFoundException;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.plugin.PluginContainer;

public final class PluginPackResources
extends AbstractPackResources {
    private final String name;
    private final PluginContainer container;
    private final PackMetadataSection metadata;
    private final @Nullable Supplier<FileSystem> fileSystem;

    public PluginPackResources(String name, PluginContainer container, @Nullable Supplier<FileSystem> fileSystem) {
        super(new File("sponge_plugin_pack"));
        this.name = name;
        this.container = container;
        this.metadata = new PackMetadataSection((Component)new TextComponent("Plugin Resources"), 6);
        this.fileSystem = fileSystem;
    }

    public String getName() {
        return this.name;
    }

    protected InputStream getResource(String rawPath) throws IOException {
        return (InputStream)this.container.openResource(URI.create(rawPath)).orElseThrow(() -> new ResourcePackFileNotFoundException(this.file, rawPath));
    }

    protected boolean hasResource(String rawPath) {
        try {
            return this.container.locateResource(URI.create(rawPath)).isPresent();
        }
        catch (Exception e) {
            return false;
        }
    }

    public Collection<ResourceLocation> getResources(PackType type, String namespace, String path, int depth, Predicate<String> fileNameValidator) {
        try {
            Path root = this.typeRoot(type);
            Path namespaceDir = root.resolve(namespace).toAbsolutePath();
            return Files.walk(namespaceDir, depth, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(s -> !s.getFileName().toString().endsWith(".mcmeta")).map(namespaceDir::relativize).map(Object::toString).filter(fileNameValidator).map(s -> new ResourceLocation(namespace, s)).collect(Collectors.toList());
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    public <T> @Nullable T getMetadataSection(MetadataSectionSerializer<T> deserializer) throws IOException {
        if (deserializer.getMetadataSectionName().equals("pack")) {
            return (T)this.metadata;
        }
        return null;
    }

    public Set<String> getNamespaces(PackType type) {
        try {
            @Nullable Path root = this.typeRoot(type);
            if (root != null) {
                return Files.list(root).map(Path::getFileName).map(Object::toString).filter(s -> {
                    if (s.equals(s.toLowerCase(Locale.ROOT))) {
                        return true;
                    }
                    SpongeCommon.logger().warn("Pack: ignored non-lowercased namespace: {} in {}", s, (Object)root.toAbsolutePath().toString());
                    return false;
                }).collect(Collectors.toSet());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Collections.emptySet();
    }

    public void close() {
    }

    private @Nullable Path typeRoot(PackType type) throws IOException {
        if (this.fileSystem == null) {
            return null;
        }
        return this.fileSystem.get().getPath(type.getDirectory(), new String[0]);
    }
}

