/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.network.channel.packet;

import java.util.concurrent.CompletableFuture;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.network.EngineConnection;
import org.spongepowered.api.network.channel.packet.Packet;
import org.spongepowered.api.world.server.ServerWorld;

public interface PacketDispatcher {
    public boolean isSupportedBy(EngineConnection var1);

    default public void sendToAllPlayers(Packet packet) {
        Sponge.server().onlinePlayers().forEach(player -> this.sendTo((ServerPlayer)player, packet));
    }

    default public void sendToAllPlayersIn(ServerWorld world, Packet packet) {
        world.players().forEach(player -> this.sendTo((ServerPlayer)player, packet));
    }

    default public CompletableFuture<Void> sendTo(ServerPlayer player, Packet packet) {
        return this.sendTo(player.connection(), packet);
    }

    default public CompletableFuture<Void> sendToServer(Packet packet) {
        EngineConnection connection = Sponge.client().connection().orElseThrow(() -> new IllegalStateException("The client is currently not connected to a server."));
        return this.sendTo(connection, packet);
    }

    public CompletableFuture<Void> sendTo(EngineConnection var1, Packet var2);
}

