/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.util.weighted;

import java.util.Objects;
import java.util.StringJoiner;
import org.spongepowered.api.util.weighted.TableEntry;

public class WeightedObject<T>
extends TableEntry<T> {
    private final T object;

    public WeightedObject(T obj, double weight) {
        super(weight);
        this.object = Objects.requireNonNull(obj);
    }

    public T get() {
        return this.object;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WeightedObject)) {
            return false;
        }
        WeightedObject c = (WeightedObject)o;
        return this.object.equals(c.object) && this.weight() == c.weight();
    }

    public int hashCode() {
        int r = 1;
        long w = Double.doubleToLongBits(this.weight());
        r = r * 37 + (int)(w ^ w >>> 32);
        r = r * 37 + this.object.hashCode();
        return r;
    }

    public String toString() {
        return new StringJoiner(", ", WeightedObject.class.getSimpleName() + "[", "]").add("object=" + this.object).toString();
    }
}

