/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.server;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Server;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.raid.Raid;
import org.spongepowered.api.util.Identifiable;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.chunk.WorldChunk;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.api.world.generation.ChunkGenerator;
import org.spongepowered.api.world.server.ChunkManager;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerLocationCreator;
import org.spongepowered.api.world.server.storage.ServerWorldProperties;
import org.spongepowered.api.world.volume.game.InteractableVolume;
import org.spongepowered.api.world.weather.WeatherUniverse;
import org.spongepowered.math.vector.Vector3i;

public interface ServerWorld
extends World<ServerWorld, ServerLocation>,
Identifiable,
InteractableVolume,
ServerLocationCreator,
WeatherUniverse.Mutable {
    @Override
    public Server engine();

    @Override
    public ServerWorldProperties properties();

    public ChunkGenerator generator();

    public ResourceKey key();

    @Override
    default public UUID uniqueId() {
        return this.properties().uniqueId();
    }

    @Override
    default public WorldChunk chunkAtBlock(Vector3i blockPosition) {
        return this.chunkAtBlock(blockPosition.x(), blockPosition.y(), blockPosition.z());
    }

    @Override
    default public WorldChunk chunkAtBlock(int bx, int by, int bz) {
        Vector3i chunkPos = this.engine().chunkLayout().forceToChunk(bx, by, bz);
        return this.chunk(chunkPos.x(), chunkPos.y(), chunkPos.z());
    }

    default public BlockSnapshot createSnapshot(Vector3i position) {
        Objects.requireNonNull(position, "position");
        return this.createSnapshot(position.x(), position.y(), position.z());
    }

    public BlockSnapshot createSnapshot(int var1, int var2, int var3);

    public boolean restoreSnapshot(BlockSnapshot var1, boolean var2, BlockChangeFlag var3);

    default public boolean restoreSnapshot(Vector3i position, BlockSnapshot snapshot, boolean force, BlockChangeFlag flag) {
        Objects.requireNonNull(position, "position");
        return this.restoreSnapshot(position.x(), position.y(), position.z(), Objects.requireNonNull(snapshot, "snapshot"), force, Objects.requireNonNull(flag, "flag"));
    }

    public boolean restoreSnapshot(int var1, int var2, int var3, BlockSnapshot var4, boolean var5, BlockChangeFlag var6);

    public Path directory();

    public boolean save() throws IOException;

    public boolean unloadChunk(WorldChunk var1);

    public void triggerExplosion(Explosion var1);

    @Override
    public Collection<ServerPlayer> players();

    public Collection<Raid> raids();

    public Optional<Raid> raidAt(Vector3i var1);

    public ChunkManager chunkManager();
}

