/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.block.entity;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.entity.BlockEntityArchetype;
import org.spongepowered.api.block.entity.BlockEntityType;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.block.entity.SpongeBlockEntityArchetypeBuilder;
import org.spongepowered.common.data.AbstractArchetype;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.data.nbt.validation.RawDataValidator;
import org.spongepowered.common.data.nbt.validation.ValidationType;
import org.spongepowered.common.data.nbt.validation.ValidationTypes;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.data.provider.DataProviderLookup;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.VecHelper;

public final class SpongeBlockEntityArchetype
extends AbstractArchetype<BlockEntityType, BlockSnapshot, org.spongepowered.api.block.entity.BlockEntity>
implements BlockEntityArchetype {
    final BlockState blockState;
    public static final ImmutableList<RawDataValidator> VALIDATORS = ImmutableList.of();
    private static final DataProviderLookup lookup = SpongeDataManager.getProviderRegistry().getProviderLookup(SpongeBlockEntityArchetype.class);

    SpongeBlockEntityArchetype(SpongeBlockEntityArchetypeBuilder builder) {
        super(builder.type, NBTTranslator.INSTANCE.translate(builder.data));
        this.blockState = builder.blockState;
    }

    @Override
    public BlockState state() {
        return this.blockState;
    }

    @Override
    public BlockEntityType blockEntityType() {
        return (BlockEntityType)this.type;
    }

    @Override
    public DataContainer blockEntityData() {
        return NBTTranslator.INSTANCE.translateFrom(this.compound);
    }

    @Override
    public Optional<org.spongepowered.api.block.entity.BlockEntity> apply(ServerLocation location) {
        BlockState currentState = location.block();
        Block currentBlock = ((net.minecraft.world.level.block.state.BlockState)currentState).getBlock();
        Block newBlock = ((net.minecraft.world.level.block.state.BlockState)this.blockState).getBlock();
        Level minecraftWorld = (Level)location.world();
        BlockPos blockpos = VecHelper.toBlockPos(location);
        if (currentBlock != newBlock) {
            ((World)minecraftWorld).setBlock(blockpos.getX(), blockpos.getY(), blockpos.getZ(), this.blockState, BlockChangeFlags.ALL);
        }
        CompoundTag compound = this.compound.copy();
        @Nullable BlockEntity tileEntity = minecraftWorld.getBlockEntity(blockpos);
        if (tileEntity == null) {
            return Optional.empty();
        }
        compound.putInt("x", blockpos.getX());
        compound.putInt("y", blockpos.getY());
        compound.putInt("z", blockpos.getZ());
        tileEntity.setBlockState((net.minecraft.world.level.block.state.BlockState)currentState);
        tileEntity.load(compound);
        return Optional.of((org.spongepowered.api.block.entity.BlockEntity)tileEntity);
    }

    @Override
    public BlockSnapshot toSnapshot(ServerLocation location) {
        SpongeBlockSnapshot.BuilderImpl builder = SpongeBlockSnapshot.BuilderImpl.pooled();
        return builder.blockState(this.blockState).addUnsafeCompound(this.compound.copy()).world(location.worldKey()).position(location.blockPosition()).build();
    }

    @Override
    public int contentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        return DataContainer.createNew(DataView.SafetyMode.NO_DATA_CLONED).set(Queries.CONTENT_VERSION, this.contentVersion()).set(Constants.Sponge.BlockEntityArchetype.BLOCK_ENTITY_TYPE, this.type).set(Constants.Sponge.BlockEntityArchetype.BLOCK_STATE, this.blockState).set(Constants.Sponge.BlockEntityArchetype.BLOCK_ENTITY_DATA, this.blockEntityData());
    }

    @Override
    public DataProviderLookup getLookup() {
        return lookup;
    }

    @Override
    protected ValidationType getValidationType() {
        return ValidationTypes.BLOCK_ENTITY.get();
    }

    @Override
    public SpongeBlockEntityArchetype copy() {
        SpongeBlockEntityArchetypeBuilder builder = SpongeBlockEntityArchetypeBuilder.pooled();
        builder.type = (BlockEntityType)this.type;
        builder.data = NBTTranslator.INSTANCE.translate(this.compound);
        builder.blockState = this.blockState;
        return builder.build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeBlockEntityArchetype that = (SpongeBlockEntityArchetype)o;
        return this.blockState.equals(that.blockState);
    }

    @Override
    protected ImmutableList<RawDataValidator> getValidators() {
        return VALIDATORS;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.blockState);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", this.type).add("state", (Object)this.blockState).add("data", (Object)this.compound).toString();
    }
}

