/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.parameter.managed.standard;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.CommandCompletion;
import org.spongepowered.api.command.exception.ArgumentParseException;
import org.spongepowered.common.command.SpongeCommandCompletion;
import org.spongepowered.common.command.brigadier.argument.ResourceKeyedArgumentValueParser;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.plugin.PluginContainer;

public final class SpongePluginContainerValueParameter
extends ResourceKeyedArgumentValueParser<PluginContainer> {
    public SpongePluginContainerValueParameter(ResourceKey key) {
        super(key);
    }

    @Override
    public List<CommandCompletion> complete(@NonNull CommandCause context, String currentInput) {
        return ((Launch)Launch.instance()).pluginManager().plugins().stream().filter(x -> x.metadata().id().startsWith(currentInput)).map(entry -> {
            TextComponent tooltip = Component.text((String)entry.metadata().name().orElse(entry.metadata().id()));
            return new SpongeCommandCompletion(entry.metadata().id(), (Component)tooltip);
        }).collect(Collectors.toList());
    }

    @Override
    public @NonNull Optional<? extends PluginContainer> parseValue(@NonNull CommandCause cause,  @NonNull ArgumentReader.Mutable reader) throws ArgumentParseException {
        String id = reader.parseString();
        Optional<PluginContainer> container = ((Launch)Launch.instance()).pluginManager().plugin(id);
        if (container.isPresent()) {
            return container;
        }
        throw reader.createException((Component)Component.text((String)("Could not find plugin with ID \"" + id + "\"")));
    }
}

