/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.parameter.managed.standard;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.world.phys.Vec3;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.CommandCompletion;
import org.spongepowered.api.command.exception.ArgumentParseException;
import org.spongepowered.api.command.parameter.ArgumentReader;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.command.SpongeCommandCompletion;
import org.spongepowered.common.command.brigadier.argument.ComplexSuggestionNodeProvider;
import org.spongepowered.common.command.brigadier.argument.ResourceKeyedArgumentValueParser;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.VecHelper;

public final class SpongeServerLocationValueParameter
extends ResourceKeyedArgumentValueParser<ServerLocation>
implements ComplexSuggestionNodeProvider {
    private static final Vec3Argument VEC_3_ARGUMENT = Vec3Argument.vec3((boolean)false);
    private static final Pattern STARTS_WITH_NUMBER = Pattern.compile("^\\s*((-)?[0-9]|~|\\^)");

    public SpongeServerLocationValueParameter(ResourceKey key) {
        super(key);
    }

    @Override
    public List<CommandCompletion> complete(@NonNull CommandCause cause, @NonNull String currentInput) {
        return this.complete(currentInput).map(SpongeCommandCompletion::new).collect(Collectors.toList());
    }

    private Stream<String> complete(String currentInput) {
        return SpongeCommon.game().server().worldManager().worlds().stream().map(ServerWorld::key).map(ResourceKey::formatted).filter(x -> x.startsWith(currentInput));
    }

    @Override
    public @NonNull Optional<? extends ServerLocation> parseValue(@NonNull CommandCause cause,  @NonNull ArgumentReader.Mutable reader) throws ArgumentParseException {
        ServerWorld serverWorld;
        ArgumentReader.Immutable state = reader.immutable();
        try {
            ResourceKey resourceLocation = reader.parseResourceKey("minecraft");
            serverWorld = SpongeCommon.game().server().worldManager().world(resourceLocation).orElseThrow(() -> reader.createException((Component)Component.text((String)("Could not get world with key \"" + resourceLocation.toString() + "\""))));
        }
        catch (ArgumentParseException e) {
            Optional<ServerLocation> location = cause.location();
            if (location.isPresent()) {
                if (!STARTS_WITH_NUMBER.matcher(state.remaining()).find()) {
                    throw e;
                }
            } else {
                throw e;
            }
            serverWorld = (ServerWorld)location.get().world();
            reader.setState(state);
        }
        try {
            reader.skipWhitespace();
            Vec3 vec3d = VEC_3_ARGUMENT.parse((StringReader)reader).getPosition((CommandSourceStack)cause);
            return Optional.of((ServerLocation)serverWorld.location(VecHelper.toVector3d(vec3d)));
        }
        catch (CommandSyntaxException e) {
            throw reader.createException((Component)Component.text((String)e.getMessage()));
        }
    }

    @Override
    public List<ArgumentType<?>> getClientCompletionArgumentType() {
        return ImmutableList.of((Object)Constants.Command.RESOURCE_LOCATION_TYPE, (Object)Vec3Argument.vec3());
    }

    @Override
    public CommandNode<SharedSuggestionProvider> createSuggestions(CommandNode<SharedSuggestionProvider> rootNode, String key, boolean isTerminal, Consumer<List<CommandNode<SharedSuggestionProvider>>> firstNodes, Consumer<CommandNode<SharedSuggestionProvider>> redirectionNodes, boolean allowCustomSuggestionsOnTheFirstElement) {
        RequiredArgumentBuilder firstNode = RequiredArgumentBuilder.argument((String)key, (ArgumentType)Constants.Command.RESOURCE_LOCATION_TYPE);
        if (allowCustomSuggestionsOnTheFirstElement) {
            firstNode.suggests((context, builder) -> {
                this.complete("").forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
                return builder.buildFuture();
            });
        }
        RequiredArgumentBuilder secondNode = RequiredArgumentBuilder.argument((String)(key + "_pos"), (ArgumentType)Vec3Argument.vec3());
        if (isTerminal) {
            secondNode.executes(x -> 1);
        }
        ArgumentCommandNode second = secondNode.build();
        firstNode.then((CommandNode)second);
        ArgumentCommandNode first = firstNode.build();
        redirectionNodes.accept((CommandNode<SharedSuggestionProvider>)second);
        rootNode.addChild((CommandNode)first);
        rootNode.addChild((CommandNode)second);
        ArrayList<ArgumentCommandNode> nodesToAttach = new ArrayList<ArgumentCommandNode>();
        nodesToAttach.add(first);
        nodesToAttach.add(second);
        firstNodes.accept(nodesToAttach);
        return second;
    }
}

