/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.holder;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.MergeFunction;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.world.volume.archetype.ArchetypeVolume;
import org.spongepowered.api.world.volume.game.LocationBaseDataHolder;

public interface SpongeArchetypeVolumeDataHolder
extends LocationBaseDataHolder.Mutable,
ArchetypeVolume {
    @Override
    default public <E> Optional<E> get(int x, int y, int z, Key<? extends Value<E>> key) {
        Stream<Supplier> dataRetrievalStream = Stream.of(() -> this.block(x, y, z).get(key), () -> this.fluid(x, y, z).get(key), () -> this.blockEntityArchetype(x, y, z).flatMap(archetype -> archetype.get(key)));
        return dataRetrievalStream.map(Supplier::get).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    @Override
    default public <E, V extends Value<E>> Optional<V> getValue(int x, int y, int z, Key<V> key) {
        Stream<Supplier> dataRetrievalStream = Stream.of(() -> this.block(x, y, z).getValue(key), () -> this.fluid(x, y, z).getValue(key), () -> this.blockEntityArchetype(x, y, z).flatMap(archetype -> archetype.getValue(key)));
        return dataRetrievalStream.map(Supplier::get).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    @Override
    default public boolean supports(int x, int y, int z, Key<@NonNull ?> key) {
        Stream<Supplier> dataRetrievalStream = Stream.of(() -> this.block(x, y, z).supports(key), () -> this.fluid(x, y, z).supports(key), () -> this.blockEntityArchetype(x, y, z).map(archetype -> archetype.supports(key)).orElse(false));
        return dataRetrievalStream.map(Supplier::get).filter(Boolean::booleanValue).findFirst().orElse(false);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    default public Set<Key<@NonNull ?>> keys(int x, int y, int z) {
        Stream<@NonNull Supplier> dataRetrievalStream = Stream.of(() -> this.block(x, y, z).getKeys(), () -> this.fluid(x, y, z).getKeys(), () -> this.blockEntityArchetype(x, y, z).map(ValueContainer::getKeys).orElseGet(Collections::emptySet));
        return dataRetrievalStream.map(Supplier::get).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    default public Set<Value.Immutable<?>> getValues(int x, int y, int z) {
        Stream<Supplier> dataRetrievalStream = Stream.of(() -> this.block(x, y, z).getValues(), () -> this.fluid(x, y, z).getValues(), () -> this.blockEntityArchetype(x, y, z).map(ValueContainer::getValues).orElseGet(Collections::emptySet));
        return dataRetrievalStream.map(Supplier::get).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    default public <E> DataTransactionResult offer(int x, int y, int z, Key<? extends Value<E>> key, E value) {
        Stream<Supplier> dataRetrievalStream = Stream.of(() -> this.block(x, y, z).with(key, value).map(newState -> {
            Object newValue = newState.requireValue(key);
            this.setBlock(x, y, z, (BlockState)newState);
            return DataTransactionResult.successResult(newValue.asImmutable());
        }).orElseGet(DataTransactionResult::failNoData), () -> this.fluid(x, y, z).with(key, value).map(newState -> {
            Object newValue = newState.requireValue(key);
            this.setBlock(x, y, z, newState.block());
            return DataTransactionResult.successResult(newValue.asImmutable());
        }).orElseGet(DataTransactionResult::failNoData), () -> this.blockEntityArchetype(x, y, z).map(archetype -> archetype.offer(key, value)).orElseGet(DataTransactionResult::failNoData));
        return dataRetrievalStream.map(Supplier::get).filter(DataTransactionResult::isSuccessful).findFirst().orElseGet(DataTransactionResult::failNoData);
    }

    @Override
    default public DataTransactionResult remove(int x, int y, int z, Key<@NonNull ?> key) {
        Stream<Supplier> dataRetrievalStream = Stream.of(() -> this.block(x, y, z).without(key).map(newState -> {
            Value.Immutable newValue = this.block(x, y, z).requireValue(key).asImmutable();
            this.setBlock(x, y, z, (BlockState)newState);
            return DataTransactionResult.successResult(newValue);
        }).orElseGet(DataTransactionResult::failNoData), () -> this.fluid(x, y, z).without(key).map(newState -> {
            Value.Immutable newValue = this.fluid(x, y, z).requireValue(key).asImmutable();
            this.setBlock(x, y, z, newState.block());
            return DataTransactionResult.successResult(newValue);
        }).orElseGet(DataTransactionResult::failNoData), () -> this.blockEntityArchetype(x, y, z).map(archetype -> archetype.remove(key)).orElseGet(DataTransactionResult::failNoData));
        return dataRetrievalStream.map(Supplier::get).filter(DataTransactionResult::isSuccessful).findFirst().orElseGet(DataTransactionResult::failNoData);
    }

    @Override
    default public DataTransactionResult undo(int x, int y, int z, DataTransactionResult result) {
        return result.replacedData().stream().map(successful -> this.offer(x, y, z, successful)).collect(DataTransactionResult.toTransaction());
    }

    @Override
    default public DataTransactionResult copyFrom(int xTo, int yTo, int zTo, ValueContainer from) {
        return from.getValues().stream().map(value -> this.offer(xTo, yTo, zTo, value)).collect(DataTransactionResult.toTransaction());
    }

    @Override
    default public DataTransactionResult copyFrom(int xTo, int yTo, int zTo, ValueContainer from, MergeFunction function) {
        return from.getValues().stream().map(value -> {
            Value merged = this.get(xTo, yTo, zTo, value.key()).map(existing -> function.merge((Value)existing, value).asImmutable()).orElse((Value.Immutable)value);
            return this.offer(xTo, yTo, zTo, merged);
        }).collect(DataTransactionResult.toTransaction());
    }

    @Override
    default public DataTransactionResult copyFrom(int xTo, int yTo, int zTo, int xFrom, int yFrom, int zFrom, MergeFunction function) {
        return this.getValues(xFrom, yFrom, zFrom).stream().map(value -> {
            Value merged = this.get(xTo, yTo, zTo, value.key()).map(existing -> function.merge((Value)existing, value).asImmutable()).orElse(value.asImmutable());
            return this.offer(xTo, yTo, zTo, merged);
        }).collect(DataTransactionResult.toTransaction());
    }

    @Override
    default public boolean validateRawData(int x, int y, int z, DataView container) {
        return this.blockEntityArchetype(x, y, z).map(archetype -> archetype.validateRawData(container)).orElse(false);
    }

    @Override
    default public void setRawData(int x, int y, int z, DataView container) throws InvalidDataException {
        this.blockEntityArchetype(x, y, z).ifPresent(archetype -> archetype.setRawData(container));
    }
}

