/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.DataManipulator;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.common.data.manipulator.MutableDataManipulator;
import org.spongepowered.common.data.manipulator.SpongeDataManipulator;

final class ImmutableDataManipulator
extends SpongeDataManipulator
implements DataManipulator.Immutable {
    private @Nullable Set<Value.Immutable<?>> cachedValues;

    ImmutableDataManipulator(Map<Key<?>, Object> values) {
        super(values);
    }

    @Override
    public DataManipulator.Mutable asMutableCopy() {
        return new MutableDataManipulator(this.copyMap());
    }

    @Override
    public DataManipulator.Immutable without(Key<?> key) {
        Preconditions.checkNotNull(key, (Object)"key");
        if (!this.values.containsKey(key)) {
            return this;
        }
        return DataManipulator.Immutable.super.without(key);
    }

    @Override
    public DataManipulator.Mutable asMutable() {
        return this.asMutableCopy();
    }

    @Override
    public Set<Key<?>> getKeys() {
        return this.values.keySet();
    }

    @Override
    public Set<Value.Immutable<?>> getValues() {
        if (this.cachedValues == null) {
            this.cachedValues = super.getValues();
        }
        return this.cachedValues;
    }
}

