/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.nbt.validation;

import com.google.common.collect.ImmutableList;
import net.minecraft.nbt.CompoundTag;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.common.data.nbt.validation.RawDataValidator;
import org.spongepowered.common.data.nbt.validation.ValidationType;

public final class DelegateDataValidator
implements RawDataValidator {
    private final ImmutableList<RawDataValidator> validators;
    private final ValidationType type;

    public DelegateDataValidator(ImmutableList<RawDataValidator> validators, ValidationType type) {
        this.validators = validators;
        this.type = type;
    }

    @Override
    public ValidationType getValidationType() {
        return this.type;
    }

    @Override
    public boolean validate(CompoundTag view) {
        for (RawDataValidator validator : this.validators) {
            if (validator.validate(view)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean validate(DataView view) {
        for (RawDataValidator validator : this.validators) {
            if (validator.validate(view)) continue;
            return false;
        }
        return true;
    }
}

