/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider.block.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.common.accessor.world.level.block.entity.SignBlockEntityAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.data.provider.DataProviderRegistrator;
import org.spongepowered.common.util.DirectionUtil;
import org.spongepowered.common.util.RotationUtils;

public final class SignData {
    private SignData() {
    }

    public static void register(DataProviderRegistrator registrator) {
        ((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)registrator.asMutable(SignBlockEntity.class).create(Keys.SIGN_LINES).get(SignData::getSignLines)).set(SignData::setSignLines)).delete(h -> SignData.setSignLines(h, Collections.emptyList()))).create(Keys.DIRECTION).get(h -> {
            if (h.getBlockState().getBlock() instanceof StandingSignBlock) {
                return RotationUtils.getFor((Integer)h.getBlockState().getValue((Property)StandingSignBlock.ROTATION));
            }
            if (h.getBlockState().getBlock() instanceof WallSignBlock) {
                return DirectionUtil.getFor((Direction)h.getBlockState().getValue((Property)WallSignBlock.FACING));
            }
            return null;
        })).setAnd((h, v) -> {
            if (h.getBlockState().getBlock() instanceof StandingSignBlock) {
                h.getLevel().setBlockAndUpdate(h.getBlockPos(), RotationUtils.set(h.getBlockState(), v, (Property<Integer>)StandingSignBlock.ROTATION));
                return true;
            }
            if (h.getBlockState().getBlock() instanceof WallSignBlock) {
                h.getLevel().setBlockAndUpdate(h.getBlockPos(), DirectionUtil.set(h.getBlockState(), v, WallSignBlock.FACING));
                return true;
            }
            return false;
        })).supports(h -> h.getLevel() != null)).create(Keys.GLOWING_TEXT).get(SignBlockEntity::hasGlowingText)).set(SignBlockEntity::setHasGlowingText)).asMutable(ServerLocation.class).create(Keys.SIGN_LINES).get(SignData::getSignLines)).set(SignData::setSignLines)).delete(h -> SignData.setSignLines(h, Collections.emptyList()))).supports(loc -> loc.blockEntity().map(b -> b instanceof SignBlockEntity).orElse(false));
    }

    private static SignBlockEntity toSignTileEntity(ServerLocation holder) {
        return (SignBlockEntity)holder.blockEntity().get();
    }

    private static void setSignLines(ServerLocation holder, List<Component> value) {
        SignData.setSignLines(SignData.toSignTileEntity(holder), value);
    }

    private static void setSignLines(SignBlockEntity holder, List<Component> value) {
        SignBlockEntityAccessor accessor = (SignBlockEntityAccessor)holder;
        int messageCount = accessor.accessor$messages().length;
        for (int i = 0; i < messageCount; ++i) {
            holder.setMessage(i, SpongeAdventure.asVanilla((Component)(i > value.size() - 1 ? Component.empty() : value.get(i))));
        }
        holder.setChanged();
        holder.getLevel().sendBlockUpdated(holder.getBlockPos(), holder.getBlockState(), holder.getBlockState(), 3);
    }

    private static List<Component> getSignLines(ServerLocation h) {
        return SignData.getSignLines(SignData.toSignTileEntity(h));
    }

    private static List<Component> getSignLines(SignBlockEntity h) {
        SignBlockEntityAccessor accessor = (SignBlockEntityAccessor)h;
        int messageCount = accessor.accessor$messages().length;
        ArrayList<Component> lines = new ArrayList<Component>(messageCount);
        for (int i = 0; i < messageCount; ++i) {
            lines.add(SpongeAdventure.asAdventure(h.getMessage(i, false)));
        }
        return lines;
    }
}

