/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider.entity;

import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.level.Level;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.type.ArtType;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.server.level.ChunkMapAccessor;
import org.spongepowered.common.accessor.server.level.ChunkMap_TrackedEntityAccessor;
import org.spongepowered.common.accessor.world.entity.decoration.HangingEntityAccessor;
import org.spongepowered.common.accessor.world.entity.decoration.PaintingAccessor;
import org.spongepowered.common.config.SpongeGameConfigs;
import org.spongepowered.common.config.inheritable.WorldConfig;
import org.spongepowered.common.data.provider.DataProviderRegistrator;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.common.util.SpongeTicks;

public final class PaintingData {
    private PaintingData() {
    }

    public static void register(DataProviderRegistrator registrator) {
        ((DataProviderRegistrator.MutableRegistration)registrator.asMutable(Painting.class).create(Keys.ART_TYPE).get(h -> (ArtType)h.getVariant().value())).setAnd((h, v) -> {
            if (!h.level.isClientSide) {
                Holder oldArt = h.getVariant();
                ((PaintingAccessor)h).invoker$setVariant((Holder<PaintingVariant>)Holder.direct((Object)((PaintingVariant)v)));
                ((HangingEntityAccessor)h).invoker$setDirection(h.getDirection());
                if (!h.survives()) {
                    ((PaintingAccessor)h).invoker$setVariant((Holder<PaintingVariant>)oldArt);
                    ((HangingEntityAccessor)h).invoker$setDirection(h.getDirection());
                    return false;
                }
                ChunkMapAccessor chunkManager = (ChunkMapAccessor)((ServerLevel)h.level).getChunkSource().chunkMap;
                ChunkMap_TrackedEntityAccessor paintingTracker = (ChunkMap_TrackedEntityAccessor)chunkManager.accessor$entityMap().get(h.getId());
                if (paintingTracker == null) {
                    return true;
                }
                ArrayList<ServerPlayer> players = new ArrayList<ServerPlayer>();
                for (ServerPlayer player : paintingTracker.accessor$seenBy()) {
                    ClientboundRemoveEntitiesPacket packet = new ClientboundRemoveEntitiesPacket(new int[]{h.getId()});
                    player.connection.send((Packet)packet);
                    players.add(player);
                }
                for (ServerPlayer player : players) {
                    SpongeCommon.serverScheduler().submit(Task.builder().plugin(((Launch)Launch.instance()).commonPlugin()).delay(new SpongeTicks(((WorldConfig)SpongeGameConfigs.getForWorld((Level)h.level).get()).entity.painting.respawnDelay)).execute(() -> player.connection.send(h.getAddEntityPacket())).build());
                }
                return true;
            }
            return true;
        });
    }
}

