/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider.world.biome;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.entity.EntityCategory;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.util.Color;
import org.spongepowered.api.world.biome.ambient.ParticleConfig;
import org.spongepowered.api.world.biome.ambient.SoundConfig;
import org.spongepowered.api.world.biome.climate.Precipitation;
import org.spongepowered.api.world.biome.climate.TemperatureModifier;
import org.spongepowered.api.world.biome.spawner.NaturalSpawnCost;
import org.spongepowered.api.world.biome.spawner.NaturalSpawner;
import org.spongepowered.api.world.generation.carver.Carver;
import org.spongepowered.api.world.generation.carver.CarvingStep;
import org.spongepowered.api.world.generation.feature.DecorationStep;
import org.spongepowered.api.world.generation.feature.PlacedFeature;
import org.spongepowered.common.accessor.world.level.biome.BiomeAccessor;
import org.spongepowered.common.accessor.world.level.biome.Biome_ClimateSettingsAccessor;
import org.spongepowered.common.accessor.world.level.biome.MobSpawnSettingsAccessor;
import org.spongepowered.common.data.provider.DataProviderRegistrator;

public final class BiomeData {
    private BiomeData() {
    }

    public static void register(DataProviderRegistrator registrator) {
        ((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)registrator.asImmutable(Biome.class).create(Keys.BIOME_TEMPERATURE).get(h -> h.getBaseTemperature())).create(Keys.HUMIDITY).get(h -> h.getDownfall())).create(Keys.PRECIPITATION).get(h -> (Precipitation)h.getPrecipitation())).create(Keys.CARVERS).get(BiomeData::carvers)).create(Keys.FEATURES).get(BiomeData::features)).create(Keys.SPAWN_CHANCE).get(h -> h.getMobSettings().getCreatureProbability())).create(Keys.NATURAL_SPAWNERS).get(BiomeData::naturalSpawners)).create(Keys.NATURAL_SPAWNER_COST).get(BiomeData::naturalSpawnerCost)).create(Keys.FOG_COLOR).get(h -> Color.ofRgb(h.getSpecialEffects().getFogColor()))).create(Keys.WATER_COLOR).get(h -> Color.ofRgb(h.getSpecialEffects().getWaterColor()))).create(Keys.WATER_FOG_COLOR).get(h -> Color.ofRgb(h.getSpecialEffects().getWaterFogColor()))).create(Keys.SKY_COLOR).get(h -> Color.ofRgb(h.getSpecialEffects().getSkyColor()))).create(Keys.FOLIAGE_COLOR).get(h -> h.getSpecialEffects().getFoliageColorOverride().map(Color::ofRgb).orElse(null))).create(Keys.GRASS_COLOR).get(h -> h.getSpecialEffects().getGrassColorOverride().map(Color::ofRgb).orElse(null))).create(Keys.BACKGROUND_MUSIC).get(h -> h.getSpecialEffects().getBackgroundMusic().map(SoundConfig.BackgroundMusic.class::cast).orElse(null))).create(Keys.AMBIENT_ADDITIONAL_SOUND).get(h -> h.getSpecialEffects().getAmbientAdditionsSettings().map(SoundConfig.Additional.class::cast).orElse(null))).create(Keys.AMBIENT_MOOD).get(h -> h.getSpecialEffects().getAmbientMoodSettings().map(SoundConfig.Mood.class::cast).orElse(null))).create(Keys.AMBIENT_PARTICLE).get(h -> h.getSpecialEffects().getAmbientParticleSettings().map(ParticleConfig.class::cast).orElse(null))).asImmutable(BiomeAccessor.class).create(Keys.TEMPERATURE_MODIFIER).get(h -> (TemperatureModifier)((Biome_ClimateSettingsAccessor)h.accessor$climateSettings()).accessor$temperatureModifier());
    }

    private static Map<CarvingStep, List<Carver>> carvers(Biome biome) {
        BiomeGenerationSettings settings = biome.getGenerationSettings();
        return Arrays.stream(GenerationStep.Carving.values()).collect(Collectors.toMap(step -> (CarvingStep)step, step -> BiomeData.carverList(settings, step)));
    }

    private static List<Carver> carverList(BiomeGenerationSettings settings, GenerationStep.Carving step) {
        Iterable carvers = settings.getCarvers(step);
        return StreamSupport.stream(carvers.spliterator(), false).map(carver -> (Carver)carver.value()).collect(Collectors.toList());
    }

    private static Map<DecorationStep, List<PlacedFeature>> features(Biome biome) {
        BiomeGenerationSettings settings = biome.getGenerationSettings();
        return Arrays.stream(GenerationStep.Decoration.values()).collect(Collectors.toMap(step -> (DecorationStep)step, step -> BiomeData.featureList(settings, step)));
    }

    private static List<PlacedFeature> featureList(BiomeGenerationSettings settings, GenerationStep.Decoration step) {
        List features = settings.features();
        if (step.ordinal() >= features.size()) {
            return List.of();
        }
        HolderSet holders = (HolderSet)features.get(step.ordinal());
        return holders.stream().map(Holder::value).map(f -> (PlacedFeature)f).toList();
    }

    private static Map<EntityCategory, List<NaturalSpawner>> naturalSpawners(Biome biome) {
        HashMap<EntityCategory, List<NaturalSpawner>> map = new HashMap<EntityCategory, List<NaturalSpawner>>();
        for (MobCategory cat : MobCategory.values()) {
            BiomeData.naturalSpawner(biome, cat).ifPresent(v -> map.put((EntityCategory)cat, (List<NaturalSpawner>)v));
        }
        return map;
    }

    private static Optional<List<NaturalSpawner>> naturalSpawner(Biome biome, MobCategory cat) {
        List unwrap = biome.getMobSettings().getMobs(cat).unwrap();
        if (unwrap.isEmpty()) {
            return Optional.empty();
        }
        ArrayList result = new ArrayList();
        unwrap.forEach(data -> result.add((NaturalSpawner)data));
        return Optional.of(result);
    }

    private static Map<EntityType<?>, NaturalSpawnCost> naturalSpawnerCost(Biome biome) {
        Map<net.minecraft.world.entity.EntityType<?>, MobSpawnSettings.MobSpawnCost> costs = ((MobSpawnSettingsAccessor)biome.getMobSettings()).accessor$mobSpawnCosts();
        return costs.entrySet().stream().collect(Collectors.toMap(e -> (EntityType)e.getKey(), e -> (NaturalSpawnCost)e.getValue()));
    }
}

