/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity;

import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataManipulator;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.util.Transform;
import org.spongepowered.api.world.server.storage.ServerWorldProperties;
import org.spongepowered.common.bridge.data.SpongeDataHolderBridge;
import org.spongepowered.common.data.holder.SimpleNBTDataHolder;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.data.provider.nbt.NBTDataTypes;
import org.spongepowered.common.entity.SpongeEntitySnapshot;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.DataUtil;
import org.spongepowered.math.vector.Vector3d;

public final class SpongeEntitySnapshotBuilder
extends AbstractDataBuilder<EntitySnapshot>
implements EntitySnapshot.Builder {
    ResourceKey worldKey;
    Vector3d position;
    Vector3d rotation;
    Vector3d scale;
    EntityType<?> entityType;
    @Nullable UUID uniqueId;
    @Nullable DataManipulator.Mutable manipulator;
    @Nullable CompoundTag compound;
    @Nullable WeakReference<Entity> entityReference;

    public SpongeEntitySnapshotBuilder() {
        super(EntitySnapshot.class, 1);
    }

    @Override
    public SpongeEntitySnapshotBuilder world(ServerWorldProperties worldProperties) {
        this.worldKey = Objects.requireNonNull(worldProperties).key();
        return this;
    }

    @Override
    public SpongeEntitySnapshotBuilder type(EntityType<?> entityType) {
        this.entityType = Objects.requireNonNull(entityType);
        this.manipulator = null;
        this.compound = null;
        this.uniqueId = null;
        return this;
    }

    @Override
    public SpongeEntitySnapshotBuilder position(Vector3d position) {
        this.position = Objects.requireNonNull(position);
        return this;
    }

    public SpongeEntitySnapshotBuilder rotation(Vector3d rotation) {
        this.rotation = Objects.requireNonNull(rotation);
        return this;
    }

    public SpongeEntitySnapshotBuilder scale(Vector3d scale) {
        this.scale = Objects.requireNonNull(scale);
        return this;
    }

    public SpongeEntitySnapshotBuilder id(UUID entityId) {
        this.uniqueId = Objects.requireNonNull(entityId);
        return this;
    }

    @Override
    public SpongeEntitySnapshotBuilder from(Entity entity) {
        this.reset();
        this.entityReference = new WeakReference<Entity>(entity);
        this.worldKey = entity.serverLocation().worldKey();
        this.position = entity.transform().position();
        this.rotation = entity.transform().rotation();
        this.scale = entity.transform().scale();
        this.entityType = entity.type();
        this.uniqueId = entity.uniqueId();
        this.manipulator = ((SpongeDataHolderBridge)((Object)entity)).bridge$getManipulator().copy();
        this.compound = new CompoundTag();
        ((net.minecraft.world.entity.Entity)entity).saveWithoutId(this.compound);
        return this;
    }

    @Override
    public <V> EntitySnapshot.Builder add(Key<? extends Value<V>> key, V value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(this.entityType);
        if (this.manipulator == null) {
            this.manipulator = DataManipulator.mutableOf();
        }
        this.manipulator.set(key, value);
        return this;
    }

    @Override
    public SpongeEntitySnapshotBuilder from(EntitySnapshot holder) {
        this.reset();
        this.entityType = holder.type();
        this.worldKey = holder.world();
        if (holder.uniqueId().isPresent()) {
            this.uniqueId = holder.uniqueId().get();
        }
        this.position = holder.position().toDouble();
        Optional<Transform> optional = holder.transform();
        if (optional.isPresent()) {
            this.position = optional.get().position();
            this.rotation = optional.get().rotation();
            this.scale = optional.get().scale();
        }
        this.manipulator = DataManipulator.mutableOf(holder);
        if (holder instanceof SpongeEntitySnapshot) {
            this.compound = ((SpongeEntitySnapshot)holder).getCompound().orElse(null);
        }
        return this;
    }

    @Override
    public SpongeEntitySnapshotBuilder from(net.minecraft.world.entity.Entity minecraftEntity) {
        this.entityType = ((Entity)minecraftEntity).type();
        this.worldKey = ((Entity)minecraftEntity).serverLocation().worldKey();
        this.uniqueId = minecraftEntity.getUUID();
        Transform transform = ((Entity)minecraftEntity).transform();
        this.position = transform.position();
        this.rotation = transform.rotation();
        this.scale = transform.scale();
        this.manipulator = DataManipulator.mutableOf((Entity)minecraftEntity);
        this.compound = new CompoundTag();
        minecraftEntity.saveWithoutId(this.compound);
        return this;
    }

    public SpongeEntitySnapshotBuilder unsafeCompound(CompoundTag compound) {
        this.compound = Objects.requireNonNull(compound).copy();
        return this;
    }

    @Override
    public SpongeEntitySnapshotBuilder reset() {
        this.worldKey = null;
        this.uniqueId = null;
        this.position = null;
        this.rotation = null;
        this.scale = null;
        this.entityType = null;
        this.manipulator = null;
        this.compound = null;
        this.entityReference = null;
        return this;
    }

    public EntitySnapshot build() {
        Objects.requireNonNull(this.worldKey);
        Objects.requireNonNull(this.position);
        Objects.requireNonNull(this.rotation);
        Objects.requireNonNull(this.scale);
        Objects.requireNonNull(this.entityType);
        SpongeEntitySnapshot snapshot = new SpongeEntitySnapshot(this);
        if (this.manipulator != null && !this.manipulator.getKeys().isEmpty()) {
            if (this.compound == null) {
                this.compound = new CompoundTag();
            }
            SimpleNBTDataHolder dataHolder = new SimpleNBTDataHolder(this.compound, NBTDataTypes.ENTITY);
            dataHolder.copyFrom(this.manipulator);
            this.compound = dataHolder.data$getCompound();
            if (this.compound.isEmpty()) {
                this.compound = null;
            }
        }
        return snapshot;
    }

    @Override
    protected Optional<EntitySnapshot> buildContent(DataView container) throws InvalidDataException {
        if (!container.contains(Queries.WORLD_KEY, Constants.Entity.TYPE, Constants.Entity.ROTATION, Constants.Entity.SCALE, Constants.Sponge.SNAPSHOT_WORLD_POSITION)) {
            return Optional.empty();
        }
        this.worldKey = ResourceKey.resolve(container.getString(Queries.WORLD_KEY).get());
        this.position = DataUtil.getPosition3d(container, Constants.Sponge.SNAPSHOT_WORLD_POSITION);
        this.rotation = DataUtil.getPosition3d(container, Constants.Entity.ROTATION);
        this.scale = DataUtil.getPosition3d(container, Constants.Entity.SCALE);
        String entityTypeId = container.getString(Constants.Entity.TYPE).get();
        this.entityType = (EntityType)Sponge.game().registry(RegistryTypes.ENTITY_TYPE).value(ResourceKey.resolve(entityTypeId));
        this.manipulator = null;
        if (container.contains(Constants.Sponge.UNSAFE_NBT)) {
            this.compound = NBTTranslator.INSTANCE.translate(container.getView(Constants.Sponge.UNSAFE_NBT).get());
        }
        if (container.contains(Constants.Entity.UUID)) {
            this.uniqueId = UUID.fromString(container.getString(Constants.Entity.UUID).get());
        }
        return Optional.of(this.build());
    }
}

