/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.player.tab;

import com.google.common.base.Preconditions;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.tab.TabList;
import org.spongepowered.api.entity.living.player.tab.TabListEntry;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.common.entity.player.tab.SpongeTabListEntry;

public final class TabListEntryBuilder
implements TabListEntry.Builder {
    private @Nullable TabList list;
    private @Nullable GameProfile profile;
    private @Nullable Component displayName;
    private int latency;
    private @Nullable GameMode gameMode;

    @Override
    public TabListEntry.Builder list(TabList list) {
        this.list = (TabList)Preconditions.checkNotNull((Object)list, (Object)"list");
        return this;
    }

    @Override
    public TabListEntry.Builder profile(GameProfile profile) {
        this.profile = (GameProfile)Preconditions.checkNotNull((Object)profile, (Object)"profile");
        return this;
    }

    @Override
    public TabListEntry.Builder displayName(@Nullable Component displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    public TabListEntry.Builder latency(int latency) {
        this.latency = latency;
        return this;
    }

    @Override
    public TabListEntry.Builder gameMode(GameMode gameMode) {
        this.gameMode = (GameMode)Preconditions.checkNotNull((Object)gameMode, (Object)"game mode");
        return this;
    }

    @Override
    public TabListEntry build() {
        Preconditions.checkState((this.list != null ? 1 : 0) != 0, (Object)"list must be set");
        Preconditions.checkState((this.profile != null ? 1 : 0) != 0, (Object)"profile must be set");
        Preconditions.checkState((this.gameMode != null ? 1 : 0) != 0, (Object)"game mode must be set");
        return new SpongeTabListEntry(this.list, this.profile, this.displayName, this.latency, this.gameMode, null);
    }

    @Override
    public TabListEntry.Builder from(TabListEntry value) {
        this.list = (TabList)Preconditions.checkNotNull((Object)value.list(), (Object)"list");
        this.profile = (GameProfile)Preconditions.checkNotNull((Object)value.profile(), (Object)"profile");
        this.displayName = value.displayName().orElse(null);
        this.latency = value.latency();
        this.gameMode = (GameMode)Preconditions.checkNotNull((Object)value.gameMode(), (Object)"game mode");
        return this;
    }

    @Override
    public TabListEntry.Builder reset() {
        this.list = null;
        this.profile = null;
        this.displayName = null;
        this.latency = 0;
        this.gameMode = null;
        return this;
    }
}

