/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.inventory;

import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.item.inventory.AnvilCost;
import org.spongepowered.common.util.Constants;

public class UpdateAnvilEventCost
implements AnvilCost {
    private final int levelCost;
    private final int materialCost;

    public UpdateAnvilEventCost(int levelCost, int materialCost) {
        this.levelCost = levelCost;
        this.materialCost = materialCost;
    }

    @Override
    public int levelCost() {
        return this.levelCost;
    }

    @Override
    public int materialCost() {
        return this.materialCost;
    }

    @Override
    public AnvilCost withLevelCost(int levelCost) {
        return new UpdateAnvilEventCost(levelCost, this.materialCost);
    }

    @Override
    public AnvilCost withMaterialCost(int materialCost) {
        return new UpdateAnvilEventCost(this.levelCost, materialCost);
    }

    @Override
    public int contentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        return DataContainer.createNew().set(Queries.CONTENT_VERSION, this.contentVersion()).set(Constants.TileEntity.Anvils.MATERIALCOST, this.materialCost()).set(Constants.TileEntity.Anvils.LEVELCOST, this.levelCost());
    }
}

