/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.manager;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.spongepowered.api.event.Event;
import org.spongepowered.common.event.filter.EventFilter;
import org.spongepowered.common.event.filter.FilterFactory;
import org.spongepowered.common.event.filter.FilterGenerator;
import org.spongepowered.common.event.gen.LoaderClassWriter;
import org.spongepowered.common.event.manager.AnnotatedEventListener;
import org.spongepowered.common.event.manager.ListenerClassVisitor;
import org.spongepowered.common.util.generator.GeneratorUtils;

public final class ClassEventListenerFactory
implements AnnotatedEventListener.Factory {
    private static final String FILTER = "filter";
    private final MethodHandles.Lookup lookup;
    private final FilterFactory filterFactory;
    private static final String BASE_HANDLER = Type.getInternalName(AnnotatedEventListener.class);
    private static final String HANDLE_METHOD_DESCRIPTOR = "(" + Type.getDescriptor(Event.class) + ")V";

    public ClassEventListenerFactory(FilterFactory factory, MethodHandles.Lookup lookup) {
        this.filterFactory = Objects.requireNonNull(factory, "filterFactory");
        this.lookup = Objects.requireNonNull(lookup, "lookup");
    }

    @Override
    public AnnotatedEventListener create(Object handle, ListenerClassVisitor.DiscoveredMethod method, @Nullable MethodHandles.Lookup lookup) throws Throwable {
        if (lookup == null) {
            lookup = this.createLookup(method);
        }
        return lookup.findConstructor(lookup.lookupClass(), MethodType.methodType(Void.TYPE, method.declaringClass())).invoke(handle);
    }

    MethodHandles.Lookup createLookup(ListenerClassVisitor.DiscoveredMethod method) throws Exception {
        Class<?> handle = method.declaringClass();
        Class<?> eventClass = method.parameterTypes()[0].clazz();
        String listenerName = "Listener_" + handle.getSimpleName() + "_" + method.methodName();
        MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(handle, this.lookup);
        @Nullable EventFilter filter = this.filterFactory.create(method, lookup);
        if (filter == null && method.parameterTypes().length != 1) {
            throw new IllegalStateException("Failed to generate EventFilter for non trivial filtering operation.");
        }
        if (filter != null) {
            MethodHandles.Lookup clazz = lookup.defineHiddenClass(ClassEventListenerFactory.generateFilteredClass(listenerName, handle, method), true, MethodHandles.Lookup.ClassOption.NESTMATE);
            clazz.findStaticVarHandle(clazz.lookupClass(), FILTER, EventFilter.class).set(filter);
            return clazz;
        }
        return lookup.defineHiddenClass(ClassEventListenerFactory.generateClass(listenerName, handle, method, eventClass), true, MethodHandles.Lookup.ClassOption.NESTMATE);
    }

    private static byte[] generateFilteredClass(String listenerName, Class<?> handle, ListenerClassVisitor.DiscoveredMethod method) {
        String handleName = Type.getInternalName(handle);
        String name = handleName + "_" + listenerName;
        String handleDescriptor = handle.descriptorString();
        StringBuilder eventDescriptor = new StringBuilder("(");
        for (int i = 0; i < method.parameterTypes().length; ++i) {
            eventDescriptor.append(method.parameterTypes()[i].type().getDescriptor());
        }
        eventDescriptor.append(")V");
        LoaderClassWriter cw = new LoaderClassWriter(handle.getClassLoader(), 3);
        cw.visit(55, 49, name, null, BASE_HANDLER, null);
        FieldVisitor fv = cw.visitField(10, FILTER, EventFilter.class.descriptorString(), null, null);
        fv.visitEnd();
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(" + handleDescriptor + ")V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, BASE_HANDLER, "<init>", "(Ljava/lang/Object;)V", false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "handle", HANDLE_METHOD_DESCRIPTOR, null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        mv.visitFieldInsn(178, name, FILTER, EventFilter.class.descriptorString());
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, Type.getInternalName(EventFilter.class), FILTER, FilterGenerator.FILTER_DESCRIPTOR, true);
        mv.visitVarInsn(58, 2);
        mv.visitVarInsn(25, 2);
        Label l2 = new Label();
        mv.visitJumpInsn(198, l2);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, name, "handle", "Ljava/lang/Object;");
        mv.visitTypeInsn(192, handleName);
        for (int i = 0; i < method.parameterTypes().length; ++i) {
            mv.visitVarInsn(25, 2);
            mv.visitIntInsn(16, i);
            mv.visitInsn(50);
            Type paramType = method.parameterTypes()[i].type();
            GeneratorUtils.visitUnboxingMethod(mv, paramType);
        }
        mv.visitMethodInsn(182, handleName, method.methodName(), eventDescriptor.toString(), false);
        mv.visitLabel(l2);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }

    private static byte[] generateClass(String listenerName, Class<?> handle, ListenerClassVisitor.DiscoveredMethod method, Class<?> eventClass) {
        String handleName = Type.getInternalName(handle);
        String name = handleName + "_" + listenerName;
        String handleDescriptor = handle.descriptorString();
        String eventName = Type.getInternalName(eventClass);
        LoaderClassWriter cw = new LoaderClassWriter(handle.getClassLoader(), 3);
        cw.visit(55, 49, name, null, BASE_HANDLER, null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(" + handleDescriptor + ")V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, BASE_HANDLER, "<init>", "(Ljava/lang/Object;)V", false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "handle", HANDLE_METHOD_DESCRIPTOR, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, name, "handle", "Ljava/lang/Object;");
        mv.visitTypeInsn(192, handleName);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, eventName);
        mv.visitMethodInsn(182, handleName, method.methodName(), "(L" + eventName + ";)V", false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }
}

