/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking;

import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public final class BlockChangeFlagManager {
    private final Int2ObjectMap<SpongeBlockChangeFlag> maskedFlags = new Int2ObjectLinkedOpenHashMap(512);
    private static final BlockChangeFlagManager INSTANCE = new BlockChangeFlagManager();
    private static final SpongeBlockChangeFlag PHYSICS_OBSERVER = new SpongeBlockChangeFlag(2);
    private static final SpongeBlockChangeFlag DEFAULT = new SpongeBlockChangeFlag(3);

    public static BlockChangeFlagManager getInstance() {
        return INSTANCE;
    }

    public static SpongeBlockChangeFlag fromNativeInt(int flag) {
        if (flag == 3) {
            return DEFAULT;
        }
        if (flag == 2) {
            return PHYSICS_OBSERVER;
        }
        BlockChangeFlagManager instance = BlockChangeFlagManager.getInstance();
        return (SpongeBlockChangeFlag)instance.maskedFlags.computeIfAbsent(flag, SpongeBlockChangeFlag::new);
    }

    public static SpongeBlockChangeFlag andNotifyClients(BlockChangeFlag flag) {
        int rawFlag = ((SpongeBlockChangeFlag)flag).getRawFlag();
        if ((rawFlag & 2) != 0) {
            return (SpongeBlockChangeFlag)flag;
        }
        return BlockChangeFlagManager.fromNativeInt(rawFlag & 0xFFFFFFFD);
    }

    private BlockChangeFlagManager() {
        for (int i = 0; i < 1024; ++i) {
            SpongeBlockChangeFlag flag = new SpongeBlockChangeFlag(i);
            this.maskedFlags.put(flag.getRawFlag(), (Object)flag);
        }
    }

    public static final class Factory
    implements BlockChangeFlag.Factory {
        private @Nullable BlockChangeFlag none;

        @Override
        public BlockChangeFlag none() {
            if (this.none == null) {
                this.none = BlockChangeFlagManager.fromNativeInt(944);
            }
            return this.none;
        }
    }
}

