/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.transaction.InventoryTransactionResult;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;

public class InventoryTransactionResultImpl
implements InventoryTransactionResult,
InventoryTransactionResult.Poll {
    private final List<SlotTransaction> slotTransactions;
    private final List<ItemStackSnapshot> rejected;
    private final List<ItemStackSnapshot> polled;
    private final InventoryTransactionResult.Type type;

    InventoryTransactionResultImpl(Builder builder) {
        this.type = (InventoryTransactionResult.Type)((Object)Preconditions.checkNotNull((Object)((Object)builder.resultType), (Object)"Result type"));
        this.rejected = builder.rejected != null ? ImmutableList.copyOf(builder.rejected) : Collections.emptyList();
        this.slotTransactions = builder.slotTransactions != null ? ImmutableList.copyOf(builder.slotTransactions) : Collections.emptyList();
        this.polled = builder.polled != null ? ImmutableList.copyOf(builder.polled) : Collections.emptyList();
    }

    @Override
    public InventoryTransactionResult and(InventoryTransactionResult other) {
        InventoryTransactionResult.Type resultType = InventoryTransactionResult.Type.SUCCESS;
        if (this.type == InventoryTransactionResult.Type.ERROR || other.type() == InventoryTransactionResult.Type.ERROR) {
            resultType = InventoryTransactionResult.Type.ERROR;
        }
        if (this.type == InventoryTransactionResult.Type.FAILURE || other.type() == InventoryTransactionResult.Type.FAILURE) {
            resultType = InventoryTransactionResult.Type.FAILURE;
        }
        InventoryTransactionResult.Builder builder = InventoryTransactionResult.builder().type(resultType).reject(this.rejected).reject(other.rejectedItems()).transaction(this.slotTransactions).transaction(other.slotTransactions());
        this.polled.forEach(builder::poll);
        return builder.build();
    }

    @Override
    public void revert() {
        for (SlotTransaction transaction : Lists.reverse(this.slotTransactions)) {
            transaction.slot().set(((ItemStackSnapshot)transaction.original()).createStack());
        }
    }

    @Override
    public boolean revertOnFailure() {
        if (this.type == InventoryTransactionResult.Type.FAILURE) {
            this.revert();
            return true;
        }
        return false;
    }

    @Override
    public InventoryTransactionResult.Type type() {
        return this.type;
    }

    @Override
    public List<ItemStackSnapshot> rejectedItems() {
        return this.rejected;
    }

    @Override
    public List<SlotTransaction> slotTransactions() {
        return this.slotTransactions;
    }

    @Override
    public List<ItemStackSnapshot> polledItems() {
        return this.polled;
    }

    @Override
    public ItemStackSnapshot polledItem() {
        return this.polled.get(0);
    }

    public static class Builder
    implements InventoryTransactionResult.Builder,
    InventoryTransactionResult.Builder.PollBuilder {
        @Nullable InventoryTransactionResult.Type resultType;
        @Nullable List<ItemStackSnapshot> rejected;
        @Nullable List<SlotTransaction> slotTransactions;
        @Nullable List<ItemStackSnapshot> polled;

        @Override
        public InventoryTransactionResult.Builder type(InventoryTransactionResult.Type type) {
            this.resultType = (InventoryTransactionResult.Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"Type cannot be null!"));
            return this;
        }

        @Override
        public InventoryTransactionResult.Builder.PollBuilder poll(ItemStackSnapshot itemStack) {
            if (this.polled == null) {
                this.polled = new ArrayList<ItemStackSnapshot>();
            }
            this.polled.add(itemStack);
            return this;
        }

        @Override
        public InventoryTransactionResult.Builder reject(ItemStack ... itemStacks) {
            if (this.rejected == null) {
                this.rejected = new ArrayList<ItemStackSnapshot>();
            }
            for (ItemStack itemStack1 : itemStacks) {
                if (itemStack1.isEmpty()) continue;
                this.rejected.add(itemStack1.createSnapshot());
            }
            return this;
        }

        @Override
        public InventoryTransactionResult.Builder reject(Iterable<ItemStackSnapshot> itemStacks) {
            if (this.rejected == null) {
                this.rejected = new ArrayList<ItemStackSnapshot>();
            }
            for (ItemStackSnapshot itemStack1 : itemStacks) {
                if (itemStack1.isEmpty()) continue;
                this.rejected.add(itemStack1);
            }
            return this;
        }

        @Override
        public InventoryTransactionResult.Builder transaction(SlotTransaction ... slotTransactions) {
            return this.transaction(Arrays.asList(slotTransactions));
        }

        @Override
        public InventoryTransactionResult.Builder transaction(Iterable<SlotTransaction> slotTransactions) {
            if (this.slotTransactions == null) {
                this.slotTransactions = new ArrayList<SlotTransaction>();
            }
            for (SlotTransaction transaction : slotTransactions) {
                this.slotTransactions.add(transaction);
            }
            return this;
        }

        @Override
        public InventoryTransactionResult.Poll build() {
            Preconditions.checkState((this.resultType != null ? 1 : 0) != 0, (Object)"ResultType cannot be null!");
            return new InventoryTransactionResultImpl(this);
        }

        @Override
        public InventoryTransactionResult.Builder from(InventoryTransactionResult value) {
            Preconditions.checkNotNull((Object)value, (Object)"InventoryTransactionResult cannot be null!");
            this.resultType = (InventoryTransactionResult.Type)((Object)Preconditions.checkNotNull((Object)((Object)value.type()), (Object)"ResultType cannot be null!"));
            this.slotTransactions = new ArrayList<SlotTransaction>(value.slotTransactions());
            this.rejected = new ArrayList<ItemStackSnapshot>(value.rejectedItems());
            return this;
        }

        @Override
        public InventoryTransactionResult.Builder reset() {
            this.resultType = null;
            this.rejected = null;
            this.slotTransactions = null;
            return this;
        }
    }
}

