/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.adapter.impl.comp;

import java.util.Optional;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.transaction.InventoryTransactionResult;
import org.spongepowered.api.item.inventory.type.Inventory2D;
import org.spongepowered.common.inventory.adapter.impl.AdapterLogic;
import org.spongepowered.common.inventory.adapter.impl.BasicInventoryAdapter;
import org.spongepowered.common.inventory.fabric.Fabric;
import org.spongepowered.common.inventory.lens.impl.comp.Inventory2DLens;
import org.spongepowered.common.inventory.lens.slots.SlotLens;
import org.spongepowered.math.vector.Vector2i;

public class Inventory2DAdapter
extends BasicInventoryAdapter
implements Inventory2D {
    protected Inventory2DLens lens2d;

    public Inventory2DAdapter(Fabric fabric, Inventory2DLens root, Inventory parent) {
        super(fabric, root, parent);
        this.lens2d = root;
    }

    public SlotLens getSlotLens(int x, int y) {
        return this.getSlotLens(Vector2i.from((int)x, (int)y));
    }

    protected SlotLens getSlotLens(Vector2i pos) {
        try {
            return this.lens2d.getSlot(pos);
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    @Override
    public Optional<Slot> slot(Vector2i pos) {
        return BasicInventoryAdapter.forSlot(this.inventoryAdapter$getFabric(), this.getSlotLens(pos), this);
    }

    @Override
    public InventoryTransactionResult.Poll poll(Vector2i pos) {
        return AdapterLogic.pollSequential(this.inventoryAdapter$getFabric(), this.getSlotLens(pos), null);
    }

    @Override
    public InventoryTransactionResult.Poll poll(Vector2i pos, int limit) {
        return AdapterLogic.pollSequential(this.inventoryAdapter$getFabric(), this.getSlotLens(pos), limit);
    }

    @Override
    public Optional<ItemStack> peek(Vector2i pos) {
        return AdapterLogic.peekSequential(this.inventoryAdapter$getFabric(), this.getSlotLens(pos));
    }

    @Override
    public InventoryTransactionResult set(Vector2i pos, ItemStack stack) {
        return AdapterLogic.insertSequential(this.inventoryAdapter$getFabric(), this.getSlotLens(pos), stack);
    }
}

