/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.custom;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.SimpleContainerData;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.ContainerType;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.common.inventory.custom.CustomContainer;
import org.spongepowered.common.inventory.custom.CustomInventory;
import org.spongepowered.common.inventory.custom.SpongeViewableInventoryBuilder;
import org.spongepowered.common.inventory.lens.Lens;
import org.spongepowered.common.inventory.lens.impl.slot.SlotLensProvider;
import org.spongepowered.plugin.PluginContainer;

public class ViewableCustomInventory
extends CustomInventory
implements MenuProvider {
    private final ContainerType type;
    private final SpongeViewableInventoryBuilder.ContainerTypeInfo info;
    private boolean vanilla = false;
    private final Set<Player> viewers = new HashSet<Player>();
    private final SimpleContainerData data;

    public ViewableCustomInventory(PluginContainer plugin, ContainerType type, SpongeViewableInventoryBuilder.ContainerTypeInfo info, int size, Lens lens, SlotLensProvider provider, List<Inventory> inventories, @Nullable UUID identity, @Nullable Carrier carrier) {
        super(plugin, size, lens, provider, inventories, identity, carrier);
        this.type = type;
        this.info = info;
        this.data = this.info.dataProvider.get();
    }

    public ViewableCustomInventory vanilla() {
        this.vanilla = true;
        return this;
    }

    public ContainerType getType() {
        return this.type;
    }

    public void startOpen(Player player) {
        this.viewers.add(player);
    }

    public void stopOpen(Player player) {
        this.viewers.remove(player);
    }

    public @Nullable AbstractContainerMenu createMenu(int id, net.minecraft.world.entity.player.Inventory playerInv, Player player) {
        if (this.vanilla) {
            return this.info.containerProvider.createMenu(id, playerInv, player, this);
        }
        return new CustomContainer(id, player, this, this.type);
    }

    public SimpleContainerData getData() {
        return this.data;
    }

    public Component getDisplayName() {
        return Component.literal((String)"ViewableCustomInventory");
    }
}

