/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.crafting.shapeless;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.item.recipe.RecipeRegistration;
import org.spongepowered.common.item.recipe.SpongeRecipeRegistration;
import org.spongepowered.common.item.recipe.ingredient.IngredientResultUtil;

public class SpongeShapelessCraftingRecipeRegistration
extends SpongeRecipeRegistration {
    private final Item result;
    private final int count;
    private final List<Ingredient> ingredients;
    private final ItemStack spongeResult;
    private final Function<CraftingContainer, ItemStack> resultFunction;
    private final Function<CraftingContainer, NonNullList<ItemStack>> remainingItemsFunction;

    public SpongeShapelessCraftingRecipeRegistration(ResourceLocation key, RecipeSerializer<?> serializer, String group, List<Ingredient> ingredients, ItemStack spongeResult, Function<CraftingContainer, ItemStack> resultFunction, Function<CraftingContainer, NonNullList<ItemStack>> remainingItemsFunction, DataPack<RecipeRegistration> pack) {
        super(key, serializer, spongeResult.getItem(), group, pack);
        this.ingredients = ingredients;
        this.count = spongeResult.getCount();
        this.result = spongeResult.getItem();
        this.spongeResult = spongeResult.hasTag() ? spongeResult : null;
        this.resultFunction = resultFunction;
        this.remainingItemsFunction = remainingItemsFunction;
    }

    @Override
    public void serializeShape(JsonObject json) {
        JsonArray jsonarray = new JsonArray();
        this.ingredients.stream().map(Ingredient::toJson).forEach(jsonarray::add);
        json.add("ingredients", jsonarray);
    }

    @Override
    public void serializeResult(JsonObject json) {
        JsonObject result = new JsonObject();
        result.addProperty("item", Registry.ITEM.getKey((Object)this.result).toString());
        if (this.count > 1) {
            result.addProperty("count", this.count);
        }
        json.add("result", result);
        if (this.spongeResult != null) {
            json.add("sponge:result", IngredientResultUtil.serializeItemStack(this.spongeResult));
        }
        if (this.resultFunction != null) {
            json.addProperty("sponge:result_function", IngredientResultUtil.cacheResultFunction(this.getId(), this.resultFunction));
        }
        if (this.remainingItemsFunction != null) {
            json.addProperty("sponge:remaining_items", IngredientResultUtil.cacheRemainingItemsFunction(this.getId(), this.remainingItemsFunction));
        }
    }
}

