/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.core;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.registry.RegistryEntry;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.api.registry.ValueNotFoundException;
import org.spongepowered.api.tag.Tag;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.core.RegistryBridge;

@Mixin(value={net.minecraft.core.Registry.class})
@Implements(value={@Interface(iface=Registry.class, prefix="registry$", remap=Interface.Remap.NONE)})
public abstract class RegistryMixin_API<T>
implements Registry<T> {
    @Shadow
    public abstract ResourceKey<? extends net.minecraft.core.Registry<T>> shadow$key();

    @Shadow
    @Nullable
    public abstract ResourceLocation shadow$getKey(T var1);

    @Shadow
    public abstract Optional<HolderSet.Named<T>> shadow$getTag(TagKey<T> var1);

    @Shadow
    public abstract Optional<T> shadow$getOptional(@Nullable ResourceLocation var1);

    @Shadow
    public abstract ResourceKey<? extends net.minecraft.core.Registry<T>> key();

    @Shadow
    public abstract Stream<TagKey<T>> getTagNames();

    @Override
    public RegistryType<T> type() {
        return ((RegistryBridge)((Object)this)).bridge$type();
    }

    @Override
    public org.spongepowered.api.ResourceKey valueKey(T value) {
        Objects.requireNonNull(value, "value");
        ResourceLocation key = this.shadow$getKey(value);
        if (key == null) {
            throw new IllegalStateException(String.format("No key was found for '%s'!", value));
        }
        return (org.spongepowered.api.ResourceKey)key;
    }

    @Override
    public Optional<org.spongepowered.api.ResourceKey> findValueKey(T value) {
        Objects.requireNonNull(value, "value");
        return Optional.ofNullable(this.shadow$getKey(value)).map(l -> (org.spongepowered.api.ResourceKey)l);
    }

    @Override
    public <V extends T> Optional<RegistryEntry<V>> findEntry(org.spongepowered.api.ResourceKey key) {
        return ((RegistryBridge)((Object)this)).bridge$get(Objects.requireNonNull(key, "key"));
    }

    @Override
    public <V extends T> Optional<V> findValue(org.spongepowered.api.ResourceKey key) {
        return this.shadow$getOptional((ResourceLocation)Objects.requireNonNull(key, "key"));
    }

    @Override
    public <V extends T> V value(org.spongepowered.api.ResourceKey key) {
        return (V)this.shadow$getOptional((ResourceLocation)Objects.requireNonNull(key, "key")).orElseThrow(() -> new ValueNotFoundException(String.format("No value was found for key '%s'!", key)));
    }

    @Override
    public <V extends T> Set<V> taggedValues(Tag<T> tag) {
        return this.shadow$getTag((TagKey)tag).stream().flatMap(HolderSet.ListBacked::stream).map(h -> h.value()).collect(Collectors.toSet());
    }

    @Override
    public <V extends T> Stream<Tag<V>> tags() {
        return this.getTagNames().map(Tag.class::cast);
    }

    @Override
    public Stream<RegistryEntry<T>> streamEntries() {
        return ((RegistryBridge)((Object)this)).bridge$streamEntries();
    }

    @Intrinsic
    public Stream<T> registry$stream() {
        return ((RegistryBridge)((Object)this)).bridge$streamEntries().map(RegistryEntry::value);
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public <V extends T> Optional<RegistryEntry<V>> register(org.spongepowered.api.ResourceKey key, V value) {
        return Optional.empty();
    }
}

