/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level.levelgen.structure;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.StructureType;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.entity.EntityCategory;
import org.spongepowered.api.world.generation.feature.DecorationStep;
import org.spongepowered.api.world.generation.structure.Structure;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={Structure.class})
public abstract class StructureMixin_API
implements org.spongepowered.api.world.generation.structure.Structure {
    @Shadow
    public abstract StructureType<?> shadow$type();

    @Shadow
    public abstract HolderSet<Biome> shadow$biomes();

    @Shadow
    public abstract GenerationStep.Decoration shadow$step();

    @Shadow
    public abstract Map<MobCategory, StructureSpawnOverride> shadow$spawnOverrides();

    @Override
    public boolean place(ServerWorld world, Vector3i pos) {
        ChunkPos maxPos;
        ServerLevel level = (ServerLevel)world;
        ServerChunkCache chunkSource = level.getChunkSource();
        StructureStart start = ((Structure)this).generate(level.registryAccess(), chunkSource.getGenerator(), chunkSource.getGenerator().getBiomeSource(), chunkSource.randomState(), level.getStructureManager(), level.getSeed(), new ChunkPos(VecHelper.toBlockPos(pos)), 0, (LevelHeightAccessor)level, b -> true);
        if (!start.isValid()) {
            return false;
        }
        BoundingBox bb = start.getBoundingBox();
        ChunkPos minPos = new ChunkPos(SectionPos.blockToSectionCoord((int)bb.minX()), SectionPos.blockToSectionCoord((int)bb.minZ()));
        if (ChunkPos.rangeClosed((ChunkPos)minPos, (ChunkPos)(maxPos = new ChunkPos(SectionPos.blockToSectionCoord((int)bb.maxX()), SectionPos.blockToSectionCoord((int)bb.maxZ())))).anyMatch($$1x -> !level.isLoaded($$1x.getWorldPosition()))) {
            return false;
        }
        ChunkPos.rangeClosed((ChunkPos)minPos, (ChunkPos)maxPos).forEach(chunkPos -> start.placeInChunk((WorldGenLevel)level, level.structureManager(), chunkSource.getGenerator(), level.getRandom(), new BoundingBox(chunkPos.getMinBlockX(), level.getMinBuildHeight(), chunkPos.getMinBlockZ(), chunkPos.getMaxBlockX(), level.getMaxBuildHeight(), chunkPos.getMaxBlockZ()), chunkPos));
        return true;
    }

    @Override
    public boolean place(ServerLocation location) {
        return this.place((ServerWorld)location.world(), location.blockPosition());
    }

    @Override
    public org.spongepowered.api.world.generation.structure.StructureType type() {
        return (org.spongepowered.api.world.generation.structure.StructureType)this.shadow$type();
    }

    @Override
    public Collection<org.spongepowered.api.world.biome.Biome> allowedBiomes() {
        return this.shadow$biomes().stream().map(Holder::value).map(org.spongepowered.api.world.biome.Biome.class::cast).toList();
    }

    @Override
    public Map<EntityCategory, Structure.StructureNaturalSpawner> spawners() {
        return this.shadow$spawnOverrides();
    }

    @Override
    public DecorationStep decorationStep() {
        return (DecorationStep)this.shadow$step();
    }

    @Override
    public DataView toContainer() {
        RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)SpongeCommon.server().registryAccess());
        JsonElement serialized = (JsonElement)this.api$codec().encodeStart((DynamicOps)ops, (Object)((Structure)this)).getOrThrow(false, e -> {});
        try {
            return DataFormats.JSON.get().read(serialized.toString());
        }
        catch (IOException e2) {
            throw new IllegalStateException("Could not read deserialized Structure:\n" + serialized, e2);
        }
    }

    private <T extends Structure> Codec<T> api$codec() {
        StructureType<?> type = this.shadow$type();
        return type.codec();
    }
}

