/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level.saveddata;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.spongepowered.api.map.MapInfo;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.world.storage.MapDecorationBridge;

@Mixin(value={MapDecoration.class})
public abstract class MapDecorationMixin
implements MapDecorationBridge {
    private final Set<MapItemSavedData> impl$attachedMapDatas = new HashSet<MapItemSavedData>();
    private boolean impl$isPersistent;
    private String impl$key = "sponge-" + UUID.randomUUID().toString();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void impl$setPersistenceOnInit(MapDecoration.Type typeIn, byte x, byte y, byte rot, Component name, CallbackInfo ci) {
        switch (typeIn) {
            case PLAYER: 
            case PLAYER_OFF_MAP: 
            case PLAYER_OFF_LIMITS: 
            case FRAME: {
                this.impl$isPersistent = false;
                break;
            }
            default: {
                this.impl$isPersistent = true;
            }
        }
    }

    @Override
    public void bridge$setPersistent(boolean persistent) {
        this.impl$isPersistent = persistent;
    }

    @Override
    public boolean bridge$isPersistent() {
        return this.impl$isPersistent;
    }

    @Override
    public void bridge$setKey(String key) {
        this.impl$key = key;
    }

    @Override
    public String bridge$getKey() {
        return this.impl$key;
    }

    @Override
    public void notifyAddedToMap(MapInfo mapInfo) {
        this.impl$attachedMapDatas.add((MapItemSavedData)mapInfo);
    }

    @Override
    public void notifyRemovedFromMap(MapInfo mapInfo) {
        this.impl$attachedMapDatas.remove((MapItemSavedData)mapInfo);
    }

    @Override
    public void bridge$markAllDirty() {
        if (!this.impl$isPersistent) {
            return;
        }
        for (MapItemSavedData mapData : this.impl$attachedMapDatas) {
            mapData.setDirty();
        }
    }
}

