/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.ticks;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.LongPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.LevelTicks;
import net.minecraft.world.ticks.ScheduledTick;
import net.minecraft.world.ticks.TickPriority;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.scheduler.ScheduledUpdate;
import org.spongepowered.api.scheduler.ScheduledUpdateList;
import org.spongepowered.api.scheduler.TaskPriority;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.world.ticks.LevelTicksBridge;
import org.spongepowered.common.bridge.world.ticks.TickNextTickDataBridge;

@Mixin(value={LevelTicks.class})
public abstract class LevelTicksMixin_API<T>
implements ScheduledUpdateList<T> {
    @Shadow
    @Final
    private LongPredicate tickCheck;
    @Shadow
    @Final
    private Long2ObjectMap<LevelChunkTicks<T>> allContainers;
    @Shadow
    @Final
    private List<ScheduledTick<T>> alreadyRunThisTick;

    @Shadow
    public abstract boolean shadow$hasScheduledTick(BlockPos var1, T var2);

    @Shadow
    public abstract void shadow$schedule(ScheduledTick<T> var1);

    @Override
    public ScheduledUpdate<T> schedule(int x, int y, int z, T target, Duration delay, TaskPriority priority) {
        return this.schedule(x, y, z, target, Ticks.ofWallClockTime(Sponge.server(), delay.toMillis(), ChronoUnit.MILLIS));
    }

    @Override
    public ScheduledUpdate<T> schedule(int x, int y, int z, T target, Ticks tickDelay, TaskPriority priority) {
        BlockPos blockPos = new BlockPos(x, y, z);
        long gameTime = ((LevelTicksBridge)((Object)this)).bridge$getGameTime().getAsLong();
        long subCount = ((LevelTicksBridge)((Object)this)).bridge$getNextSubTickCountSupplier().getAsLong();
        ScheduledTick scheduledUpdate = new ScheduledTick(target, blockPos, tickDelay.ticks() + gameTime, (TickPriority)priority, subCount);
        if (!this.tickCheck.test(ChunkPos.asLong((BlockPos)blockPos))) {
            ((TickNextTickDataBridge)scheduledUpdate).bridge$createdByList((LevelTicks)this);
            this.shadow$schedule(scheduledUpdate);
        }
        return (ScheduledUpdate)scheduledUpdate;
    }

    @Override
    public boolean isScheduled(int x, int y, int z, T target) {
        return this.shadow$hasScheduledTick(new BlockPos(x, y, z), target);
    }

    @Override
    public Collection<? extends ScheduledUpdate<T>> scheduledAt(int x, int y, int z) {
        if (!this.alreadyRunThisTick.isEmpty()) {
            return Collections.emptySet();
        }
        long longPos = ChunkPos.asLong((BlockPos)new BlockPos(x, y, z));
        LevelChunkTicks $$2 = (LevelChunkTicks)this.allContainers.get(longPos);
        return $$2.getAll().filter(data -> data.pos().getX() == x && data.pos().getZ() == z && data.pos().getY() == y).map(data -> (ScheduledUpdate)data).toList();
    }
}

